package com.sd2group30.gamingwizard;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.text.Editable;
import android.text.InputType;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

public class RecyclerViewAdapter extends RecyclerView.Adapter<RecyclerViewAdapter.ViewHolder>{
    private static final String TAG = "RecyclerViewAdapter";

    private Context mContext;
    private ArrayList<NPC> characters = new ArrayList<>();

    public RecyclerViewAdapter(Context mContext, ArrayList<NPC> characters) {
        this.mContext = mContext;
        this.characters = characters;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.recycle_item_enemy_layout, parent, false);
        ViewHolder holder = new ViewHolder(view);
        return holder;
    }

    @Override
    public void onBindViewHolder(@NonNull final ViewHolder holder, final int position) {
        Log.d(TAG, "onBindViewHolder: called " + position);

        holder.character_recycle_name.setText(characters.get(position).getName());

        holder.character_constraint_layout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Log.d(TAG, "clicked viewholder position: " + characters.get(position));

                if (!(characters.get(position).isPlayer())) {
                    Intent intent = new Intent(mContext, EnemyInfo.class);
                    intent.putExtra("position", Integer.toString(position));
                    mContext.startActivity(intent);
                }
            }
        });

        holder.initiative_recycle.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                if (holder.initiative_recycle.getText().toString().equalsIgnoreCase(""))
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(holder.getAdapterPosition()).setInitiative(0);
                else
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(holder.getAdapterPosition()).setInitiative(Integer.parseInt(holder.initiative_recycle.getText().toString()));
            }
        });

        holder.enemy_current_hp.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                if (holder.enemy_current_hp.getText().toString().equalsIgnoreCase(""))
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(holder.getAdapterPosition()).setCurrent_hp(0);
                else
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(holder.getAdapterPosition()).setCurrent_hp(Integer.parseInt(holder.enemy_current_hp.getText().toString()));
            }
        });

        if (characters.get(position).isPlayer()) {
            holder.icon_picture.setImageResource(R.drawable.player_icon);
            holder.enemy_ac.setVisibility(View.INVISIBLE);
            holder.enemy_current_hp.setVisibility(View.INVISIBLE);
            holder.hp_text_nothing.setVisibility(View.INVISIBLE);
            holder.ac_text_nothing.setVisibility(View.INVISIBLE);

            holder.enemy_ac.setText(Integer.toString(characters.get(position).getAc()));
            holder.enemy_current_hp.setText(Integer.toString(characters.get(position).getCurrent_hp()));
            if (MainActivity.offline_mode) {
                holder.character_recycle_name.setFocusable(true);
                holder.character_recycle_name.setEnabled(true);
                holder.character_recycle_name.setClickable(true);
                holder.character_recycle_name.setFocusableInTouchMode(true);
                holder.character_recycle_name.setInputType(InputType.TYPE_CLASS_TEXT);
                holder.character_recycle_name.addTextChangedListener(new TextWatcher() {
                    @Override
                    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                    }

                    @Override
                    public void onTextChanged(CharSequence s, int start, int before, int count) {
                    }

                    @Override
                    public void afterTextChanged(Editable s) {
                        if (holder.character_recycle_name.getText().toString().equalsIgnoreCase(""))
                            GMScreen.encounter_selected.getNpcs_in_encounter().get(holder.getAdapterPosition()).setName("No Player Name");
                        else
                            GMScreen.encounter_selected.getNpcs_in_encounter().get(holder.getAdapterPosition()).setName(holder.character_recycle_name.getText().toString());
                    }
                });
            }
            else {
                holder.character_recycle_name.setFocusable(false);
                holder.character_recycle_name.setEnabled(true);
                holder.character_recycle_name.setClickable(false);
                holder.character_recycle_name.setFocusableInTouchMode(false);
            }
        }
        else {
            holder.character_recycle_name.setFocusable(false);
            holder.character_recycle_name.setEnabled(false);
            holder.character_recycle_name.setClickable(false);
            holder.character_recycle_name.setFocusableInTouchMode(false);
            holder.icon_picture.setImageResource(R.drawable.enemy_icon);
            holder.enemy_ac.setVisibility(View.VISIBLE);
            holder.enemy_current_hp.setVisibility(View.VISIBLE);
            holder.hp_text_nothing.setVisibility(View.VISIBLE);
            holder.ac_text_nothing.setVisibility(View.VISIBLE);

            holder.enemy_ac.setText(Integer.toString(characters.get(position).getAc()));
            holder.enemy_current_hp.setText(Integer.toString(characters.get(position).getCurrent_hp()));
        }

        holder.initiative_recycle.setText(Integer.toString(characters.get(position).getInitiative()));

        if (characters.get(position).isTurn()) {
            if (characters.get(position).isPlayer())
                holder.turn_color.setBackgroundColor(0xFF59B100);
            else
                holder.turn_color.setBackgroundColor(Color.RED);
        }
        else
            holder.turn_color.setBackgroundResource(R.drawable.pale_parchment);
    }

    @Override
    public int getItemCount() {
        return characters.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {

        TextView character_recycle_name;
        TextView turn_color, enemy_current_hp, enemy_ac, hp_text_nothing, ac_text_nothing;
        EditText initiative_recycle;
        ImageButton icon_picture;
        ConstraintLayout character_constraint_layout;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            character_recycle_name = itemView.findViewById(R.id.recycler_character_name);
            character_constraint_layout = itemView.findViewById(R.id.character_constraint_layout);
            turn_color = itemView.findViewById(R.id.turn_color);
            icon_picture = itemView.findViewById(R.id.icon_picture);
            initiative_recycle = itemView.findViewById(R.id.initiative_recycle);
            enemy_current_hp = itemView.findViewById(R.id.enemy_current_hp);
            enemy_ac = itemView.findViewById(R.id.enemy_ac);
            hp_text_nothing = itemView.findViewById(R.id.hp_text_nothing);
            ac_text_nothing = itemView.findViewById(R.id.ac_text_nothing);
        }
    }
}
