package com.sd2group30.gamingwizard;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatDialogFragment;

public class SpeedDialog extends AppCompatDialogFragment {
    private SpeedDialogListener listener;
    TextView speed_dialog;

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        final AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
        LayoutInflater inflater = getActivity().getLayoutInflater();
        final View view = inflater.inflate(R.layout.speed_dialog, null);

        builder.setView(view)
                .setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {

                    }
                })
                .setPositiveButton("Set", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        int changed_speed = 0;
                        if (speed_dialog.getText().toString().equalsIgnoreCase(""))
                            changed_speed = 0;
                        else
                            changed_speed = Integer.parseInt(speed_dialog.getText().toString());


                        listener.makeSpeed(changed_speed);
                    }
                });

        speed_dialog = view.findViewById(R.id.speed_dialog);
        speed_dialog.setText(Integer.toString(PlayerCharacterSheet.character_speed));

        return builder.create();
    }

    @Override
    public void onAttach(Context context) {
        try {
            listener = (SpeedDialogListener) getTargetFragment();
        } catch (ClassCastException e) {
            throw new ClassCastException(context.toString() +
                    " must implement SpeedDialogListener");
        }

        super.onAttach(context);
    }

    public interface SpeedDialogListener {
        void makeSpeed(int new_speed);
    }

}
