package com.sd2group30.gamingwizard.main;


import android.graphics.Color;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.TextView;
import android.widget.Toast;

import androidx.fragment.app.Fragment;

import com.sd2group30.gamingwizard.AbilityScoreDialog;
import com.sd2group30.gamingwizard.PlayerCharacterSheet;
import com.sd2group30.gamingwizard.ProficiencyDialog;
import com.sd2group30.gamingwizard.R;
import com.sd2group30.gamingwizard.RaceClassLevelDialog;

import java.util.Random;


public class tab1 extends Fragment implements ProficiencyDialog.ProficiencyDialogListener, AbilityScoreDialog.AbilityScoreDialogListener, RaceClassLevelDialog.RaceClassLevelDialogListener {
    private static final String TAG = "tab1";
    Button d20_quick_roll_stats;
    TextView character_proficiency_sheet, ability_score_background, character_name_sheet, str_score_total_sheet, str_modifier_sheet,
            dex_score_total_sheet, dex_modifier_sheet, con_score_total_sheet, con_modifier_sheet, int_score_total_sheet,
            int_modifier_sheet, wis_score_total_sheet, wis_modifier_sheet, cha_score_total_sheet, cha_modifier_sheet, character_race_class_level_sheet;

    public tab1() {
    }


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.tab_1_stats, container, false);

        String character_race_class_level = PlayerCharacterSheet.character_race + " "
                + PlayerCharacterSheet.character_class + " " + PlayerCharacterSheet.character_level;

        character_name_sheet = view.findViewById(R.id.character_name_sheet);
        character_name_sheet.setText(PlayerCharacterSheet.character_name);

        character_name_sheet.addTextChangedListener(new TextWatcher() {
            public void afterTextChanged(Editable s) {
                if (character_name_sheet.getText().toString().equalsIgnoreCase(""))
                    PlayerCharacterSheet.character_name = "no_name";
                else
                    PlayerCharacterSheet.character_name = character_name_sheet.getText().toString();
            }
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {}
            public void onTextChanged(CharSequence s, int start, int before, int count) {}
        });

        character_race_class_level_sheet = view.findViewById(R.id.character_race_class_level_sheet);
        character_race_class_level_sheet.setText(character_race_class_level);

        character_race_class_level_sheet.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                openRaceClassLevelDialog();
            }
        });

        final TextView character_ac_total_sheet = view.findViewById(R.id.character_ac_total_sheet);
        character_ac_total_sheet.setText(Integer.toString(PlayerCharacterSheet.character_ac_total));

        character_ac_total_sheet.addTextChangedListener(new TextWatcher() {
            public void afterTextChanged(Editable s) {
                if (character_ac_total_sheet.getText().toString().equalsIgnoreCase(""))
                    PlayerCharacterSheet.character_ac_total = 10;
                else
                    PlayerCharacterSheet.character_ac_total = Integer.parseInt(character_ac_total_sheet.getText().toString());
            }
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {}
            public void onTextChanged(CharSequence s, int start, int before, int count) {}
        });

        final TextView character_max_hp_sheet = view.findViewById(R.id.character_max_hp_sheet);
        character_max_hp_sheet.setText(Integer.toString(PlayerCharacterSheet.character_max_hp));

        character_max_hp_sheet.addTextChangedListener(new TextWatcher() {
            public void afterTextChanged(Editable s) {
                if (character_max_hp_sheet.getText().toString().equalsIgnoreCase(""))
                    PlayerCharacterSheet.character_max_hp = 10;
                else
                    PlayerCharacterSheet.character_max_hp = Integer.parseInt(character_max_hp_sheet.getText().toString());
            }
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {}
            public void onTextChanged(CharSequence s, int start, int before, int count) {}
        });

        final TextView character_current_hp_sheet = view.findViewById(R.id.character_current_hp_sheet);
        character_current_hp_sheet.setText(Integer.toString(PlayerCharacterSheet.character_current_hp));

        character_current_hp_sheet.addTextChangedListener(new TextWatcher() {
            public void afterTextChanged(Editable s) {
                if (character_current_hp_sheet.getText().toString().equalsIgnoreCase(""))
                    PlayerCharacterSheet.character_current_hp = 0;
                else
                    PlayerCharacterSheet.character_current_hp = Integer.parseInt(character_current_hp_sheet.getText().toString());
            }
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {}
            public void onTextChanged(CharSequence s, int start, int before, int count) {}
        });

        character_proficiency_sheet = view.findViewById(R.id.character_proficiency_sheet);
        character_proficiency_sheet.setText("+" + PlayerCharacterSheet.character_proficiency);

        character_proficiency_sheet.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                openProficiencyDialog();
            }
        });

        ability_score_background = view.findViewById(R.id.ability_score_background);
        ability_score_background.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                openAbilityScoreDialog();
            }
        });

        str_score_total_sheet = view.findViewById(R.id.str_score_total_sheet);
        str_modifier_sheet = view.findViewById(R.id.str_modifier_sheet);

        dex_score_total_sheet = view.findViewById(R.id.dex_score_total_sheet);
        dex_modifier_sheet = view.findViewById(R.id.dex_modifier_sheet);

        con_score_total_sheet = view.findViewById(R.id.con_score_total_sheet);
        con_modifier_sheet = view.findViewById(R.id.con_modifier_sheet);

        int_score_total_sheet = view.findViewById(R.id.int_score_total_sheet);
        int_modifier_sheet = view.findViewById(R.id.int_modifier_sheet);

        wis_score_total_sheet = view.findViewById(R.id.wis_score_total_sheet);
        wis_modifier_sheet = view.findViewById(R.id.wis_modifier_sheet);

        cha_score_total_sheet = view.findViewById(R.id.cha_score_total_sheet);
        cha_modifier_sheet = view.findViewById(R.id.cha_modifier_sheet);

        updateTab1();

        d20_quick_roll_stats = view.findViewById(R.id.d20_quick_roll_stats);

        d20_quick_roll_stats.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Random random = new Random();
                int d20_roll_result = random.nextInt(20) + 1;
                String d20_roll_result_string;
                if (d20_roll_result == 8 || d20_roll_result == 11 || d20_roll_result == 18)
                    d20_roll_result_string = "You rolled an " + d20_roll_result;
                else
                    d20_roll_result_string = "You rolled a " + d20_roll_result;
                Toast.makeText(getActivity(), d20_roll_result_string ,Toast.LENGTH_SHORT).show();
            }
        });

        return view;
    }

    public void openRaceClassLevelDialog() {
        RaceClassLevelDialog raceClassLevelDialog = new RaceClassLevelDialog();
        raceClassLevelDialog.show(getFragmentManager(), "race_class_level_dialog");
        raceClassLevelDialog.setTargetFragment(tab1.this, 1);
    }

    public void openProficiencyDialog() {
        ProficiencyDialog proficiencyDialog = new ProficiencyDialog();
        proficiencyDialog.show(getFragmentManager(), "proficiency_dialog");
        proficiencyDialog.setTargetFragment(tab1.this, 1);
    }

    public void openAbilityScoreDialog() {
        AbilityScoreDialog abilityScoreDialog = new AbilityScoreDialog();
        abilityScoreDialog.show(getFragmentManager(), "ability_score_dialog");
        abilityScoreDialog.setTargetFragment(tab1.this, 1);
    }

    @Override
    public void makeRaceClassLevel(String new_race, String new_class, int new_level) {
        PlayerCharacterSheet.character_race = new_race;
        PlayerCharacterSheet.character_class = new_class;
        PlayerCharacterSheet.character_level = new_level;

        String new_character_race_class_level = PlayerCharacterSheet.character_race + " "
                + PlayerCharacterSheet.character_class + " " + PlayerCharacterSheet.character_level;
        character_race_class_level_sheet.setText(new_character_race_class_level);
    }

    @Override
    public void makeProficiency(int proficiency_score) {
        PlayerCharacterSheet.character_proficiency = proficiency_score;
        character_proficiency_sheet.setText("+" + PlayerCharacterSheet.character_proficiency);

        updateTab2();
    }

    @Override
    public void makeAbilityScore(int str_score_change, int dex_score_change, int con_score_change, int int_score_change,
                                 int wis_score_change, int cha_score_change) {
        PlayerCharacterSheet.character_str = str_score_change;
        PlayerCharacterSheet.character_dex = dex_score_change;
        PlayerCharacterSheet.character_con = con_score_change;
        PlayerCharacterSheet.character_int = int_score_change;
        PlayerCharacterSheet.character_wis = wis_score_change;
        PlayerCharacterSheet.character_cha = cha_score_change;

        PlayerCharacterSheet.character_str_mod = getAbilityMod(PlayerCharacterSheet.character_str);
        PlayerCharacterSheet.character_dex_mod = getAbilityMod(PlayerCharacterSheet.character_dex);
        PlayerCharacterSheet.character_con_mod = getAbilityMod(PlayerCharacterSheet.character_con);
        PlayerCharacterSheet.character_int_mod = getAbilityMod(PlayerCharacterSheet.character_int);
        PlayerCharacterSheet.character_wis_mod = getAbilityMod(PlayerCharacterSheet.character_wis);
        PlayerCharacterSheet.character_cha_mod = getAbilityMod(PlayerCharacterSheet.character_cha);

        updateTab1();
        updateTab2();
    }

    private int getAbilityMod(int stat) {
        if (stat <= 1)
            return -5;
        else if (stat == 2 || stat == 3)
            return -4;
        else if (stat == 4 || stat == 5)
            return -3;
        else if (stat == 6 || stat == 7)
            return -2;
        else if (stat == 8 || stat == 9)
            return -1;
        else if (stat == 10 || stat == 11)
            return 0;
        else if (stat == 12 || stat == 13)
            return 1;
        else if (stat == 14 || stat == 15)
            return 2;
        else if (stat == 16 || stat == 17)
            return 3;
        else if (stat == 18 || stat == 19)
            return 4;
        else if (stat == 20 || stat == 21)
            return 5;
        else if (stat == 22 || stat == 23)
            return 6;
        else if (stat == 24 || stat == 25)
            return 7;
        else if (stat == 26 || stat == 27)
            return 8;
        else if (stat == 28 || stat == 29)
            return 9;
        else if (stat >= 30)
            return 10;


        return 0;
    }

    private void updateTab1() {
        str_score_total_sheet.setText(Integer.toString(PlayerCharacterSheet.character_str));
        if (PlayerCharacterSheet.character_str_mod <= 0)
            str_modifier_sheet.setText(Integer.toString(PlayerCharacterSheet.character_str_mod));
        else
            str_modifier_sheet.setText("+" + PlayerCharacterSheet.character_str_mod);

        dex_score_total_sheet.setText(Integer.toString(PlayerCharacterSheet.character_dex));
        if (PlayerCharacterSheet.character_dex_mod <= 0)
            dex_modifier_sheet.setText(Integer.toString(PlayerCharacterSheet.character_dex_mod));
        else
            dex_modifier_sheet.setText("+" + PlayerCharacterSheet.character_dex_mod);

        con_score_total_sheet.setText(Integer.toString(PlayerCharacterSheet.character_con));
        if (PlayerCharacterSheet.character_con_mod <= 0)
            con_modifier_sheet.setText(Integer.toString(PlayerCharacterSheet.character_con_mod));
        else
            con_modifier_sheet.setText("+" + PlayerCharacterSheet.character_con_mod);

        int_score_total_sheet.setText(Integer.toString(PlayerCharacterSheet.character_int));
        if (PlayerCharacterSheet.character_int_mod <= 0)
            int_modifier_sheet.setText(Integer.toString(PlayerCharacterSheet.character_int_mod));
        else
            int_modifier_sheet.setText("+" + PlayerCharacterSheet.character_int_mod);

        wis_score_total_sheet.setText(Integer.toString(PlayerCharacterSheet.character_wis));
        if (PlayerCharacterSheet.character_wis_mod <= 0)
            wis_modifier_sheet.setText(Integer.toString(PlayerCharacterSheet.character_wis_mod));
        else
            wis_modifier_sheet.setText("+" + PlayerCharacterSheet.character_wis_mod);

        cha_score_total_sheet.setText(Integer.toString(PlayerCharacterSheet.character_cha));
        if (PlayerCharacterSheet.character_cha_mod <= 0)
            cha_modifier_sheet.setText(Integer.toString(PlayerCharacterSheet.character_cha_mod));
        else
            cha_modifier_sheet.setText("+" + PlayerCharacterSheet.character_cha_mod);
    }

    private void updateTab2() {
        checkIfProficient(PlayerCharacterSheet.str_proficiency, PlayerCharacterSheet.character_str_mod,
                tab2.strength_save_mod, tab2.strength_save);
        checkIfProficient(PlayerCharacterSheet.athletics, PlayerCharacterSheet.character_str_mod,
                tab2.athletics_save_mod, tab2.athletics_save);

        checkIfProficient(PlayerCharacterSheet.dex_proficiency, PlayerCharacterSheet.character_dex_mod,
                tab2.dexterity_save_mod, tab2.dexterity_save);
        checkIfProficient(PlayerCharacterSheet.acrobatics, PlayerCharacterSheet.character_dex_mod,
                tab2.acrobatics_save_mod, tab2.acrobatics_save);
        checkIfProficient(PlayerCharacterSheet.sleight_of_hand, PlayerCharacterSheet.character_dex_mod,
                tab2.sleight_of_hand_save_mod, tab2.sleight_of_hand_save);
        checkIfProficient(PlayerCharacterSheet.stealth, PlayerCharacterSheet.character_dex_mod,
                tab2.stealth_save_mod, tab2.stealth_save);

        checkIfProficient(PlayerCharacterSheet.con_proficiency, PlayerCharacterSheet.character_con_mod,
                tab2.constitution_save_mod, tab2.constitution_save);

        checkIfProficient(PlayerCharacterSheet.int_proficiency, PlayerCharacterSheet.character_int_mod,
                tab2.intelligence_save_mod, tab2.intelligence_save);
        checkIfProficient(PlayerCharacterSheet.arcana, PlayerCharacterSheet.character_int_mod,
                tab2.arcana_save_mod, tab2.arcana_save);
        checkIfProficient(PlayerCharacterSheet.history, PlayerCharacterSheet.character_int_mod,
                tab2.history_save_mod, tab2.history_save);
        checkIfProficient(PlayerCharacterSheet.investigation, PlayerCharacterSheet.character_int_mod,
                tab2.investigation_save_mod, tab2.investigation_save);
        checkIfProficient(PlayerCharacterSheet.nature, PlayerCharacterSheet.character_int_mod,
                tab2.nature_save_mod, tab2.nature_save);
        checkIfProficient(PlayerCharacterSheet.religion, PlayerCharacterSheet.character_int_mod,
                tab2.religion_save_mod, tab2.religion_save);

        checkIfProficient(PlayerCharacterSheet.wis_proficiency, PlayerCharacterSheet.character_wis_mod,
                tab2.wisdom_save_mod, tab2.wisdom_save);
        checkIfProficient(PlayerCharacterSheet.animal_handling, PlayerCharacterSheet.character_wis_mod,
                tab2.animal_handling_save_mod, tab2.animal_handling_save);
        checkIfProficient(PlayerCharacterSheet.insight, PlayerCharacterSheet.character_wis_mod,
                tab2.insight_save_mod, tab2.insight_save);
        checkIfProficient(PlayerCharacterSheet.medicine, PlayerCharacterSheet.character_wis_mod,
                tab2.medicine_save_mod, tab2.medicine_save);
        checkIfProficient(PlayerCharacterSheet.perception, PlayerCharacterSheet.character_wis_mod,
                tab2.perception_save_mod, tab2.perception_save);
        checkIfProficient(PlayerCharacterSheet.survival, PlayerCharacterSheet.character_wis_mod,
                tab2.survival_save_mod, tab2.survival_save);

        checkIfProficient(PlayerCharacterSheet.cha_proficiency, PlayerCharacterSheet.character_cha_mod,
                tab2.charisma_save_mod, tab2.charisma_save);
        checkIfProficient(PlayerCharacterSheet.deception, PlayerCharacterSheet.character_cha_mod,
                tab2.deception_save_mod, tab2.deception_save);
        checkIfProficient(PlayerCharacterSheet.intimidation, PlayerCharacterSheet.character_cha_mod,
                tab2.intimidation_save_mod, tab2.intimidation_save);
        checkIfProficient(PlayerCharacterSheet.performance, PlayerCharacterSheet.character_cha_mod,
                tab2.performance_save_mod, tab2.performance_save);
        checkIfProficient(PlayerCharacterSheet.persuasion, PlayerCharacterSheet.character_cha_mod,
                tab2.persuasion_save_mod, tab2.persuasion_save);
    }

    private void checkIfProficient(boolean bool_proficiency, int character_ability_mod, TextView mod_box, CheckBox save_box) {
        if (bool_proficiency) {
            if ((character_ability_mod + PlayerCharacterSheet.character_proficiency) > 0)
                mod_box.setText("+" + (character_ability_mod + PlayerCharacterSheet.character_proficiency));
            else
                mod_box.setText(Integer.toString(character_ability_mod + PlayerCharacterSheet.character_proficiency));

            // FFA5B7DF is blueSheet
            mod_box.setBackgroundColor(Color.parseColor("#FFA5B7DF"));
            save_box.setBackgroundColor(Color.parseColor("#FFA5B7DF"));
            save_box.setChecked(true);
        }
        else {
            if (character_ability_mod > 0)
                mod_box.setText("+" + character_ability_mod);
            else
                mod_box.setText(Integer.toString(character_ability_mod));

            // FFEBD6C1 is tanSheet
            mod_box.setBackgroundResource(0);
            save_box.setBackgroundResource(0);
            save_box.setChecked(false);
        }
    }
}
