package com.sd2group30.gamingwizard.main;


import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;

import androidx.fragment.app.Fragment;

import com.sd2group30.gamingwizard.Encounter;
import com.sd2group30.gamingwizard.GM;
import com.sd2group30.gamingwizard.GMScreen;
import com.sd2group30.gamingwizard.MainActivity;
import com.sd2group30.gamingwizard.NPC;
import com.sd2group30.gamingwizard.NewEncounterDialog;
import com.sd2group30.gamingwizard.R;
import com.google.gson.Gson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.UUID;


public class tab1gm extends Fragment implements NewEncounterDialog.NewEncounterDialogListener {
    private static final String TAG = "tab1gm";
    LinearLayout encounters_list_linear_layout;
    Button encounters_list_toggle, new_encounter_button;
    TextView textViewSelectMap;
    ScrollView encounters_scrollview;
    LinearLayout.LayoutParams layoutParamsencounters = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT);

    public tab1gm() {
    }


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.gm_tab_1_game, container, false);
//        maps_list_linear_layout = view.findViewById(R.id.maps_list_linear_layout);
        encounters_list_linear_layout = view.findViewById(R.id.encounters_list_linear_layout);
//        maps_list_toggle = view.findViewById(R.id.maps_list_toggle);
        encounters_list_toggle = view.findViewById(R.id.encounters_list_toggle);
        new_encounter_button = view.findViewById(R.id.new_encounter_button);
//        maps_scrollview = view.findViewById(R.id.maps_scrollview);
        encounters_scrollview = view.findViewById(R.id.encounters_scrollview);
        textViewSelectMap = view.findViewById(R.id.textViewSelectMap);

        layoutParamsencounters.setMargins(16, 0, 16, 0);

//        for (String map_name : GMScreen.maps_list) {
//            Button btnTag = new Button(getActivity());
//            btnTag.setId(View.generateViewId());
//            btnTag.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT));
//            btnTag.setTag(map_name);
//            btnTag.setText(map_name);
//            btnTag.setOnClickListener(new View.OnClickListener() {
//                @Override
//                public void onClick(View v) {
//                    Object tag = v.getTag();
//                    Toast.makeText(getActivity(), "Map Name: " + tag, Toast.LENGTH_SHORT).show();
//                }
//            });
//
//            btnTag.setLongClickable(true);
//            btnTag.setOnLongClickListener(new View.OnLongClickListener() {
//                @Override
//                public boolean onLongClick(View v) {
//                    Object tag = v.getTag();
//                    GMScreen.maps_list.remove(tag);
//                    // Tell PC to delete this map
//                    Button deleteThisButton = v.findViewWithTag(tag);
//                    maps_list_linear_layout.removeView(deleteThisButton);
//                    Toast.makeText(getActivity(), "Map deleted", Toast.LENGTH_SHORT).show();
//                    return true;
//                }
//            });
//
//            maps_list_linear_layout.addView(btnTag);
//        }
//
//        maps_list_toggle.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                if (maps_scrollview.getVisibility() == ScrollView.GONE) {
//                    maps_scrollview.setVisibility(ScrollView.VISIBLE);
//                    maps_list_toggle.setText("Close Map List");
//                }
//                else {
//                    maps_list_toggle.setText("Open Map List");
//                    maps_scrollview.setVisibility(ScrollView.GONE);
//                }
//            }
//        });
//
//        if (MainActivity.offline_mode) {
//            maps_list_toggle.setVisibility(View.GONE);
//            textViewSelectMap.setText("Select Encounter");
//        }
//        else {
//            maps_list_toggle.setVisibility(View.VISIBLE);
//            textViewSelectMap.setText("Select Map and Encounter");
//        }

//        maps_list_toggle.setVisibility(View.GONE);
//        textViewSelectMap.setText("Select Encounter");

        encounters_list_toggle.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (encounters_scrollview.getVisibility() == ScrollView.GONE) {
                    encounters_scrollview.setVisibility(ScrollView.VISIBLE);
                    encounters_list_toggle.setText("Close Encounter List");
                }
                else {
                    encounters_scrollview.setVisibility(ScrollView.GONE);
                    encounters_list_toggle.setText("Open Encounter List");
                }
            }
        });

        new_encounter_button.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                openNewEncounterDialog();
            }
        });

        refreshEncounters();

        return view;
    }

    public void openNewEncounterDialog() {
        NewEncounterDialog newEncounterDialog = new NewEncounterDialog();
        newEncounterDialog.show(getFragmentManager(), "new_encounter_dialog");
        newEncounterDialog.setTargetFragment(tab1gm.this, 1);
    }

    @Override
    public void makeNewEncounter(String encounter_name, Integer npc_location1, Integer npc_location2, Integer npc_location3, Integer npc_location4, Integer npc_location5) {
        ArrayList<NPC> npcs_in_encounter = new ArrayList<NPC>();
        Encounter new_encounter = new Encounter("No Name", npcs_in_encounter);

        if (encounter_name.equalsIgnoreCase("")) {
            encounter_name = "No Encounter Name";
        }

        if (npc_location1 >= 0) {
            npcs_in_encounter.add(GMScreen.npcs_list.get(npc_location1));
        }
        if (npc_location2 >= 0) {
            npcs_in_encounter.add(GMScreen.npcs_list.get(npc_location2));
        }
        if (npc_location3 >= 0) {
            npcs_in_encounter.add(GMScreen.npcs_list.get(npc_location3));
        }
        if (npc_location4 >= 0) {
            npcs_in_encounter.add(GMScreen.npcs_list.get(npc_location4));
        }
        if (npc_location5 >= 0) {
            npcs_in_encounter.add(GMScreen.npcs_list.get(npc_location5));
        }

        if (!(npcs_in_encounter.isEmpty())){
            Comparator<NPC> compareByName = new Comparator<NPC>() {
                @Override
                public int compare(NPC o1, NPC o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            };
            Collections.sort(npcs_in_encounter, compareByName);

            new_encounter.setEncounterName(encounter_name);
            for (NPC token : npcs_in_encounter) {
                token.setUnique_character_id("NULL");
                token.setCharacter_x_coordinate(-1);
                token.setCharacter_y_coordinate(-1);
            }

            new_encounter.setNpcs_in_encounter(npcs_in_encounter);

            GMScreen.encounters_list.add(new_encounter);

            Comparator<Encounter> compareByEncounterName = new Comparator<Encounter>() {
                @Override
                public int compare(Encounter o1, Encounter o2) {
                    return o1.getEncounterName().compareToIgnoreCase(o2.getEncounterName());
                }
            };
            Collections.sort(GMScreen.encounters_list, compareByEncounterName);

            refreshEncounters();
        }
        else {
            Toast.makeText(getActivity(), "Encounters must have at least one NPC", Toast.LENGTH_SHORT).show();
        }
    }

    private void refreshEncounters() {
        if(encounters_list_linear_layout.getChildCount() > 0)
            encounters_list_linear_layout.removeAllViews();

        for (Encounter identifier : GMScreen.encounters_list) {
            Button btnTag = new Button(getActivity());
//            btnTag.setId(View.generateViewId());
            btnTag.setTag(identifier);

            btnTag.setText(identifier.getEncounterName());

            encounters_list_linear_layout.addView(btnTag, layoutParamsencounters);

            btnTag.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Object tag = v.getTag();
                    Encounter clicked = GMScreen.encounters_list.get(GMScreen.encounters_list.indexOf(tag));
                    String final_toast = "Encounter Name: " + clicked.getEncounterName() + "\n";

                    for (NPC npc_encountered : clicked.getNpcs_in_encounter()) {
                        String temp = npc_encountered.getName() + "\n";
                        final_toast = final_toast + temp;
                    }

                    Toast.makeText(getActivity(), final_toast.substring(0, final_toast.length() - 1), Toast.LENGTH_SHORT).show();

                    GMScreen.encounter_selected.getNpcs_in_encounter().clear();
                    GMScreen.encounter_selected.setEncounterName(clicked.getEncounterName());
                    ArrayList<String> empty = new ArrayList<String>();
                    for (NPC enemy : clicked.getNpcs_in_encounter()) {
                        NPC tmp = new NPC("No Name",0, 0, 0,0,0,0,0,0,0,0,0,0,empty, false, 0, false, "", 0, 0);
                        ArrayList <String> tmp_attack = new ArrayList<>();
                        tmp.setName(enemy.getName());
                        tmp.setHp(enemy.getHp());
                        tmp.setCurrent_hp(enemy.getCurrent_hp());
                        tmp.setAc(enemy.getAc());
                        tmp.setSpeed(enemy.getSpeed());
                        tmp.setStr_score(enemy.getStr_score());
                        tmp.setDex_score(enemy.getDex_score());
                        tmp.setCon_score(enemy.getCon_score());
                        tmp.setInt_score(enemy.getInt_score());
                        tmp.setWis_score(enemy.getWis_score());
                        tmp.setCha_score(enemy.getCha_score());
                        tmp.setChallenge_score(enemy.getChallenge_score());
                        tmp.setExp_given(enemy.getExp_given());
                        for (String attack : enemy.getNpc_attack_buttons())
                            tmp_attack.add(attack);

                        tmp.setNpc_attack_buttons(tmp_attack);
                        tmp.setPlayer(enemy.isPlayer());
                        tmp.setInitiative(enemy.getInitiative());
                        tmp.setTurn(enemy.isTurn());
                        tmp.setUnique_character_id(UUID.randomUUID().toString());
                        tmp.setCharacter_x_coordinate(-1);
                        tmp.setCharacter_y_coordinate(-1);

                        GMScreen.encounter_selected.getNpcs_in_encounter().add(tmp);
                    }
                    for (NPC player : GMScreen.players_list) {
                        player.setPlayer(true);
                        player.setCharacter_x_coordinate(-1);
                        player.setCharacter_y_coordinate(-1);
                        GMScreen.encounter_selected.getNpcs_in_encounter().add(player);
                    }
                    GMScreen.round_number = 0;
                    GMScreen.turn_number = 0;


                    if (!MainActivity.offline_mode) {
//                        ArrayList<TurnOrderCharacter> list_chars = new ArrayList<>();
//                        GMScreen.turn_order_list.setAction("Update Turn Order");
//                        for (NPC character : GMScreen.encounter_selected.getNpcs_in_encounter()) {
//                            TurnOrderCharacter token = new TurnOrderCharacter("", 0, false, "", false, 0, 0);
//                            token.setName(character.getName());
//                            token.setInitiative(character.getInitiative());
//                            token.setTurn(character.isTurn());
//                            token.setUnique_character_id(character.getUnique_character_id());
//                            token.setPlayer(character.isPlayer());
//                            token.setCharacter_x_coordinate(character.getCharacter_x_coordinate());
//                            token.setCharacter_y_coordinate(character.getCharacter_y_coordinate());
//                            list_chars.add(token);
//                        }
//                        GMScreen.turn_order_list.setTurnOrderCharacters(list_chars);
//
//                        Gson gson = new Gson();
//                        String json = gson.toJson(GMScreen.turn_order_list);
//                        MainActivity.mBluetoothConnection.write(json.getBytes());
////                        try {
////                            Thread.sleep(300);
////                        } catch (InterruptedException e) {
////                            e.printStackTrace();
////                        }
                        selectEncounter();
                    }
                }
            });

            btnTag.setLongClickable(true);
            btnTag.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View v) {
                    Object tag = v.getTag();
                    Encounter clicked = GMScreen.encounters_list.get(GMScreen.encounters_list.indexOf(tag));

                    Button deleteThisButton = encounters_list_linear_layout.findViewWithTag(tag);
                    encounters_list_linear_layout.removeView(deleteThisButton);
                    Toast.makeText(getActivity(), clicked.getEncounterName() + " Encounter Deleted", Toast.LENGTH_SHORT).show();
                    GMScreen.encounters_list.remove(tag);
                    return true;
                }
            });
        }
    }

    private void selectEncounter() {
        ArrayList<NPC> emptynpcs = new ArrayList<>();
        Encounter encounter_selected = new Encounter("No Selected Encounter", emptynpcs);
        ArrayList<String> maps_list = new ArrayList<>(), info_tab_gm = new ArrayList<>();
        ArrayList<NPC> npcs_list = new ArrayList<>(), players_list = new ArrayList<>();
        ArrayList<Encounter> encounters_list = new ArrayList<>();
        GM select_encounter = new GM("", "", 0, 0, encounter_selected, maps_list, info_tab_gm, npcs_list, players_list, encounters_list);

        select_encounter.setBluetooth_id(MainActivity.android_id);
        select_encounter.setAction("Encounter Selected");
        select_encounter.setTurn_number(GMScreen.turn_number);
        select_encounter.setRound_number(GMScreen.round_number);
        select_encounter.setEncounters_list(GMScreen.encounters_list);
        select_encounter.setPlayers_list(GMScreen.players_list);
        select_encounter.setEncounter_selected(GMScreen.encounter_selected);
        select_encounter.setInfo_tab_gm(GMScreen.info_tab_gm);
        select_encounter.setMaps_list(GMScreen.maps_list);
        select_encounter.setNpcs_list(GMScreen.npcs_list);

        Gson gson = new Gson();
        String json = gson.toJson(select_encounter);

        MainActivity.largeLog(TAG, json);

        MainActivity.mBluetoothConnection.write(json.getBytes());
//        try {
//            Thread.sleep(300);
//        } catch (InterruptedException e) {
//            e.printStackTrace();
//        }
    }
}
