package com.sd2group30.gamingwizard.main;


import android.graphics.Color;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import androidx.fragment.app.Fragment;

import com.sd2group30.gamingwizard.PlayerCharacterSheet;
import com.sd2group30.gamingwizard.R;

import java.util.Random;


public class tab2 extends Fragment {
    private static final String TAG = "tab2";
    Spinner skill_dropdown;
    public static TextView charisma_save_mod, strength_save_mod, athletics_save_mod, dexterity_save_mod,
            acrobatics_save_mod, sleight_of_hand_save_mod, stealth_save_mod, wisdom_save_mod,
            animal_handling_save_mod, insight_save_mod, medicine_save_mod, perception_save_mod,
            survival_save_mod, constitution_save_mod, intelligence_save_mod, arcana_save_mod,
            history_save_mod, investigation_save_mod, nature_save_mod, religion_save_mod, deception_save_mod,
            intimidation_save_mod, performance_save_mod, persuasion_save_mod;

    public static CheckBox charisma_save, strength_save, athletics_save, dexterity_save,
            acrobatics_save, sleight_of_hand_save, stealth_save, wisdom_save, animal_handling_save,
            insight_save, medicine_save, perception_save, survival_save, constitution_save, intelligence_save,
            arcana_save, history_save, investigation_save, nature_save, religion_save, deception_save,
            intimidation_save, performance_save, persuasion_save;

    public tab2() {
    }


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        final View view = inflater.inflate(R.layout.tab_2_saves, container, false);

        strength_save = view.findViewById(R.id.strength_save);
        strength_save_mod = view.findViewById(R.id.strength_save_mod);
        athletics_save = view.findViewById(R.id.athletics_save);
        athletics_save_mod = view.findViewById(R.id.athletics_save_mod);

        // boolean bool_proficiency, int character_ability_mod, TextView mod_box, CheckBox save_box
        checkIfProficient(PlayerCharacterSheet.str_proficiency, PlayerCharacterSheet.character_str_mod,
                strength_save_mod, strength_save);
        checkIfProficient(PlayerCharacterSheet.athletics, PlayerCharacterSheet.character_str_mod,
                athletics_save_mod, athletics_save);

        dexterity_save = view.findViewById(R.id.dexterity_save);
        dexterity_save_mod = view.findViewById(R.id.dexterity_save_mod);
        acrobatics_save = view.findViewById(R.id.acrobatics_save);
        acrobatics_save_mod = view.findViewById(R.id.acrobatics_save_mod);
        sleight_of_hand_save = view.findViewById(R.id.sleight_of_hand_save);
        sleight_of_hand_save_mod = view.findViewById(R.id.sleight_of_hand_save_mod);
        stealth_save = view.findViewById(R.id.stealth_save);
        stealth_save_mod = view.findViewById(R.id.stealth_save_mod);

        checkIfProficient(PlayerCharacterSheet.dex_proficiency, PlayerCharacterSheet.character_dex_mod,
                dexterity_save_mod, dexterity_save);
        checkIfProficient(PlayerCharacterSheet.acrobatics, PlayerCharacterSheet.character_dex_mod,
                acrobatics_save_mod, acrobatics_save);
        checkIfProficient(PlayerCharacterSheet.sleight_of_hand, PlayerCharacterSheet.character_dex_mod,
                sleight_of_hand_save_mod, sleight_of_hand_save);
        checkIfProficient(PlayerCharacterSheet.stealth, PlayerCharacterSheet.character_dex_mod,
                stealth_save_mod, stealth_save);

        wisdom_save = view.findViewById(R.id.wisdom_save);
        wisdom_save_mod = view.findViewById(R.id.wisdom_save_mod);
        animal_handling_save = view.findViewById(R.id.animal_handling_save);
        animal_handling_save_mod = view.findViewById(R.id.animal_handling_save_mod);
        insight_save = view.findViewById(R.id.insight_save);
        insight_save_mod = view.findViewById(R.id.insight_save_mod);
        medicine_save = view.findViewById(R.id.medicine_save);
        medicine_save_mod = view.findViewById(R.id.medicine_save_mod);
        perception_save = view.findViewById(R.id.perception_save);
        perception_save_mod = view.findViewById(R.id.perception_save_mod);
        survival_save = view.findViewById(R.id.survival_save);
        survival_save_mod = view.findViewById(R.id.survival_save_mod);

        checkIfProficient(PlayerCharacterSheet.wis_proficiency, PlayerCharacterSheet.character_wis_mod,
                wisdom_save_mod, wisdom_save);
        checkIfProficient(PlayerCharacterSheet.animal_handling, PlayerCharacterSheet.character_wis_mod,
                animal_handling_save_mod, animal_handling_save);
        checkIfProficient(PlayerCharacterSheet.insight, PlayerCharacterSheet.character_wis_mod,
                insight_save_mod, insight_save);
        checkIfProficient(PlayerCharacterSheet.medicine, PlayerCharacterSheet.character_wis_mod,
                medicine_save_mod, medicine_save);
        checkIfProficient(PlayerCharacterSheet.perception, PlayerCharacterSheet.character_wis_mod,
                perception_save_mod, perception_save);
        checkIfProficient(PlayerCharacterSheet.survival, PlayerCharacterSheet.character_wis_mod,
                survival_save_mod, survival_save);

        constitution_save = view.findViewById(R.id.constitution_save);
        constitution_save_mod = view.findViewById(R.id.constitution_save_mod);

        checkIfProficient(PlayerCharacterSheet.con_proficiency, PlayerCharacterSheet.character_con_mod,
                constitution_save_mod, constitution_save);

        intelligence_save = view.findViewById(R.id.intelligence_save);
        intelligence_save_mod = view.findViewById(R.id.intelligence_save_mod);
        arcana_save = view.findViewById(R.id.arcana_save);
        arcana_save_mod = view.findViewById(R.id.arcana_save_mod);
        history_save = view.findViewById(R.id.history_save);
        history_save_mod = view.findViewById(R.id.history_save_mod);
        investigation_save = view.findViewById(R.id.investigation_save);
        investigation_save_mod = view.findViewById(R.id.investigation_save_mod);
        nature_save = view.findViewById(R.id.nature_save);
        nature_save_mod = view.findViewById(R.id.nature_save_mod);
        religion_save = view.findViewById(R.id.religion_save);
        religion_save_mod = view.findViewById(R.id.religion_save_mod);

        checkIfProficient(PlayerCharacterSheet.int_proficiency, PlayerCharacterSheet.character_int_mod,
                intelligence_save_mod, intelligence_save);
        checkIfProficient(PlayerCharacterSheet.arcana, PlayerCharacterSheet.character_int_mod,
                arcana_save_mod, arcana_save);
        checkIfProficient(PlayerCharacterSheet.history, PlayerCharacterSheet.character_int_mod,
                history_save_mod, history_save);
        checkIfProficient(PlayerCharacterSheet.investigation, PlayerCharacterSheet.character_int_mod,
                investigation_save_mod, investigation_save);
        checkIfProficient(PlayerCharacterSheet.nature, PlayerCharacterSheet.character_int_mod,
                nature_save_mod, nature_save);
        checkIfProficient(PlayerCharacterSheet.religion, PlayerCharacterSheet.character_int_mod,
                religion_save_mod, religion_save);

        charisma_save = view.findViewById(R.id.charisma_save);
        charisma_save_mod = view.findViewById(R.id.charisma_save_mod);
        deception_save = view.findViewById(R.id.deception_save);
        deception_save_mod = view.findViewById(R.id.deception_save_mod);
        intimidation_save = view.findViewById(R.id.intimidation_save);
        intimidation_save_mod = view.findViewById(R.id.intimidation_save_mod);
        performance_save = view.findViewById(R.id.performance_save);
        performance_save_mod = view.findViewById(R.id.performance_save_mod);
        persuasion_save = view.findViewById(R.id.persuasion_save);
        persuasion_save_mod = view.findViewById(R.id.persuasion_save_mod);

        checkIfProficient(PlayerCharacterSheet.cha_proficiency, PlayerCharacterSheet.character_cha_mod,
                charisma_save_mod, charisma_save);
        checkIfProficient(PlayerCharacterSheet.deception, PlayerCharacterSheet.character_cha_mod,
                deception_save_mod, deception_save);
        checkIfProficient(PlayerCharacterSheet.intimidation, PlayerCharacterSheet.character_cha_mod,
                intimidation_save_mod, intimidation_save);
        checkIfProficient(PlayerCharacterSheet.performance, PlayerCharacterSheet.character_cha_mod,
                performance_save_mod, performance_save);
        checkIfProficient(PlayerCharacterSheet.persuasion, PlayerCharacterSheet.character_cha_mod,
                persuasion_save_mod, persuasion_save);


        strength_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.str_proficiency = isChecked;

                checkIfProficient(PlayerCharacterSheet.str_proficiency, PlayerCharacterSheet.character_str_mod,
                        strength_save_mod, strength_save);
            }
        });
        athletics_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.athletics = isChecked;

                checkIfProficient(PlayerCharacterSheet.athletics, PlayerCharacterSheet.character_str_mod,
                        athletics_save_mod, athletics_save);
            }
        });
        dexterity_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.dex_proficiency = isChecked;

                checkIfProficient(PlayerCharacterSheet.dex_proficiency, PlayerCharacterSheet.character_dex_mod,
                        dexterity_save_mod, dexterity_save);
            }
        });
        acrobatics_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.acrobatics = isChecked;

                checkIfProficient(PlayerCharacterSheet.acrobatics, PlayerCharacterSheet.character_dex_mod,
                        acrobatics_save_mod, acrobatics_save);
            }
        });
        sleight_of_hand_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.sleight_of_hand = isChecked;

                checkIfProficient(PlayerCharacterSheet.sleight_of_hand, PlayerCharacterSheet.character_dex_mod,
                        sleight_of_hand_save_mod, sleight_of_hand_save);
            }
        });
        stealth_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.stealth = isChecked;

                checkIfProficient(PlayerCharacterSheet.stealth, PlayerCharacterSheet.character_dex_mod,
                        stealth_save_mod, stealth_save);
            }
        });
        wisdom_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.wis_proficiency = isChecked;

                checkIfProficient(PlayerCharacterSheet.wis_proficiency, PlayerCharacterSheet.character_wis_mod,
                        wisdom_save_mod, wisdom_save);
            }
        });
        animal_handling_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.animal_handling = isChecked;

                checkIfProficient(PlayerCharacterSheet.animal_handling, PlayerCharacterSheet.character_wis_mod,
                        animal_handling_save_mod, animal_handling_save);
            }
        });
        insight_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.insight = isChecked;

                checkIfProficient(PlayerCharacterSheet.insight, PlayerCharacterSheet.character_wis_mod,
                        insight_save_mod, insight_save);
            }
        });
        medicine_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.medicine = isChecked;

                checkIfProficient(PlayerCharacterSheet.medicine, PlayerCharacterSheet.character_wis_mod,
                        medicine_save_mod, medicine_save);
            }
        });
        perception_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.perception = isChecked;

                checkIfProficient(PlayerCharacterSheet.perception, PlayerCharacterSheet.character_wis_mod,
                        perception_save_mod, perception_save);
            }
        });
        survival_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.survival = isChecked;

                checkIfProficient(PlayerCharacterSheet.survival, PlayerCharacterSheet.character_wis_mod,
                        survival_save_mod, survival_save);
            }
        });
        constitution_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.con_proficiency = isChecked;

                checkIfProficient(PlayerCharacterSheet.con_proficiency, PlayerCharacterSheet.character_con_mod,
                        constitution_save_mod, constitution_save);
            }
        });
        intelligence_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.int_proficiency = isChecked;

                checkIfProficient(PlayerCharacterSheet.int_proficiency, PlayerCharacterSheet.character_int_mod,
                        intelligence_save_mod, intelligence_save);
            }
        });
        arcana_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.arcana = isChecked;

                checkIfProficient(PlayerCharacterSheet.arcana, PlayerCharacterSheet.character_int_mod,
                        arcana_save_mod, arcana_save);
            }
        });
        history_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.history = isChecked;

                checkIfProficient(PlayerCharacterSheet.history, PlayerCharacterSheet.character_int_mod,
                        history_save_mod, history_save);
            }
        });
        investigation_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.investigation = isChecked;

                checkIfProficient(PlayerCharacterSheet.investigation, PlayerCharacterSheet.character_int_mod,
                        investigation_save_mod, investigation_save);
            }
        });
        nature_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.nature = isChecked;

                checkIfProficient(PlayerCharacterSheet.nature, PlayerCharacterSheet.character_int_mod,
                        nature_save_mod, nature_save);
            }
        });
        religion_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.religion = isChecked;

                checkIfProficient(PlayerCharacterSheet.religion, PlayerCharacterSheet.character_int_mod,
                        religion_save_mod, religion_save);
            }
        });
        charisma_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.cha_proficiency = isChecked;

                checkIfProficient(PlayerCharacterSheet.cha_proficiency, PlayerCharacterSheet.character_cha_mod,
                        charisma_save_mod, charisma_save);
            }
        });
        deception_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.deception = isChecked;

                checkIfProficient(PlayerCharacterSheet.deception, PlayerCharacterSheet.character_cha_mod,
                        deception_save_mod, deception_save);
            }
        });
        intimidation_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.intimidation = isChecked;

                checkIfProficient(PlayerCharacterSheet.intimidation, PlayerCharacterSheet.character_cha_mod,
                        intimidation_save_mod, intimidation_save);
            }
        });
        performance_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.performance = isChecked;

                checkIfProficient(PlayerCharacterSheet.performance, PlayerCharacterSheet.character_cha_mod,
                        performance_save_mod, performance_save);
            }
        });
        persuasion_save.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PlayerCharacterSheet.persuasion = isChecked;

                checkIfProficient(PlayerCharacterSheet.persuasion, PlayerCharacterSheet.character_cha_mod,
                        persuasion_save_mod, persuasion_save);
            }
        });



        final Spinner skill_spinner = view.findViewById(R.id.skill_dropdown);
        ArrayAdapter<String> skill_adapter = new ArrayAdapter<>(
                getActivity(),
                R.layout.support_simple_spinner_dropdown_item,
                getResources().getStringArray(R.array.saves_list)
        );
        skill_adapter.setDropDownViewResource(R.layout.custom_spinner_dropdown);
        skill_spinner.setAdapter(skill_adapter);



        Button skill_roll = view.findViewById(R.id.skill_roll);

        skill_roll.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                skill_dropdown = view.findViewById(R.id.skill_dropdown);
                String selected_skill = skill_dropdown.getSelectedItem().toString();

                if (selected_skill.equalsIgnoreCase("Select Skill")) {
                    Toast.makeText(getActivity(), "Please select a skill first" , Toast.LENGTH_SHORT).show();
                }
                else {
                    Random random = new Random();
                    int save_result = random.nextInt(20) + 1 + getSaveMod(view, selected_skill);
                    String save_result_string = "Your save roll is " + save_result;

                    Toast.makeText(getActivity(), save_result_string , Toast.LENGTH_SHORT).show();
                }
            }
        });

        return view;
    }

    private int getSaveMod(View view, String selected_skill) {
        TextView save_mod;
        String save_mod_string;

        if (selected_skill.equalsIgnoreCase("Acrobatics")) {
            save_mod = view.findViewById(R.id.acrobatics_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Animal Handling")) {
            save_mod = view.findViewById(R.id.animal_handling_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Arcana")) {
            save_mod = view.findViewById(R.id.arcana_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Athletics")) {
            save_mod = view.findViewById(R.id.athletics_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Charisma")) {
            save_mod = view.findViewById(R.id.charisma_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Constitution")) {
            save_mod = view.findViewById(R.id.constitution_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Deception")) {
            save_mod = view.findViewById(R.id.deception_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Dexterity")) {
            save_mod = view.findViewById(R.id.dexterity_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("History")) {
            save_mod = view.findViewById(R.id.history_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Insight")) {
            save_mod = view.findViewById(R.id.insight_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Intelligence")) {
            save_mod = view.findViewById(R.id.intelligence_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Intimidation")) {
            save_mod = view.findViewById(R.id.intimidation_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Investigation")) {
            save_mod = view.findViewById(R.id.investigation_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Medicine")) {
            save_mod = view.findViewById(R.id.medicine_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Nature")) {
            save_mod = view.findViewById(R.id.nature_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Perception")) {
            save_mod = view.findViewById(R.id.perception_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Performance")) {
            save_mod = view.findViewById(R.id.performance_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Persuasion")) {
            save_mod = view.findViewById(R.id.persuasion_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Religion")) {
            save_mod = view.findViewById(R.id.religion_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Sleight of Hand")) {
            save_mod = view.findViewById(R.id.sleight_of_hand_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Stealth")) {
            save_mod = view.findViewById(R.id.stealth_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Strength")) {
            save_mod = view.findViewById(R.id.strength_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Survival")) {
            save_mod = view.findViewById(R.id.survival_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }
        else if (selected_skill.equalsIgnoreCase("Wisdom")) {
            save_mod = view.findViewById(R.id.wisdom_save_mod);
            save_mod_string = save_mod.getText().toString();
            return Integer.parseInt(save_mod_string);
        }

        return 0;
    }

    private void checkIfProficient(boolean bool_proficiency, int character_ability_mod, TextView mod_box, CheckBox save_box) {
        if (bool_proficiency) {
            if ((character_ability_mod + PlayerCharacterSheet.character_proficiency) > 0)
                mod_box.setText("+" + (character_ability_mod + PlayerCharacterSheet.character_proficiency));
            else
                mod_box.setText(Integer.toString(character_ability_mod + PlayerCharacterSheet.character_proficiency));

            // FFA5B7DF is blueSheet
            mod_box.setBackgroundColor(Color.parseColor("#FFA5B7DF"));
            save_box.setBackgroundColor(Color.parseColor("#FFA5B7DF"));
            save_box.setChecked(true);
        }
        else {
            if (character_ability_mod > 0)
                mod_box.setText("+" + character_ability_mod);
            else
                mod_box.setText(Integer.toString(character_ability_mod));

            // FFEBD6C1 is tanSheet
            mod_box.setBackgroundResource(0);
            save_box.setBackgroundResource(0);
            save_box.setChecked(false);
        }
    }


}