package com.sd2group30.gamingwizard.main;


import android.graphics.Color;
import android.os.Bundle;
import android.text.Spannable;
import android.text.SpannableString;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.fragment.app.Fragment;

import com.sd2group30.gamingwizard.GMScreen;
import com.sd2group30.gamingwizard.NPC;
import com.sd2group30.gamingwizard.NewNPCDialog;
import com.sd2group30.gamingwizard.R;
import com.google.android.material.floatingactionbutton.FloatingActionButton;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;


public class tab2gm extends Fragment implements NewNPCDialog.NewNPCDialogListener {
    private static final String TAG = "tab2gm";
    LinearLayout linear_layout_npc;
    int showing_toast = 0;
    FloatingActionButton add_new_npc;
    LinearLayout.LayoutParams layoutParamsnpc = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT);
    LinearLayout.LayoutParams layoutParamsinfo = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT);


    public tab2gm() {
    }


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.gm_tab_2_npc, container, false);

        layoutParamsnpc.setMargins(0, 8, 0, 0);
        layoutParamsinfo.setMargins(32, 0, 32, 16);

        linear_layout_npc = view.findViewById(R.id.linear_layout_npc);

        add_new_npc = view.findViewById(R.id.add_new_npc);
        add_new_npc.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                openNewNPCDialog();
            }
        });

        // Edits NPCs list and adds to layout
        refreshBestiary();

        return view;
    }

    public void openNewNPCDialog() {
        NewNPCDialog newNPCDialog = new NewNPCDialog();
        newNPCDialog.show(getFragmentManager(), "new_npc_dialog");
        newNPCDialog.setTargetFragment(tab2gm.this, 1);
    }

    public void makeNewNPC(String name, Integer ac, Integer hp, Integer current_hp, Integer speed, Integer str_score, Integer dex_score, Integer con_score,
                           Integer int_score, Integer wis_score, Integer cha_score, Integer challenge, Integer exp,
                           String npc_attack_name_string1, Integer npc_damage_num_dice1, Integer npc_type_dice1, String npc_damage_type1, Integer npc_attack_range1, String mod1,
                           String npc_attack_name_string2, Integer npc_damage_num_dice2, Integer npc_type_dice2, String npc_damage_type2, Integer npc_attack_range2, String mod2,
                           String npc_attack_name_string3, Integer npc_damage_num_dice3, Integer npc_type_dice3, String npc_damage_type3, Integer npc_attack_range3, String mod3,
                           String npc_attack_name_string4, Integer npc_damage_num_dice4, Integer npc_type_dice4, String npc_damage_type4, Integer npc_attack_range4, String mod4,
                           String npc_attack_name_string5, Integer npc_damage_num_dice5, Integer npc_type_dice5, String npc_damage_type5, Integer npc_attack_range5, String mod5) {

        ArrayList<String> empty = new ArrayList<>();

        NPC new_npc = new NPC("No Name", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, empty, false, 0, false, "", 0, 0);
        new_npc.setName(name);
        new_npc.setHp(hp);
        new_npc.setCurrent_hp(hp);
        new_npc.setAc(ac);
        new_npc.setSpeed(speed);
        new_npc.setStr_score(str_score);
        new_npc.setDex_score(dex_score);
        new_npc.setCon_score(con_score);
        new_npc.setInt_score(int_score);
        new_npc.setWis_score(wis_score);
        new_npc.setCha_score(cha_score);
        new_npc.setChallenge_score(challenge);
        new_npc.setExp_given(exp);

        ArrayList<String> attack_set = new ArrayList<String>();

        if (!(npc_attack_name_string1.equalsIgnoreCase("skip_attack"))) {
            attack_set.add(npc_attack_name_string1 + ", " + npc_damage_num_dice1 + ", " + npc_type_dice1 + ", " +
                    npc_damage_type1 + ", " + npc_attack_range1 + ", " + mod1);
        }

        if (!(npc_attack_name_string2.equalsIgnoreCase("skip_attack"))) {
            attack_set.add(npc_attack_name_string2 + ", " + npc_damage_num_dice2 + ", " + npc_type_dice2 + ", " +
                    npc_damage_type2 + ", " + npc_attack_range2 + ", " + mod2);
        }

        if (!(npc_attack_name_string3.equalsIgnoreCase("skip_attack"))) {
            attack_set.add(npc_attack_name_string3 + ", " + npc_damage_num_dice3 + ", " + npc_type_dice3 + ", " +
                    npc_damage_type3 + ", " + npc_attack_range3 + ", " + mod3);
        }

        if (!(npc_attack_name_string4.equalsIgnoreCase("skip_attack"))) {
            attack_set.add(npc_attack_name_string4 + ", " + npc_damage_num_dice4 + ", " + npc_type_dice4 + ", " +
                    npc_damage_type4 + ", " + npc_attack_range4 + ", " + mod4);
        }

        if (!(npc_attack_name_string5.equalsIgnoreCase("skip_attack"))) {
            attack_set.add(npc_attack_name_string5 + ", " + npc_damage_num_dice5 + ", " + npc_type_dice5 + ", " +
                    npc_damage_type5 + ", " + npc_attack_range5 + ", " + mod5);
        }

        ArrayList<String> no_duplicates_attack_set = removeDuplicates(attack_set);

        Collections.sort(no_duplicates_attack_set, String.CASE_INSENSITIVE_ORDER);
        new_npc.setNpc_attack_buttons(no_duplicates_attack_set);

        GMScreen.npcs_list.add(new_npc);

        Comparator<NPC> compareByName = new Comparator<NPC>() {
            @Override
            public int compare(NPC o1, NPC o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
        Collections.sort(GMScreen.npcs_list, compareByName);

        refreshBestiary();
    }

    private ArrayList<String> removeDuplicates(ArrayList<String> list) {
        Set<String> set = new LinkedHashSet<>();

        set.addAll(list);
        list.clear();
        list.addAll(set);

        return list;

    }

    private void refreshBestiary() {
        if (linear_layout_npc.getChildCount() > 0)
            linear_layout_npc.removeAllViews();

        for (NPC identifier : GMScreen.npcs_list) {
            Button btnTag = new Button(getActivity());
//            btnTag.setId(View.generateViewId());
            btnTag.setTag(identifier);

            btnTag.setText(identifier.getName() + "  CR:" + identifier.getChallenge_score());
            btnTag.setTextSize(16);

            linear_layout_npc.addView(btnTag, layoutParamsnpc);

            btnTag.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Object tag = v.getTag();
                    NPC clicked = GMScreen.npcs_list.get(GMScreen.npcs_list.indexOf(tag));

                    TextView clicked_info = linear_layout_npc.findViewWithTag(clicked + " info");
                    if (clicked_info.getVisibility() == View.VISIBLE) {
                        clicked_info.setVisibility(View.GONE);
                    } else {
                        clicked_info.setVisibility(View.VISIBLE);
                    }
                }
            });

            btnTag.setLongClickable(true);
            btnTag.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View v) {
                    Object tag = v.getTag();
                    NPC clicked = GMScreen.npcs_list.get(GMScreen.npcs_list.indexOf(tag));

                    TextView clicked_info = linear_layout_npc.findViewWithTag(clicked + " info");
                    linear_layout_npc.removeView(clicked_info);

                    Button deleteThisButton = linear_layout_npc.findViewWithTag(tag);
                    linear_layout_npc.removeView(deleteThisButton);
                    Toast.makeText(getActivity(), clicked.getName() + " NPC Deleted", Toast.LENGTH_SHORT).show();
                    GMScreen.npcs_list.remove(tag);
                    return true;
                }
            });

            TextView btnInfo = new TextView(getActivity());
//            btnInfo.setId(View.generateViewId());
            btnInfo.setTag(identifier + " info");
//            btnInfo.setContentDescription(Integer.toString(btnTag.getId()));
            btnInfo.setGravity(Gravity.CENTER);
            btnInfo.setClickable(false);
            btnInfo.setTextColor(Color.BLACK);

            Spannable info_string = new SpannableString("INFO\n");
            info_string.setSpan(new android.text.style.StyleSpan(android.graphics.Typeface.BOLD), 0, info_string.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
            btnInfo.setText(info_string);

            btnInfo.append(identifier.getHp() + "HP  " + identifier.getAc() + "AC  Speed: " + identifier.getSpeed() + "FT." +
                    "\nChallenge: " + identifier.getChallenge_score() + "  EXP: " + identifier.getExp_given());

            Spannable ability_scores_string = new SpannableString("\n\nABILITY SCORES\n");
            ability_scores_string.setSpan(new android.text.style.StyleSpan(android.graphics.Typeface.BOLD), 0, ability_scores_string.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
            btnInfo.append(ability_scores_string);

            String scores = "STR - " + identifier.getStr_score() + "(" + getModifier(identifier.getStr_score()) + ")   " +
                    "DEX - " + identifier.getDex_score() + "(" + getModifier(identifier.getDex_score()) + ")   " +
                    "CON - " + identifier.getCon_score() + "(" + getModifier(identifier.getCon_score()) + ")" +
                    "\nINT - " + identifier.getInt_score() + "(" + getModifier(identifier.getInt_score()) + ")   " +
                    "WIS - " + identifier.getWis_score() + "(" + getModifier(identifier.getWis_score()) + ")   " +
                    "CHA - " + identifier.getCha_score() + "(" + getModifier(identifier.getCha_score()) + ")";
            btnInfo.append(scores);

            Spannable attacks_string = new SpannableString("\n\nATTACKS");
            attacks_string.setSpan(new android.text.style.StyleSpan(android.graphics.Typeface.BOLD), 0, attacks_string.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
            btnInfo.append(attacks_string);

            int i = 0;
            String added_mod_attack = "STR";
            for (String attack : identifier.getNpc_attack_buttons()) {
                if (i == 0) {
                    String[] splited_strings = attack.split(", ");
                    added_mod_attack = upperCaseMod(splited_strings[5]);
                    String attack_info = "\n" + (splited_strings[0].substring(0, 1).toUpperCase() + splited_strings[0].substring(1)) + "  " + splited_strings[1] + "d" + splited_strings[2]
                            + "  " + (splited_strings[3].substring(0, 1).toUpperCase() + splited_strings[3].substring(1)) +
                            "\nAdded Mod: " + added_mod_attack + "   Range: " + splited_strings[4] + "ft.";

                    btnInfo.append(attack_info);
                    i = 1;
                } else {
                    String[] splited_strings = attack.split(", ");
                    added_mod_attack = upperCaseMod(splited_strings[5]);
                    String attack_info = "\n\n" + (splited_strings[0].substring(0, 1).toUpperCase() + splited_strings[0].substring(1)) + "  " + splited_strings[1] + "d" + splited_strings[2]
                            + "  " + (splited_strings[3].substring(0, 1).toUpperCase() + splited_strings[3].substring(1)) +
                            "\nAdded Mod: " + added_mod_attack + "   Range: " + splited_strings[4] + "ft.";

                    btnInfo.append(attack_info);
                }
            }

            linear_layout_npc.addView(btnInfo, layoutParamsinfo);
            btnInfo.setVisibility(View.GONE);
        }
    }

    private String upperCaseMod(String mod) {
        String upper_mod = "STR";
        if (mod.equalsIgnoreCase("str"))
            upper_mod = "STR";
        else if (mod.equalsIgnoreCase("dex"))
            upper_mod = "DEX";
        else if (mod.equalsIgnoreCase("con"))
            upper_mod = "CON";
        else if (mod.equalsIgnoreCase("int"))
            upper_mod = "INT";
        else if (mod.equalsIgnoreCase("wis"))
            upper_mod = "WIS";
        else if (mod.equalsIgnoreCase("cha"))
            upper_mod = "CHA";

        return upper_mod;
    }

    private String getModifier(int stat) {
        if (stat <= 1)
            return "-5";
        else if (stat == 2 || stat == 3)
            return "-4";
        else if (stat == 4 || stat == 5)
            return "-3";
        else if (stat == 6 || stat == 7)
            return "-2";
        else if (stat == 8 || stat == 9)
            return "-1";
        else if (stat == 10 || stat == 11)
            return "0";
        else if (stat == 12 || stat == 13)
            return "+1";
        else if (stat == 14 || stat == 15)
            return "+2";
        else if (stat == 16 || stat == 17)
            return "+3";
        else if (stat == 18 || stat == 19)
            return "+4";
        else if (stat == 20 || stat == 21)
            return "+5";
        else if (stat == 22 || stat == 23)
            return "+6";
        else if (stat == 24 || stat == 25)
            return "+7";
        else if (stat == 26 || stat == 27)
            return "+8";
        else if (stat == 28 || stat == 29)
            return "+9";
        else if (stat >= 30)
            return "+10";


        return "0";
    }
}