package com.sd2group30.gamingwizard.main;


import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.Toast;

import androidx.fragment.app.Fragment;

import com.sd2group30.gamingwizard.MainActivity;
import com.sd2group30.gamingwizard.NewAttackDialog;
import com.sd2group30.gamingwizard.PlayerCharacterSheet;
import com.sd2group30.gamingwizard.R;
import com.sd2group30.gamingwizard.SpeedDialog;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;


public class tab3 extends Fragment implements NewAttackDialog.NewAttackDialogListener, SpeedDialog.SpeedDialogListener{
    private static final String TAG = "tab3";
    LinearLayout linear_layout_attacks;
    Button move_character, place_character, end_turn_player;

    public tab3() {
    }


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        final View view = inflater.inflate(R.layout.tab_3_action, container, false);
        linear_layout_attacks = view.findViewById(R.id.linear_layout_attacks);

        updatePlayerAttacks();

        move_character = view.findViewById(R.id.move_character);
        move_character.setText("Move " + PlayerCharacterSheet.character_speed + "ft.");
        move_character.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (MainActivity.offline_mode){
                    Toast.makeText(getActivity(), "Character Speed is " + PlayerCharacterSheet.character_speed + "ft.", Toast.LENGTH_SHORT).show();
                }
                else {
                    if (PlayerCharacterSheet.character_turn) {
                        JSONObject move_character_json = new JSONObject();
                        try {
                            move_character_json.put("action", "Move Character");
                            move_character_json.put("speed", PlayerCharacterSheet.character_speed);
                            move_character_json.put("character_x_coordinate", PlayerCharacterSheet.character_x_coordinate);
                            move_character_json.put("character_y_coordinate", PlayerCharacterSheet.character_y_coordinate);
                            move_character_json.put("bluetooth_id", MainActivity.android_id);
                            move_character_json.put("unique_character_id", PlayerCharacterSheet.unique_character_id);
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                        String move_character = move_character_json.toString();

                        MainActivity.mBluetoothConnection.write(move_character.getBytes());
//                        try {
//                            Thread.sleep(300);
//                        } catch (InterruptedException e) {
//                            e.printStackTrace();
//                        }
                    }
                    else {
                        Toast.makeText(getActivity(), "It is not your turn", Toast.LENGTH_SHORT).show();
                    }
                }
            }
        });
        move_character.setLongClickable(true);
        move_character.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {
                openSpeedDialog();
                return true;
            }
        });

        place_character = view.findViewById(R.id.place_character);
        place_character.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (MainActivity.offline_mode) {
                    Toast.makeText(getActivity(), "This will not do anything in offline mode", Toast.LENGTH_SHORT).show();
                }
                else {
                    if (PlayerCharacterSheet.character_turn) {
                        JSONObject changexy_character_json = new JSONObject();
                        try {
                            changexy_character_json.put("action", "MoveXY");
                            changexy_character_json.put("character", "Player");
                            changexy_character_json.put("character_x_coordinate", PlayerCharacterSheet.character_x_coordinate);
                            changexy_character_json.put("character_y_coordinate", PlayerCharacterSheet.character_y_coordinate);
                            changexy_character_json.put("bluetooth_id", MainActivity.android_id);
                            changexy_character_json.put("unique_character_id", PlayerCharacterSheet.unique_character_id);
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                        String changexy_character = changexy_character_json.toString();

                        MainActivity.mBluetoothConnection.write(changexy_character.getBytes());
//                        try {
//                            Thread.sleep(300);
//                        } catch (InterruptedException e) {
//                            e.printStackTrace();
//                        }
                    }
                    else {
                        Toast.makeText(getActivity(), "It is not your turn", Toast.LENGTH_SHORT).show();
                    }
                }
            }
        });

        end_turn_player = view.findViewById(R.id.end_turn_player);
        end_turn_player.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (MainActivity.offline_mode) {
                    Toast.makeText(getActivity(), "This will not do anything in offline mode", Toast.LENGTH_SHORT).show();
                }
                else {
                    if (PlayerCharacterSheet.character_turn) {
                        PlayerCharacterSheet.character_turn = false;
                        Toast.makeText(getActivity(), "Turn ended", Toast.LENGTH_SHORT).show();
                        JSONObject end_character_turn_json = new JSONObject();
                        try {
                            end_character_turn_json.put("action", "Character End Turn");
                            end_character_turn_json.put("bluetooth_id", MainActivity.android_id);
                            end_character_turn_json.put("unique_character_id", PlayerCharacterSheet.unique_character_id);
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                        String end_character_turn = end_character_turn_json.toString();

                        MainActivity.mBluetoothConnection.write(end_character_turn.getBytes());
//                        try {
//                            Thread.sleep(300);
//                        } catch (InterruptedException e) {
//                            e.printStackTrace();
//                        }
                    }
                    else {
                        Toast.makeText(getActivity(), "It is not your turn", Toast.LENGTH_SHORT).show();
                    }
                }
            }
        });

        Button new_attack_button = view.findViewById(R.id.new_attack_button);
        new_attack_button.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                openNewAttackDialog();
            }
        });

        return view;
    }

    private ArrayList<String> removeDuplicates(ArrayList<String> list) {
        Set<String> set = new LinkedHashSet<>();

        set.addAll(list);
        list.clear();
        list.addAll(set);

        return list;

    }

    private void updatePlayerAttacks() {
        if(linear_layout_attacks.getChildCount() > 0)
            linear_layout_attacks.removeAllViews();

        removeDuplicates(PlayerCharacterSheet.attack_buttons);
        Collections.sort(PlayerCharacterSheet.attack_buttons, String.CASE_INSENSITIVE_ORDER);

        for (String tag : PlayerCharacterSheet.attack_buttons) {
            Button btnTag = new Button(getActivity());
//            btnTag.setId(View.generateViewId());
            btnTag.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT));
            btnTag.setTag(tag);

            String[] splited_strings = tag.split(", ");

//            splited_strings[0] = attack_name;
//            splited_strings[1] = num_dice
//            splited_strings[2] = type_dice
//            splited_strings[3] = attack_type
//            splited_strings[4] = attack_range
//            splited_strings[5] = proficient
//            splited_strings[6] = mod

            if (splited_strings[5].equalsIgnoreCase("true")) {
                btnTag.setText(splited_strings[0] + "  " + splited_strings[1] + "d" + splited_strings[2]
                        + "  " + splited_strings[3] + "\nAdded Mods: " + splited_strings[6] + ", Prof"
                        + "\nRange: " + splited_strings[4] + "ft.");
            }
            else {
                btnTag.setText(splited_strings[0] + "  " + splited_strings[1] + "d" + splited_strings[2]
                        + "  " + splited_strings[3] + "\nAdded Mod: " + splited_strings[6] + "\nRange: "
                        + splited_strings[4] + "ft.");
            }

            btnTag.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Object tag = v.getTag();
                    String attack_tag = (String) tag;
                    String[] splited_strings = attack_tag.split(", ");
                    Random random = new Random();
                    int attack_roll = 0;
                    for (int i = 0; i < Integer.parseInt(splited_strings[1]); i++) {
                        attack_roll = attack_roll + random.nextInt(Integer.parseInt(splited_strings[2])) + 1;
                    }
                    attack_roll = attack_roll + getDamageMods(splited_strings[5], splited_strings[6]);

                    if (attack_roll < 0)
                        attack_roll = 0;

                    if (MainActivity.offline_mode){
                        Toast.makeText(getActivity(), "You deal " + attack_roll + " " + splited_strings[3] + " damage", Toast.LENGTH_SHORT).show();
                    }
                    else {
                        if (PlayerCharacterSheet.character_turn) {
                            Toast.makeText(getActivity(), "You will deal " + attack_roll + " " + splited_strings[3] + " damage", Toast.LENGTH_SHORT).show();
                            JSONObject player_attack_json = new JSONObject();
                            try {
                                player_attack_json.put("action", "attack");
                                player_attack_json.put("damage_roll", attack_roll);
                                player_attack_json.put("damage_type", splited_strings[3]);
                                player_attack_json.put("range", Integer.parseInt(splited_strings[4]));
                                player_attack_json.put("character_x_coordinate", PlayerCharacterSheet.character_x_coordinate);
                                player_attack_json.put("character_y_coordinate", PlayerCharacterSheet.character_y_coordinate);
                                player_attack_json.put("bluetooth_id", MainActivity.android_id);
                                player_attack_json.put("unique_character_id", PlayerCharacterSheet.unique_character_id);
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                            String player_attack = player_attack_json.toString();

                            MainActivity.mBluetoothConnection.write(player_attack.getBytes());
//                            try {
//                                Thread.sleep(300);
//                            } catch (InterruptedException e) {
//                                e.printStackTrace();
//                            }
                        }
                        else {
                            Toast.makeText(getActivity(), "It is not your turn", Toast.LENGTH_SHORT).show();
                        }
                    }
                }
            });

            btnTag.setLongClickable(true);
            btnTag.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View v) {
                    Object tag = v.getTag();
                    PlayerCharacterSheet.attack_buttons.remove(tag);
                    Button deleteThisButton = v.findViewWithTag(tag);
                    linear_layout_attacks.removeView(deleteThisButton);
                    Toast.makeText(getActivity(), "Attack Deleted", Toast.LENGTH_SHORT).show();
                    return true;
                }
            });
            linear_layout_attacks.addView(btnTag);
        }
    }

    private int getDamageMods(String boolean_proficient, String mod) {
        if (boolean_proficient.equalsIgnoreCase("true")) {
            if (mod.equalsIgnoreCase("str"))
                return PlayerCharacterSheet.character_proficiency + PlayerCharacterSheet.character_str_mod;
            else if (mod.equalsIgnoreCase("dex"))
                return PlayerCharacterSheet.character_proficiency + PlayerCharacterSheet.character_dex_mod;
            else if (mod.equalsIgnoreCase("con"))
                return PlayerCharacterSheet.character_proficiency + PlayerCharacterSheet.character_con_mod;
            else if (mod.equalsIgnoreCase("int"))
                return PlayerCharacterSheet.character_proficiency + PlayerCharacterSheet.character_int_mod;
            else if (mod.equalsIgnoreCase("wis"))
                return PlayerCharacterSheet.character_proficiency + PlayerCharacterSheet.character_wis_mod;
            else if (mod.equalsIgnoreCase("cha"))
                return PlayerCharacterSheet.character_proficiency + PlayerCharacterSheet.character_cha_mod;
        }
        else {
            if (mod.equalsIgnoreCase("str"))
                return PlayerCharacterSheet.character_str_mod;
            else if (mod.equalsIgnoreCase("dex"))
                return PlayerCharacterSheet.character_dex_mod;
            else if (mod.equalsIgnoreCase("con"))
                return PlayerCharacterSheet.character_con_mod;
            else if (mod.equalsIgnoreCase("int"))
                return PlayerCharacterSheet.character_int_mod;
            else if (mod.equalsIgnoreCase("wis"))
                return PlayerCharacterSheet.character_wis_mod;
            else if (mod.equalsIgnoreCase("cha"))
                return PlayerCharacterSheet.character_cha_mod;
        }

        return 0;
    }

    public void openSpeedDialog() {
        SpeedDialog speedDialog = new SpeedDialog();
        speedDialog.show(getFragmentManager(), "speed_dialog");
        speedDialog.setTargetFragment(tab3.this, 1);
    }

    public void openNewAttackDialog() {
        NewAttackDialog newAttackDialog = new NewAttackDialog();
        newAttackDialog.show(getFragmentManager(), "new_attack_dialog");
        newAttackDialog.setTargetFragment(tab3.this, 1);
    }

    @Override
    public void makeNewAttack(String attack_name, int num_dice, int type_dice, String attack_type, int attack_range, boolean proficient, String mod) {
        PlayerCharacterSheet.attack_buttons.add(attack_name + ", " + num_dice + ", " + type_dice + ", " + attack_type + ", " + attack_range + ", " + proficient + ", " + mod);

        updatePlayerAttacks();
    }

    @Override
    public void makeSpeed(int new_speed) {
        Integer rounded = (int) (5*(Math.ceil(Math.abs(new_speed/5))));
        PlayerCharacterSheet.character_speed = rounded;
        move_character.setText("Move " + PlayerCharacterSheet.character_speed + "ft.");
    }
}