package com.sd2group30.gamingwizard.main;


import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.sd2group30.gamingwizard.GMScreen;
import com.sd2group30.gamingwizard.MainActivity;
import com.sd2group30.gamingwizard.NPC;
import com.sd2group30.gamingwizard.R;
import com.sd2group30.gamingwizard.RecyclerViewAdapter;
import com.sd2group30.gamingwizard.TurnOrderCharacter;
import com.google.gson.Gson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;


public class tab3gm extends Fragment {
    private static final String TAG = "tab3gm";
    public static RecyclerViewAdapter adapter;
    Button begin_combat;
    ImageButton next_turn;
    public static TextView round_textview;
    int turn_position = -1;

    public tab3gm() {
    }

    private BroadcastReceiver mReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                String incomingTurnUID = intent.getStringExtra("theTurnUID");
                Log.d(TAG, "tab3gm UID of turn: " + incomingTurnUID);
                boolean character_in_encounter = false;

                for (NPC token_npc : GMScreen.encounter_selected.getNpcs_in_encounter()) {
                    if (token_npc.getUnique_character_id().equalsIgnoreCase(incomingTurnUID)) {
                        character_in_encounter = true;
                        if (token_npc.isTurn()) {
                            for (int i = 0; i < GMScreen.encounter_selected.getNpcs_in_encounter().size(); i++)
                                GMScreen.encounter_selected.getNpcs_in_encounter().get(i).setTurn(false);

                            GMScreen.turn_number = GMScreen.turn_number + 1;
                            if (GMScreen.turn_number >= GMScreen.encounter_selected.getNpcs_in_encounter().size()) {
                                GMScreen.turn_number = 0;
                                GMScreen.round_number = GMScreen.round_number + 1;
                                round_textview.setText("Round " + GMScreen.round_number);
                            }

                            if (!(GMScreen.encounter_selected.getNpcs_in_encounter().isEmpty()))
                                GMScreen.encounter_selected.getNpcs_in_encounter().get(GMScreen.turn_number).setTurn(true);


                            ArrayList<TurnOrderCharacter> list_chars = new ArrayList<>();
                            GMScreen.turn_order_list.setAction("Update Turn Order");
                            for (NPC character : GMScreen.encounter_selected.getNpcs_in_encounter()) {
                                TurnOrderCharacter token = new TurnOrderCharacter("", 0, false, "", false, 0, 0);
                                token.setName(character.getName());
                                token.setInitiative(character.getInitiative());
                                token.setTurn(character.isTurn());
                                token.setUnique_character_id(character.getUnique_character_id());
                                token.setPlayer(character.isPlayer());
                                token.setCharacter_x_coordinate(character.getCharacter_x_coordinate());
                                token.setCharacter_y_coordinate(character.getCharacter_y_coordinate());
                                list_chars.add(token);
                            }
                            GMScreen.turn_order_list.setTurnOrderCharacters(list_chars);

                            Gson gson = new Gson();
                            String json = gson.toJson(GMScreen.turn_order_list);

                            Log.d(TAG, "Changed Turn");

                            MainActivity.mBluetoothConnection.write(json.getBytes());
//                            try {
//                                Thread.sleep(300);
//                            } catch (InterruptedException e) {
//                                e.printStackTrace();
//                            }

                            adapter.notifyDataSetChanged();
                        }
                        else {
                            Log.d(TAG, "It is not this character's turn. This should not happen");
                        }
                    }
                }

                Log.d(TAG, "character_in_encounter: " + character_in_encounter);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.gm_tab_3_turn, container, false);

        initRecyclerView(view);

        round_textview = view.findViewById(R.id.round_textview);
        round_textview.setText("Round " + GMScreen.round_number);
        begin_combat = view.findViewById(R.id.begin_combat);
        begin_combat.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Comparator<NPC> compareByInitiative = new Comparator<NPC>() {
                    @Override
                    public int compare(NPC o1, NPC o2) {
                        return Integer.compare(o2.getInitiative(), o1.getInitiative());
                    }
                };

                Collections.sort(GMScreen.encounter_selected.getNpcs_in_encounter(), compareByInitiative);

                if (!(GMScreen.encounter_selected.getNpcs_in_encounter().isEmpty()))
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(0).setTurn(true);
                for (int i = 1; i < GMScreen.encounter_selected.getNpcs_in_encounter().size(); i++)
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(i).setTurn(false);

                GMScreen.turn_number = 0;
                GMScreen.round_number = 1;
                round_textview.setText("Round " + GMScreen.round_number);

                if (!MainActivity.offline_mode) {
                    ArrayList<TurnOrderCharacter> list_chars = new ArrayList<>();
                    GMScreen.turn_order_list.setAction("Update Turn Order");
                    for (NPC character : GMScreen.encounter_selected.getNpcs_in_encounter()) {
                        TurnOrderCharacter token = new TurnOrderCharacter("", 0, false, "", false, 0, 0);
                        token.setName(character.getName());
                        token.setInitiative(character.getInitiative());
                        token.setTurn(character.isTurn());
                        token.setUnique_character_id(character.getUnique_character_id());
                        token.setPlayer(character.isPlayer());
                        token.setCharacter_x_coordinate(character.getCharacter_x_coordinate());
                        token.setCharacter_y_coordinate(character.getCharacter_y_coordinate());
                        list_chars.add(token);
                    }
                    GMScreen.turn_order_list.setTurnOrderCharacters(list_chars);

                    Gson gson = new Gson();
                    String json = gson.toJson(GMScreen.turn_order_list);

                    MainActivity.mBluetoothConnection.write(json.getBytes());
//                    try {
//                        Thread.sleep(300);
//                    } catch (InterruptedException e) {
//                        e.printStackTrace();
//                    }
                }

                adapter.notifyDataSetChanged();
            }
        });

        next_turn = view.findViewById(R.id.next_turn);
        next_turn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                for (int i = 0; i < GMScreen.encounter_selected.getNpcs_in_encounter().size(); i++)
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(i).setTurn(false);

                GMScreen.turn_number = GMScreen.turn_number + 1;
                if (GMScreen.turn_number >= GMScreen.encounter_selected.getNpcs_in_encounter().size()) {
                    GMScreen.turn_number = 0;
                    GMScreen.round_number = GMScreen.round_number + 1;
                    round_textview.setText("Round " + GMScreen.round_number);
                }

                if (!(GMScreen.encounter_selected.getNpcs_in_encounter().isEmpty()))
                    GMScreen.encounter_selected.getNpcs_in_encounter().get(GMScreen.turn_number).setTurn(true);

                if (!MainActivity.offline_mode) {
                    ArrayList<TurnOrderCharacter> list_chars = new ArrayList<>();
                    GMScreen.turn_order_list.setAction("Update Turn Order");
                    for (NPC character : GMScreen.encounter_selected.getNpcs_in_encounter()) {
                        TurnOrderCharacter token = new TurnOrderCharacter("", 0, false, "", false, 0, 0);
                        token.setName(character.getName());
                        token.setInitiative(character.getInitiative());
                        token.setTurn(character.isTurn());
                        token.setUnique_character_id(character.getUnique_character_id());
                        token.setPlayer(character.isPlayer());
                        token.setCharacter_x_coordinate(character.getCharacter_x_coordinate());
                        token.setCharacter_y_coordinate(character.getCharacter_y_coordinate());
                        list_chars.add(token);
                    }
                    GMScreen.turn_order_list.setTurnOrderCharacters(list_chars);

                    Gson gson = new Gson();
                    String json = gson.toJson(GMScreen.turn_order_list);

                    MainActivity.mBluetoothConnection.write(json.getBytes());
//                    try {
//                        Thread.sleep(300);
//                    } catch (InterruptedException e) {
//                        e.printStackTrace();
//                    }
                }
                adapter.notifyDataSetChanged();
            }
        });

        if (!MainActivity.offline_mode) {
            LocalBroadcastManager.getInstance(getContext()).registerReceiver(mReceiver, new IntentFilter("updateTurns"));
        }

        return view;
    }

    private void initRecyclerView(View view) {
        RecyclerView recyclerView = view.findViewById(R.id.tab3gm_recyclerview);
        adapter = new RecyclerViewAdapter(getContext(), GMScreen.encounter_selected.getNpcs_in_encounter());
        new ItemTouchHelper(itemTouchHelperCallback).attachToRecyclerView(recyclerView);
        recyclerView.setAdapter(adapter);
        recyclerView.setLayoutManager(new LinearLayoutManager(getContext()));
    }

    ItemTouchHelper.SimpleCallback itemTouchHelperCallback = new ItemTouchHelper.SimpleCallback(0, ItemTouchHelper.LEFT) {
        @Override
        public boolean onMove(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, @NonNull RecyclerView.ViewHolder target) {
            return false;
        }

        @Override
        public void onSwiped(@NonNull RecyclerView.ViewHolder viewHolder, int direction) {
            if (GMScreen.encounter_selected.getNpcs_in_encounter().get(viewHolder.getAdapterPosition()).isPlayer())
                Toast.makeText(getContext(), GMScreen.encounter_selected.getNpcs_in_encounter().get(viewHolder.getAdapterPosition()).getName() + " Defeated", Toast.LENGTH_LONG).show();
            else
                Toast.makeText(getContext(), GMScreen.encounter_selected.getNpcs_in_encounter().get(viewHolder.getAdapterPosition()).getName() + " Defeated\nExp Given: " + GMScreen.encounter_selected.getNpcs_in_encounter().get(viewHolder.getAdapterPosition()).getExp_given(), Toast.LENGTH_LONG).show();

            turn_position = -1;
            for (int i = 0; i < GMScreen.encounter_selected.getNpcs_in_encounter().size(); i++) {
                if (GMScreen.encounter_selected.getNpcs_in_encounter().get(i).isTurn()) {
                    turn_position = i;
                }
            }

            if (viewHolder.getAdapterPosition() <= turn_position) {
                GMScreen.turn_number = GMScreen.turn_number - 1;
            }
            GMScreen.encounter_selected.getNpcs_in_encounter().remove(viewHolder.getAdapterPosition());

            if (!MainActivity.offline_mode) {
                ArrayList<TurnOrderCharacter> list_chars = new ArrayList<>();
                GMScreen.turn_order_list.setAction("Update Turn Order");
                for (NPC character : GMScreen.encounter_selected.getNpcs_in_encounter()) {
                    TurnOrderCharacter token = new TurnOrderCharacter("", 0, false, "", false, 0, 0);
                    token.setName(character.getName());
                    token.setInitiative(character.getInitiative());
                    token.setTurn(character.isTurn());
                    token.setUnique_character_id(character.getUnique_character_id());
                    token.setPlayer(character.isPlayer());
                    token.setCharacter_x_coordinate(character.getCharacter_x_coordinate());
                    token.setCharacter_y_coordinate(character.getCharacter_y_coordinate());
                    list_chars.add(token);
                }
                GMScreen.turn_order_list.setTurnOrderCharacters(list_chars);

                Gson gson = new Gson();
                String json = gson.toJson(GMScreen.turn_order_list);

                MainActivity.mBluetoothConnection.write(json.getBytes());
//                try {
//                    Thread.sleep(300);
//                } catch (InterruptedException e) {
//                    e.printStackTrace();
//                }
            }
            adapter.notifyDataSetChanged();
        }
    };
}
