package com.sd2group30.gamingwizard.main;


import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.fragment.app.Fragment;

import com.sd2group30.gamingwizard.DisplayCharactersList;
import com.sd2group30.gamingwizard.MainActivity;
import com.sd2group30.gamingwizard.Player;
import com.sd2group30.gamingwizard.PlayerCharacterSheet;
import com.sd2group30.gamingwizard.R;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;


public class tab4 extends Fragment {
    private static final String TAG = "tab4";
    public static TextView cp_num,sp_num, ep_num, gp_num, pp_num, initiative_box, experience_box, equipment_save_text,
            inventory_save_text, proficienies_save_text, feats_save_text, languages_save_text, notes_save_text,
            background_save_text;
    Player updated_player;
//        info_tab[0] = CP;
//        info_tab[1] = SP;
//        info_tab[2] = EP;
//        info_tab[3] = GP;
//        info_tab[4] = PP;
//        info_tab[5] = Initiative;
//        info_tab[6] = Experience;
//        info_tab[7] = Equipment;
//        info_tab[8] = Inventory;
//        info_tab[9] = Proficiencies;
//        info_tab[10] = Feats;
//        info_tab[11] = Languages;
//        info_tab[12] = Notes;
//        info_tab[13] = Background;

    public tab4() {
    }


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        final View view = inflater.inflate(R.layout.tab_4_info, container, false);
        cp_num = view.findViewById(R.id.cp_num);
        sp_num = view.findViewById(R.id.sp_num);
        ep_num = view.findViewById(R.id.ep_num);
        gp_num = view.findViewById(R.id.gp_num);
        pp_num = view.findViewById(R.id.pp_num);

        initiative_box = view.findViewById(R.id.initiative_box);
        experience_box = view.findViewById(R.id.experience_box);

        equipment_save_text = view.findViewById(R.id.equipment_save_text);
        inventory_save_text = view.findViewById(R.id.inventory_save_text);
        proficienies_save_text = view.findViewById(R.id.proficienies_save_text);
        feats_save_text = view.findViewById(R.id.feats_save_text);
        languages_save_text = view.findViewById(R.id.languages_save_text);
        notes_save_text = view.findViewById(R.id.notes_save_text);
        background_save_text = view.findViewById(R.id.background_save_text);

        cp_num.setText(PlayerCharacterSheet.info_tab.get(0));
        sp_num.setText(PlayerCharacterSheet.info_tab.get(1));
        ep_num.setText(PlayerCharacterSheet.info_tab.get(2));
        gp_num.setText(PlayerCharacterSheet.info_tab.get(3));
        pp_num.setText(PlayerCharacterSheet.info_tab.get(4));

        initiative_box.setText(PlayerCharacterSheet.info_tab.get(5));
        experience_box.setText(PlayerCharacterSheet.info_tab.get(6));

        equipment_save_text.setText(PlayerCharacterSheet.info_tab.get(7));
        inventory_save_text.setText(PlayerCharacterSheet.info_tab.get(8));
        proficienies_save_text.setText(PlayerCharacterSheet.info_tab.get(9));
        feats_save_text.setText(PlayerCharacterSheet.info_tab.get(10));
        languages_save_text.setText(PlayerCharacterSheet.info_tab.get(11));
        notes_save_text.setText(PlayerCharacterSheet.info_tab.get(12));
        background_save_text.setText(PlayerCharacterSheet.info_tab.get(13));

        Button update_character = view.findViewById(R.id.update_character);

        update_character.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                PlayerCharacterSheet.info_tab.set(0, cp_num.getText().toString());
                PlayerCharacterSheet.info_tab.set(1, sp_num.getText().toString());
                PlayerCharacterSheet.info_tab.set(2, ep_num.getText().toString());
                PlayerCharacterSheet.info_tab.set(3, gp_num.getText().toString());
                PlayerCharacterSheet.info_tab.set(4, pp_num.getText().toString());

                PlayerCharacterSheet.info_tab.set(5, initiative_box.getText().toString());
                PlayerCharacterSheet.info_tab.set(6, experience_box.getText().toString());

                PlayerCharacterSheet.info_tab.set(7, equipment_save_text.getText().toString());
                PlayerCharacterSheet.info_tab.set(8, inventory_save_text.getText().toString());
                PlayerCharacterSheet.info_tab.set(9, proficienies_save_text.getText().toString());
                PlayerCharacterSheet.info_tab.set(10, feats_save_text.getText().toString());
                PlayerCharacterSheet.info_tab.set(11, languages_save_text.getText().toString());
                PlayerCharacterSheet.info_tab.set(12, notes_save_text.getText().toString());
                PlayerCharacterSheet.info_tab.set(13, background_save_text.getText().toString());

                if (MainActivity.offline_mode) {
                    saveOfflinePlayerData();
                    Toast.makeText(getActivity(), "Player Information Saved", Toast.LENGTH_SHORT).show();
                }
                else {
                    saveOnlinePlayerData();
                    Toast.makeText(getActivity(), "Player Information Saved to PC", Toast.LENGTH_SHORT).show();
                }
            }
        });

        return view;
    }

    private void saveOfflinePlayerData() {
        DisplayCharactersList.player_list.remove(DisplayCharactersList.player_selected);
        ArrayList<String> updated_attacks_list = new ArrayList<>();
        ArrayList<String> updated_info_list = new ArrayList<>();

        updated_player = new Player("","","","","", 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,false,false,false,false,
                false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,
                false,false,false,false,false,false,updated_attacks_list,updated_info_list, "", 0, 0);

        updated_player.setCharacter_name(PlayerCharacterSheet.character_name);
        updated_player.setCharacter_race(PlayerCharacterSheet.character_race);
        updated_player.setCharacter_class(PlayerCharacterSheet.character_class);
        updated_player.setBluetooth_id(MainActivity.android_id);
        updated_player.setAction("Update Character");
        updated_player.setCharacter_level(PlayerCharacterSheet.character_level);
        updated_player.setCharacter_ac_total(PlayerCharacterSheet.character_ac_total);
        updated_player.setCharacter_max_hp(PlayerCharacterSheet.character_max_hp);
        updated_player.setCharacter_current_hp(PlayerCharacterSheet.character_current_hp);
        updated_player.setCharacter_proficiency(PlayerCharacterSheet.character_proficiency);
        updated_player.setCharacter_str(PlayerCharacterSheet.character_str);
        updated_player.setCharacter_str_mod(PlayerCharacterSheet.character_str_mod);
        updated_player.setCharacter_dex(PlayerCharacterSheet.character_dex);
        updated_player.setCharacter_dex_mod(PlayerCharacterSheet.character_dex_mod);
        updated_player.setCharacter_con(PlayerCharacterSheet.character_con);
        updated_player.setCharacter_con_mod(PlayerCharacterSheet.character_con_mod);
        updated_player.setCharacter_int(PlayerCharacterSheet.character_int);
        updated_player.setCharacter_int_mod(PlayerCharacterSheet.character_int_mod);
        updated_player.setCharacter_wis(PlayerCharacterSheet.character_wis);
        updated_player.setCharacter_wis_mod(PlayerCharacterSheet.character_wis_mod);
        updated_player.setCharacter_cha(PlayerCharacterSheet.character_cha);
        updated_player.setCharacter_cha_mod(PlayerCharacterSheet.character_cha_mod);
        updated_player.setCharacter_speed(PlayerCharacterSheet.character_speed);
        updated_player.setStr_proficiency(PlayerCharacterSheet.str_proficiency);
        updated_player.setDex_proficiency(PlayerCharacterSheet.dex_proficiency);
        updated_player.setCon_proficiency(PlayerCharacterSheet.con_proficiency);
        updated_player.setInt_proficiency(PlayerCharacterSheet.int_proficiency);
        updated_player.setWis_proficiency(PlayerCharacterSheet.wis_proficiency);
        updated_player.setCha_proficiency(PlayerCharacterSheet.cha_proficiency);
        updated_player.setAcrobatics(PlayerCharacterSheet.acrobatics);
        updated_player.setAnimal_handling(PlayerCharacterSheet.animal_handling);
        updated_player.setArcana(PlayerCharacterSheet.arcana);
        updated_player.setAthletics(PlayerCharacterSheet.athletics);
        updated_player.setDeception(PlayerCharacterSheet.deception);
        updated_player.setHistory(PlayerCharacterSheet.history);
        updated_player.setInsight(PlayerCharacterSheet.insight);
        updated_player.setIntimidation(PlayerCharacterSheet.intimidation);
        updated_player.setInvestigation(PlayerCharacterSheet.investigation);
        updated_player.setMedicine(PlayerCharacterSheet.medicine);
        updated_player.setNature(PlayerCharacterSheet.nature);
        updated_player.setPerception(PlayerCharacterSheet.perception);
        updated_player.setPerformance(PlayerCharacterSheet.performance);
        updated_player.setPersuasion(PlayerCharacterSheet.persuasion);
        updated_player.setReligion(PlayerCharacterSheet.religion);
        updated_player.setSleight_of_hand(PlayerCharacterSheet.sleight_of_hand);
        updated_player.setStealth(PlayerCharacterSheet.stealth);
        updated_player.setSurvival(PlayerCharacterSheet.survival);
        updated_player.setCharacter_turn(PlayerCharacterSheet.character_turn);

        for (String updated_player_attacks : PlayerCharacterSheet.attack_buttons) {
            updated_attacks_list.add(updated_player_attacks);
        }
        updated_player.setAttack_buttons(updated_attacks_list);

        for (String info_tab_player : PlayerCharacterSheet.info_tab) {
            updated_info_list.add(info_tab_player);
        }
        updated_player.setInfo_tab(updated_info_list);
        updated_player.setUnique_character_id((PlayerCharacterSheet.unique_character_id));

        updated_player.setCharacter_x_coordinate(PlayerCharacterSheet.character_x_coordinate);
        updated_player.setCharacter_y_coordinate(PlayerCharacterSheet.character_y_coordinate);

        DisplayCharactersList.player_list.add(updated_player);

        Comparator<Player> compareByName = new Comparator<Player>() {
            @Override
            public int compare(Player o1, Player o2) {
                return o1.getCharacter_name().compareToIgnoreCase(o2.getCharacter_name());
            }
        };
        Collections.sort(DisplayCharactersList.player_list, compareByName);

        SharedPreferences sharedPreferences = this.getActivity().getSharedPreferences("shared preferences", Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(DisplayCharactersList.player_list);
        editor.putString("character_list", json);
        editor.apply();
    }

    private void saveOnlinePlayerData() {
        ArrayList<String> updated_attacks_list = new ArrayList<>();
        ArrayList<String> updated_info_list = new ArrayList<>();

        updated_player = new Player("","","","","", 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,false,false,false,false,
                false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,
                false,false,false,false,false,false,updated_attacks_list,updated_info_list, "", 0, 0);

        updated_player.setCharacter_name(PlayerCharacterSheet.character_name);
        updated_player.setCharacter_race(PlayerCharacterSheet.character_race);
        updated_player.setCharacter_class(PlayerCharacterSheet.character_class);
        updated_player.setBluetooth_id(MainActivity.android_id);
        updated_player.setAction("Update Character");
        updated_player.setCharacter_level(PlayerCharacterSheet.character_level);
        updated_player.setCharacter_ac_total(PlayerCharacterSheet.character_ac_total);
        updated_player.setCharacter_max_hp(PlayerCharacterSheet.character_max_hp);
        updated_player.setCharacter_current_hp(PlayerCharacterSheet.character_current_hp);
        updated_player.setCharacter_proficiency(PlayerCharacterSheet.character_proficiency);
        updated_player.setCharacter_str(PlayerCharacterSheet.character_str);
        updated_player.setCharacter_str_mod(PlayerCharacterSheet.character_str_mod);
        updated_player.setCharacter_dex(PlayerCharacterSheet.character_dex);
        updated_player.setCharacter_dex_mod(PlayerCharacterSheet.character_dex_mod);
        updated_player.setCharacter_con(PlayerCharacterSheet.character_con);
        updated_player.setCharacter_con_mod(PlayerCharacterSheet.character_con_mod);
        updated_player.setCharacter_int(PlayerCharacterSheet.character_int);
        updated_player.setCharacter_int_mod(PlayerCharacterSheet.character_int_mod);
        updated_player.setCharacter_wis(PlayerCharacterSheet.character_wis);
        updated_player.setCharacter_wis_mod(PlayerCharacterSheet.character_wis_mod);
        updated_player.setCharacter_cha(PlayerCharacterSheet.character_cha);
        updated_player.setCharacter_cha_mod(PlayerCharacterSheet.character_cha_mod);
        updated_player.setCharacter_speed(PlayerCharacterSheet.character_speed);
        updated_player.setStr_proficiency(PlayerCharacterSheet.str_proficiency);
        updated_player.setDex_proficiency(PlayerCharacterSheet.dex_proficiency);
        updated_player.setCon_proficiency(PlayerCharacterSheet.con_proficiency);
        updated_player.setInt_proficiency(PlayerCharacterSheet.int_proficiency);
        updated_player.setWis_proficiency(PlayerCharacterSheet.wis_proficiency);
        updated_player.setCha_proficiency(PlayerCharacterSheet.cha_proficiency);
        updated_player.setAcrobatics(PlayerCharacterSheet.acrobatics);
        updated_player.setAnimal_handling(PlayerCharacterSheet.animal_handling);
        updated_player.setArcana(PlayerCharacterSheet.arcana);
        updated_player.setAthletics(PlayerCharacterSheet.athletics);
        updated_player.setDeception(PlayerCharacterSheet.deception);
        updated_player.setHistory(PlayerCharacterSheet.history);
        updated_player.setInsight(PlayerCharacterSheet.insight);
        updated_player.setIntimidation(PlayerCharacterSheet.intimidation);
        updated_player.setInvestigation(PlayerCharacterSheet.investigation);
        updated_player.setMedicine(PlayerCharacterSheet.medicine);
        updated_player.setNature(PlayerCharacterSheet.nature);
        updated_player.setPerception(PlayerCharacterSheet.perception);
        updated_player.setPerformance(PlayerCharacterSheet.performance);
        updated_player.setPersuasion(PlayerCharacterSheet.persuasion);
        updated_player.setReligion(PlayerCharacterSheet.religion);
        updated_player.setSleight_of_hand(PlayerCharacterSheet.sleight_of_hand);
        updated_player.setStealth(PlayerCharacterSheet.stealth);
        updated_player.setSurvival(PlayerCharacterSheet.survival);
        updated_player.setCharacter_turn(PlayerCharacterSheet.character_turn);

        for (String updated_player_attacks : PlayerCharacterSheet.attack_buttons) {
            updated_attacks_list.add(updated_player_attacks);
        }
        updated_player.setAttack_buttons(updated_attacks_list);

        for (String info_tab_player : PlayerCharacterSheet.info_tab) {
            updated_info_list.add(info_tab_player);
        }
        updated_player.setInfo_tab(updated_info_list);
        updated_player.setUnique_character_id((PlayerCharacterSheet.unique_character_id));

        updated_player.setCharacter_x_coordinate(PlayerCharacterSheet.character_x_coordinate);
        updated_player.setCharacter_y_coordinate(PlayerCharacterSheet.character_y_coordinate);

        Gson gson = new Gson();
        String json = gson.toJson(updated_player);

        MainActivity.mBluetoothConnection.write(json.getBytes());
//        try {
//            Thread.sleep(300);
//        } catch (InterruptedException e) {
//            e.printStackTrace();
//        }
    }

}