package com.sd2group30.gamingwizard.main;


import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.fragment.app.Fragment;

import com.sd2group30.gamingwizard.Encounter;
import com.sd2group30.gamingwizard.GM;
import com.sd2group30.gamingwizard.GMScreen;
import com.sd2group30.gamingwizard.MainActivity;
import com.sd2group30.gamingwizard.NPC;
import com.sd2group30.gamingwizard.R;
import com.google.gson.Gson;

import java.util.ArrayList;


public class tab4gm extends Fragment {
    private static final String TAG = "tab4gm";
    public static TextView locations_save_text, people_save_text, factions_save_text, quests_save_text,
            loot_save_text, notesgm_save_text, world_background_save_text;
    GM updated_gm;
//        info_tab[0] = Locations;
//        info_tab[1] = People;
//        info_tab[2] = Factions;
//        info_tab[3] = Quests;
//        info_tab[4] = Loot;
//        info_tab[5] = Notes;
//        info_tab[6] = World Background;

    public tab4gm() {
    }


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.gm_tab_4_info, container, false);

        locations_save_text = view.findViewById(R.id.locations_save_text);
        people_save_text = view.findViewById(R.id.people_save_text);
        factions_save_text = view.findViewById(R.id.factions_save_text);
        quests_save_text = view.findViewById(R.id.quests_save_text);
        loot_save_text = view.findViewById(R.id.loot_save_text);
        notesgm_save_text = view.findViewById(R.id.notesgm_save_text);
        world_background_save_text = view.findViewById(R.id.world_background_save_text);

        locations_save_text.setText(GMScreen.info_tab_gm.get(0));
        people_save_text.setText(GMScreen.info_tab_gm.get(1));
        factions_save_text.setText(GMScreen.info_tab_gm.get(2));
        quests_save_text.setText(GMScreen.info_tab_gm.get(3));
        loot_save_text.setText(GMScreen.info_tab_gm.get(4));
        notesgm_save_text.setText(GMScreen.info_tab_gm.get(5));
        world_background_save_text.setText(GMScreen.info_tab_gm.get(6));

        Button update_gm = view.findViewById(R.id.update_gm);

        update_gm.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                GMScreen.info_tab_gm.set(0, locations_save_text.getText().toString());
                GMScreen.info_tab_gm.set(1, people_save_text.getText().toString());
                GMScreen.info_tab_gm.set(2, factions_save_text.getText().toString());
                GMScreen.info_tab_gm.set(3, quests_save_text.getText().toString());
                GMScreen.info_tab_gm.set(4, loot_save_text.getText().toString());
                GMScreen.info_tab_gm.set(5, notesgm_save_text.getText().toString());
                GMScreen.info_tab_gm.set(6, world_background_save_text.getText().toString());

                if (MainActivity.offline_mode) {
                    saveOfflineGMData();
                    Toast.makeText(getActivity(), "GM Information Saved", Toast.LENGTH_SHORT).show();
                }
                else {
                    saveOnlineGMData();
                    Toast.makeText(getActivity(), "GM Information Saved to PC", Toast.LENGTH_SHORT).show();
                }
            }
        });

        return view;
    }

    private void saveOfflineGMData() {
        ArrayList<NPC> emptynpcs = new ArrayList<>();
        Encounter encounter_selected = new Encounter("No Selected Encounter", emptynpcs);
        ArrayList<String> maps_list = new ArrayList<>(), info_tab_gm = new ArrayList<>();
        ArrayList<NPC> npcs_list = new ArrayList<>(), players_list = new ArrayList<>();
        ArrayList<Encounter> encounters_list = new ArrayList<>();
        updated_gm = new GM("", "", 0, 0, encounter_selected, maps_list, info_tab_gm, npcs_list, players_list, encounters_list);

        updated_gm.setBluetooth_id(MainActivity.android_id);
        updated_gm.setAction("Update GM");
        updated_gm.setTurn_number(GMScreen.turn_number);
        updated_gm.setRound_number(GMScreen.round_number);
        updated_gm.setEncounters_list(GMScreen.encounters_list);
        updated_gm.setPlayers_list(GMScreen.players_list);
        updated_gm.setEncounter_selected(GMScreen.encounter_selected);
        updated_gm.setInfo_tab_gm(GMScreen.info_tab_gm);
        updated_gm.setMaps_list(GMScreen.maps_list);
        updated_gm.setNpcs_list(GMScreen.npcs_list);

        SharedPreferences sharedPreferences = this.getActivity().getSharedPreferences("shared preferences", Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        Gson gson = new Gson();
        String json = gson.toJson(updated_gm);
        largeLog(json);
        int jsonbytes = json.getBytes().length;
        Log.d(TAG, "saveOfflineGMData: size: " + jsonbytes);
        editor.putString("gm_offline", json);
        editor.apply();
    }

    private void saveOnlineGMData() {
        ArrayList<NPC> emptynpcs = new ArrayList<>();
        Encounter encounter_selected = new Encounter("No Selected Encounter", emptynpcs);
        ArrayList<String> maps_list = new ArrayList<>(), info_tab_gm = new ArrayList<>();
        ArrayList<NPC> npcs_list = new ArrayList<>(), players_list = new ArrayList<>();
        ArrayList<Encounter> encounters_list = new ArrayList<>();
        updated_gm = new GM("", "", 0, 0, encounter_selected, maps_list, info_tab_gm, npcs_list, players_list, encounters_list);

        updated_gm.setBluetooth_id(MainActivity.android_id);
        updated_gm.setAction("Update GM");
        updated_gm.setTurn_number(GMScreen.turn_number);
        updated_gm.setRound_number(GMScreen.round_number);
        updated_gm.setEncounters_list(GMScreen.encounters_list);
        updated_gm.setPlayers_list(GMScreen.players_list);
        updated_gm.setEncounter_selected(GMScreen.encounter_selected);
        updated_gm.setInfo_tab_gm(GMScreen.info_tab_gm);
        updated_gm.setMaps_list(GMScreen.maps_list);
        updated_gm.setNpcs_list(GMScreen.npcs_list);

        Gson gson = new Gson();
        String json = gson.toJson(updated_gm);

        MainActivity.mBluetoothConnection.write(json.getBytes());
//        try {
//            Thread.sleep(300);
//        } catch (InterruptedException e) {
//            e.printStackTrace();
//        }
    }

    private void largeLog(String json) {
        if (json.length() > 4000) {
            Log.d(TAG, json.substring(0, 4000));
            largeLog(json.substring(4000));
        }
        else {
            Log.d(TAG, json);
        }
    }

}
