#pragma once
#include <windows.h>
#include <ShObjIdl_core.h>
#include <shobjidl.h> 
#include <locale>
#include <codecvt>

#pragma comment(lib, "Comdlg32.lib")
#pragma comment(lib, "shell32.lib")

PWSTR OpenDialog(std::string defaultpath)//(HINSTANCE hInstance, HINSTANCE, PWSTR pCmdLine, int nCmdShow)
{
	HRESULT hr = CoInitializeEx(NULL, COINIT_APARTMENTTHREADED | COINIT_DISABLE_OLE1DDE);
	IShellItem *psiFolder;

	std::wstring_convert<std::codecvt_utf8_utf16<wchar_t>> converter;
	std::wstring wide = converter.from_bytes(defaultpath);

	LPCWSTR szFilePath = L"C://Users//theka//source//repos//Senior-Design//Senior-Design//images//user_maps";
	//hr = SHCreateItemFromParsingName(szFilePath, NULL, IID_PPV_ARGS(&psiFolder));
	IFileOpenDialog *pFileOpen;

	// Create the FileOpenDialog object.
	hr = CoCreateInstance(CLSID_FileOpenDialog, NULL, CLSCTX_ALL, IID_IFileOpenDialog, reinterpret_cast<void**>(&pFileOpen));

	// Show the Open dialog box.
	hr = pFileOpen->Show(NULL);
	SHCreateItemFromParsingName(wide.c_str(), NULL, IID_PPV_ARGS(&psiFolder));
	pFileOpen->SetFolder(psiFolder);
	// Get the file name from the dialog box.
	IShellItem *pItem;
	hr = pFileOpen->GetResult(&pItem);
	PWSTR pszFilePath;
	hr = pItem->GetDisplayName(SIGDN_FILESYSPATH, &pszFilePath);

	CoTaskMemFree(pszFilePath);
	pItem->Release();
	pFileOpen->Release();
	CoUninitialize();
	return pszFilePath;
}

LPSTR OpenDialog2(std::string path, HWND hwnd)
{
	OPENFILENAMEA ofn;
	char szFile[100];
	memset(szFile, 0, 100);
	// open a file name
	ZeroMemory(&ofn, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.hwndOwner = hwnd;
	ofn.lpstrFile = szFile;
	ofn.lpstrFile[0] = '\0';
	ofn.nMaxFile = sizeof(szFile);
	ofn.lpstrFilter = "All Images\0*.bmp;*.png;*.jpg;\0";
	ofn.nFilterIndex = 1;
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = path.c_str();
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
	int result = GetOpenFileNameA(&ofn);
	if (result == 0)
		return (LPSTR)"";
	return ofn.lpstrFile;
}