#pragma once

#include <Windows.h>

#define FILE_MENU_NEW 1 
#define FILE_MENU_EXIT 2
#define OPTIONS 3
#define RETURN 4
#define ABOUT 7
#define LOGIN 8
#define TESTING 10
#define UPDATE 11
#define PLAY 12
#define REFRESH 13
#define READY 14
#define LOOKUP 15
#define DEVICE_SELECTION 16
#define SEND 17
#define CONNECT 18
#define LOAD_GAME 19
#define GM_BUTTONS 20 // - 24
#define READY_GM 25
#define REFRESH_GM 26
#define OPEN_MAP 27
#define READY_MAP 28
#define SERVER1 29
#define RESUME_GAME 30
#define CHANGE_MAP 31
#define MAIN_MENU_PAUSE 32
#define QUIT_DESKTOP 33
#define SAVE_GAME 34
#define READY_LOAD 35
#define LOAD_BUTTONS 37 // - 41
#define CLINK_BUTTONS 42 // - 46
#define CHLINK_BUTTONS 47 // - 51
#define READY_LINK 52
#define REFRESH_LINK 53
#define READY_GM_LOAD 54
#define NEXT_PAGE 55
#define PREV_PAGE 56
#define DEBUGGING 57
#define DELETE_SAVE 58
#define RETURN_OPITONS 59
#define NEXT_PAGE_DEL 60
#define PREV_PAGE_DEL 61
#define DELETE_GAME_BUTTONS 62 // - 66

// Function prototypes
inline void DetermineMainMenuFunction(LONG ptx, LONG pty, HWND *hwnd);
inline void DeterminePairFunction(LONG ptx, LONG pty, HWND *hwnd);
inline void DetermineGMSelectFunction(LONG ptx, LONG pty, HWND *hwnd);
inline void DetermineLoadFunction(LONG ptx, LONG pty, HWND *hwnd);
inline void DetermineDeleteFunction(LONG ptx, LONG pty, HWND *hwnd);
inline void DetermineGMSelectLoadFunction(LONG ptx, LONG pty, HWND *hwnd);
inline void DetermineMapSelectFunction(LONG ptx, LONG pty, HWND *hwnd);
inline void DetermineOpenFileFunction(LONG ptx, LONG pty, HWND *hwnd);

inline void MouseMove(int x, int y);

// Process point functions
inline void DetermineLoadFunction(LONG ptx, LONG pty, HWND *hwnd)
{
	// Load page Controls
	if (pty >= 641 && pty <= 675)
	{
		// Previous Page
		if (ptx >= 241 && ptx <= 319)
			SendMessageW(*hwnd, WM_COMMAND, PREV_PAGE, NULL);

		// Next Page
		else if (ptx >= 371 && ptx <= 449)
			SendMessageW(*hwnd, WM_COMMAND, NEXT_PAGE, NULL);
	}

	// Screen Controls
	if (pty >= 630 && pty <= 680)
	{
		// Ready
		if(ptx >= 680 && ptx <= 730)
			SendMessageW(*hwnd, WM_COMMAND, READY_LOAD, NULL);
		// Main Menu
		else if(ptx >= 970 && ptx <= 1020)
			SendMessageW(*hwnd, WM_COMMAND, RETURN, NULL);
	}

	//  Game Save buttons
	if (ptx >= 60 && ptx <= 620)
	{
		// Determine if the point is  delete first
		if (ptx >= 560 && ptx <= 600)
		{
			if (pty >= 105 && pty <= 145 && ptx >= 560 && ptx <= 600)
			{
				SendMessageW(*hwnd, WM_COMMAND, DELETE_GAME_BUTTONS, NULL);
				return;
			}
			else if (pty >= 220 && pty <= 260)
			{
				SendMessageW(*hwnd, WM_COMMAND, DELETE_GAME_BUTTONS + 1, NULL);
				return;
			}
			else if (pty >= 335 && pty <= 375)
			{
				SendMessageW(*hwnd, WM_COMMAND, DELETE_GAME_BUTTONS + 2, NULL);
				return;
			}
			else if (pty >= 450 && pty <= 490)
			{
				SendMessageW(*hwnd, WM_COMMAND, DELETE_GAME_BUTTONS + 3, NULL);
				return;
			}
			else if (pty >= 565 && pty <= 605)

			{
				SendMessageW(*hwnd, WM_COMMAND, DELETE_GAME_BUTTONS + 4, NULL);
				return;
			}
		}

		// Then check for a load
		if (pty >= 75 && pty <= 175)
			SendMessageW(*hwnd, WM_COMMAND, LOAD_BUTTONS, NULL);
		else if (pty >= 190 && pty <= 290)
			SendMessageW(*hwnd, WM_COMMAND, LOAD_BUTTONS + 1, NULL);
		else if (pty >= 305 && pty <= 405)
			SendMessageW(*hwnd, WM_COMMAND, LOAD_BUTTONS + 2, NULL);
		else if (pty >= 420 && pty <= 520)
			SendMessageW(*hwnd, WM_COMMAND, LOAD_BUTTONS + 3, NULL);
		else if (pty >= 535 && pty <= 635)
			SendMessageW(*hwnd, WM_COMMAND, LOAD_BUTTONS + 4, NULL);
	}
}

inline void DetermineDeleteFunction(LONG ptx, LONG pty, HWND *hwnd)
{
	// If ptx is between [241, 319] -> prevpage
	// If ptx is between [371, 449] -> nextpage
	// If pty is between [641, 675] -> for both

	// For next / prev
	if (pty >= 641 && pty <= 675)
	{
		if (ptx >= 241 && ptx <= 319)
			SendMessageW(*hwnd, WM_COMMAND, PREV_PAGE_DEL, NULL);

		else if (ptx >= 371 && ptx <= 449)
			SendMessageW(*hwnd, WM_COMMAND, NEXT_PAGE_DEL, NULL);
	}

	if (ptx >= 561 && ptx <= 601)
	{
		if (pty >= 106 && pty <= 146)
			SendMessageW(*hwnd, WM_COMMAND, DELETE_GAME_BUTTONS, NULL);
		else if (pty >= 221 && pty <= 261)
			SendMessageW(*hwnd, WM_COMMAND, DELETE_GAME_BUTTONS + 1, NULL);
		else if (pty >= 336 && pty <= 376)
			SendMessageW(*hwnd, WM_COMMAND, DELETE_GAME_BUTTONS + 2, NULL);
		else if (pty >= 451 && pty <= 491)
			SendMessageW(*hwnd, WM_COMMAND, DELETE_GAME_BUTTONS + 3, NULL);
		else if (pty >= 566 && pty <= 606)
			SendMessageW(*hwnd, WM_COMMAND, DELETE_GAME_BUTTONS + 4, NULL);
	}
}

inline void DetermineMainMenuFunction(LONG ptx, LONG pty, HWND *hwnd)
{
	if (ptx >= 90 && ptx <= 390)
	{
		// Play
		if (pty >= 260 && pty <= 310)
			SendMessageW(*hwnd, WM_COMMAND, PLAY, NULL);
		// Load
		else if (pty >= 320 && pty <= 370)
			SendMessageW(*hwnd, WM_COMMAND, LOAD_GAME, NULL);
		// Options
		else if (pty >= 380 && pty <= 430)
			SendMessageW(*hwnd, WM_COMMAND, OPTIONS, NULL);
		// Quit
		else if (pty >= 440 && pty <= 490)
			SendMessageW(*hwnd, WM_COMMAND, FILE_MENU_EXIT, NULL);
	}
}

inline void DeterminePairFunction(LONG ptx, LONG pty, HWND *hwnd)
{
	if (ptx >= 680 && ptx <= 940)
	{
		// Add New Device
		if(pty >= 220 && pty <= 270)
			SendMessageW(*hwnd, WM_COMMAND, LOOKUP, NULL);
		// Ready
		else if(pty >= 630 && pty <= 680)
			SendMessageW(*hwnd, WM_COMMAND, READY, NULL);
	}

	else if (ptx >= 980 && ptx <= 1240)
	{
		// Refresh
		if (pty >= 220 && pty <= 270)
			SendMessageW(*hwnd, WM_COMMAND, REFRESH, NULL);

		// Main Menu
		else if (pty >= 630 && pty <= 680)
			SendMessageW(*hwnd, WM_COMMAND, RETURN, NULL);
	}
}

inline void DetermineGMSelectFunction(LONG ptx, LONG pty, HWND *hwnd)
{
	// 3 buttons for control
	if (pty >= 630 && pty <= 680)
	{
		// Ready
		if(ptx >= 680 && ptx <= 850)
			SendMessageW(*hwnd, WM_COMMAND, READY_GM, NULL);
		// Refresh
		else if(ptx >= 875 && ptx <= 1045)
			SendMessageW(*hwnd, WM_COMMAND, REFRESH_GM, NULL);
		// Main Menu
		else if(ptx >= 1070 && 1240)
			SendMessageW(*hwnd, WM_COMMAND, RETURN, NULL);
	}

	// Up to 5 buttons for devices
	if (ptx >= 60 && ptx <= 620)
	{
		if(pty >= 75 && pty <= 179)
			SendMessageW(*hwnd, WM_COMMAND, GM_BUTTONS, NULL);
		else if (pty >= 196 && pty <= 300)
			SendMessageW(*hwnd, WM_COMMAND, GM_BUTTONS + 1, NULL);
		else if (pty >= 317 && pty <= 421)
			SendMessageW(*hwnd, WM_COMMAND, GM_BUTTONS + 2, NULL);
		else if (pty >= 438 && pty <= 542)
			SendMessageW(*hwnd, WM_COMMAND, GM_BUTTONS + 3, NULL);
		else if (pty >= 559 && pty <= 663)
			SendMessageW(*hwnd, WM_COMMAND, GM_BUTTONS + 4, NULL);
	}
}

inline void DetermineMapSelectFunction(LONG ptx, LONG pty, HWND *hwnd)
{
	// 3 buttons for control
	if (pty >= 630 && pty <= 680)
	{
		// Ready
		if (ptx >= 680 && ptx <= 850)
			SendMessageW(*hwnd, WM_COMMAND, READY_GM, NULL);
		// Refresh
		else if (ptx >= 875 && ptx <= 1045)
			SendMessageW(*hwnd, WM_COMMAND, REFRESH_GM, NULL);
		// Main Menu
		else if (ptx >= 1070 && 1240)
			SendMessageW(*hwnd, WM_COMMAND, RETURN, NULL);
	}
}

inline void DetermineGMSelectLoadFunction(LONG ptx, LONG pty, HWND *hwnd)
{
	// 3 buttons for control
	if (pty >= 630 && pty <= 680)
	{
		// Ready
		if (ptx >= 680 && ptx <= 850)
			SendMessageW(*hwnd, WM_COMMAND, READY_GM_LOAD, NULL);
		// Refresh
		else if (ptx >= 875 && ptx <= 1045)
			SendMessageW(*hwnd, WM_COMMAND, REFRESH_GM, NULL);
		// Main Menu
		else if (ptx >= 1070 && 1240)
			SendMessageW(*hwnd, WM_COMMAND, RETURN, NULL);
	}

	// Up to 5 buttons for devices
	if (ptx >= 60 && ptx <= 620)
	{
		if (pty >= 75 && pty <= 179)
			SendMessageW(*hwnd, WM_COMMAND, GM_BUTTONS, NULL);
		else if (pty >= 196 && pty <= 300)
			SendMessageW(*hwnd, WM_COMMAND, GM_BUTTONS + 1, NULL);
		else if (pty >= 317 && pty <= 421)
			SendMessageW(*hwnd, WM_COMMAND, GM_BUTTONS + 2, NULL);
		else if (pty >= 438 && pty <= 542)
			SendMessageW(*hwnd, WM_COMMAND, GM_BUTTONS + 3, NULL);
		else if (pty >= 559 && pty <= 663)
			SendMessageW(*hwnd, WM_COMMAND, GM_BUTTONS + 4, NULL);
	}
}

inline void DeterminePopUpFunction(LONG ptx, LONG pty, HWND *hwnd)
{
	// Move mouse to the point
	MouseMove(ptx, pty);

	INPUT ip;

	// Left click
	ip.type = INPUT_MOUSE;
	ip.mi.dx = ptx;
	ip.mi.dy = pty;
	ip.mi.mouseData = 0;
	ip.mi.dwFlags = MOUSEEVENTF_LEFTDOWN;
	ip.mi.time = 0;

	SendInput(1, &ip, sizeof(INPUT));

	// Release left click
	ZeroMemory(&ip, sizeof(INPUT));
	ip.type = INPUT_MOUSE;
	ip.mi.dx = ptx;
	ip.mi.dy = pty;
	ip.mi.dwFlags = MOUSEEVENTF_LEFTUP;
	SendInput(1, &ip, sizeof(INPUT));

	// Move mouse off screen
	MouseMove(0, 0);
}

inline void DeterminePauseFunction(LONG ptx, LONG pty, HWND *hwnd)
{
	if (ptx >= 590 && ptx <= 750)
	{
		// Resume Game
		if (pty >= 275 && pty <= 325)
			SendMessageW(*hwnd, WM_COMMAND, RESUME_GAME, NULL);
		// Load
		else if (pty >= 335 && pty <= 385)
			SendMessageW(*hwnd, WM_COMMAND, SAVE_GAME, NULL);
		// Options
		else if (pty >= 395 && pty <= 445)
			SendMessageW(*hwnd, WM_COMMAND, CHANGE_MAP, NULL);
		// Quit
		else if (pty >= 455 && pty <= 505)
			SendMessageW(*hwnd, WM_COMMAND, MAIN_MENU_PAUSE, NULL);
		// Quit
		else if (pty >= 515 && pty <= 565)
			SendMessageW(*hwnd, WM_COMMAND, QUIT_DESKTOP, NULL);
	}
}

// LeftClick function
inline void LeftClick()
{
	INPUT    Input = { 0 };
	// left down 
	Input.type = INPUT_MOUSE;
	Input.mi.dwFlags = MOUSEEVENTF_LEFTDOWN;
	::SendInput(1, &Input, sizeof(INPUT));

	// left up
	::ZeroMemory(&Input, sizeof(INPUT));
	Input.type = INPUT_MOUSE;
	Input.mi.dwFlags = MOUSEEVENTF_LEFTUP;
	::SendInput(1, &Input, sizeof(INPUT));
}

// MouseMove function
inline void MouseMove(int x, int y)
{
	double fScreenWidth = ::GetSystemMetrics(SM_CXSCREEN) - 1;
	double fScreenHeight = ::GetSystemMetrics(SM_CYSCREEN) - 1;
	double fx = x * (65535.0f / fScreenWidth);
	double fy = y * (65535.0f / fScreenHeight);
	INPUT  Input = { 0 };
	Input.type = INPUT_MOUSE;
	Input.mi.dwFlags = MOUSEEVENTF_MOVE | MOUSEEVENTF_ABSOLUTE;
	Input.mi.dx = fx;
	Input.mi.dy = fy;
	::SendInput(1, &Input, sizeof(INPUT));
}