#pragma once
// To compile with MinGW:
//
//      gcc serial.c -lwinmm -o serial
//

#include <windows.h>
#include <mmsystem.h>
#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>
#include <string.h>

#pragma comment(lib, "winmm.lib")

#define BLUDGEONING_SLASHING 'a'
#define PIERCING 'b'                          
#define NECROTIC 'c'                               
#define THUNDER_LIGHTNING 'e'                                    
#define FIRE_RADIANT 'f'                                
#define COLD 'i'                   
#define FORCE_PSYCHIC 'm'          
#define ACID_POISON 'p'     

// Function Prototypes
HANDLE OpenSerial();
void HandleEffects(HANDLE hSerial, std::string folderpath, std::string damage_type, bool LightFlag);
int SendSerialMessage(HANDLE hSerial, char bytes_to_send[1]);
int ProcessSound(std::string file, char key);
int CloseSerial(HANDLE hSerial);

inline int SerialPlay()
{
	bool close_port = false;

	// Declare variables and structures
	HANDLE hSerial;
	DCB dcbSerialParams = { 0 };
	COMMTIMEOUTS timeouts = { 0 };

	// Open the highest available serial port number
	//fprintf(stderr, "Opening serial port...");
	hSerial = CreateFileA(
		"\\\\.\\COM5", GENERIC_READ | GENERIC_WRITE, 0, NULL,
		OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hSerial == INVALID_HANDLE_VALUE)
	{
		// File failed to open
		return 1;
	}

	// Set device parameters (115200 baud, 1 start bit,
	// 1 stop bit, no parity)
	dcbSerialParams.DCBlength = sizeof(dcbSerialParams);
	if (GetCommState(hSerial, &dcbSerialParams) == 0)
	{
		//fprintf(stderr, "Error getting device state\n");
		CloseHandle(hSerial);
		return 1;
	}

	dcbSerialParams.BaudRate = CBR_115200;
	dcbSerialParams.ByteSize = 8;
	dcbSerialParams.StopBits = ONESTOPBIT;
	dcbSerialParams.Parity = NOPARITY;
	if (SetCommState(hSerial, &dcbSerialParams) == 0)
	{
		//fprintf(stderr, "Error setting device parameters\n");
		CloseHandle(hSerial);
		return 1;
	}

	// Set COM port timeout settings
	timeouts.ReadIntervalTimeout = 50;
	timeouts.ReadTotalTimeoutConstant = 50;
	timeouts.ReadTotalTimeoutMultiplier = 10;
	timeouts.WriteTotalTimeoutConstant = 50;
	timeouts.WriteTotalTimeoutMultiplier = 10;
	if (SetCommTimeouts(hSerial, &timeouts) == 0)
	{
		//fprintf(stderr, "Error setting timeouts\n");
		CloseHandle(hSerial);
		return 1;
	}

	while (close_port == false)
	{
		// Ask for character to send
		char bytes_to_send[1];
		//printf("Enter a command (a = attack, b = bow, c = cast, e = electric, f = fire, i = ice, m = magic missiles, ");
		//printf("\n                 p = poison, 1 - 4 = player 1 - 4, 0 = clear, x = close serial port): ");
		//scanf(" %c", &bytes_to_send[0]);
		if (bytes_to_send[0] == 'x')
		{
			close_port = true;
			break;
		}

		// Send specified text (remaining command line arguments)
		DWORD bytes_written, total_bytes_written = 0;
		//fprintf(stderr, "Sending bytes...");
		// Send Message
		if (!WriteFile(hSerial, bytes_to_send, 1, &bytes_written, NULL))
		{
			//fprintf(stderr, "Error\n");
			CloseHandle(hSerial);
			return 1;
		}
		//fprintf(stderr, "%d bytes written\n", bytes_written);

		// Play the sound on the PC
		if (bytes_to_send[0] == 'a')
		{
			PlaySound(TEXT("sword.wav"), GetModuleHandle(NULL), SND_FILENAME);
		}
		if (bytes_to_send[0] == 'b')
		{
			PlaySound(TEXT("bow.wav"), GetModuleHandle(NULL), SND_FILENAME);
		}
		if (bytes_to_send[0] == 'c')
		{
			PlaySound(TEXT("cast.wav"), GetModuleHandle(NULL), SND_FILENAME);
		}
		if (bytes_to_send[0] == 'e')
		{
			PlaySound(TEXT("electric.wav"), GetModuleHandle(NULL), SND_FILENAME);
		}
		if (bytes_to_send[0] == 'f')
		{
			PlaySound(TEXT("fire.wav"), GetModuleHandle(NULL), SND_FILENAME);
		}
		if (bytes_to_send[0] == 'i')
		{
			PlaySound(TEXT("ice.wav"), GetModuleHandle(NULL), SND_FILENAME);
		}
		if (bytes_to_send[0] == 'm')
		{
			PlaySound(TEXT("mm.wav"), GetModuleHandle(NULL), SND_FILENAME);
		}
		if (bytes_to_send[0] == 'p')
		{
			PlaySound(TEXT("poison.wav"), GetModuleHandle(NULL), SND_FILENAME);
		}
	}
	// Close serial port
	//fprintf(stderr, "Closing serial port...");
	if (CloseHandle(hSerial) == 0)
	{
		//fprintf(stderr, "Error\n");
		return 1;
	}
	//fprintf(stderr, "OK\n");
	return 0;
}

inline HANDLE OpenSerial()
{
	bool close_port = false;

	// Declare variables and structures
	HANDLE hSerial;
	DCB dcbSerialParams = { 0 };
	COMMTIMEOUTS timeouts = { 0 };

	// Open the highest available serial port number
	//fprintf(stderr, "Opening serial port...");
	hSerial = CreateFileA(
		"\\\\.\\COM5", GENERIC_READ | GENERIC_WRITE, 0, NULL,
		OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hSerial == INVALID_HANDLE_VALUE)
	{
		// File failed to open
		return NULL;
	}

	// Set device parameters (115200 baud, 1 start bit,
	// 1 stop bit, no parity)
	dcbSerialParams.DCBlength = sizeof(dcbSerialParams);
	if (GetCommState(hSerial, &dcbSerialParams) == 0)
	{
		//fprintf(stderr, "Error getting device state\n");
		CloseHandle(hSerial);
		return NULL;
	}

	dcbSerialParams.BaudRate = CBR_115200;
	dcbSerialParams.ByteSize = 8;
	dcbSerialParams.StopBits = ONESTOPBIT;
	dcbSerialParams.Parity = NOPARITY;
	if (SetCommState(hSerial, &dcbSerialParams) == 0)
	{
		//fprintf(stderr, "Error setting device parameters\n");
		CloseHandle(hSerial);
		return NULL;
	}

	// Set COM port timeout settings
	timeouts.ReadIntervalTimeout = 50;
	timeouts.ReadTotalTimeoutConstant = 50;
	timeouts.ReadTotalTimeoutMultiplier = 10;
	timeouts.WriteTotalTimeoutConstant = 50;
	timeouts.WriteTotalTimeoutMultiplier = 10;
	if (SetCommTimeouts(hSerial, &timeouts) == 0)
	{
		//fprintf(stderr, "Error setting timeouts\n");
		CloseHandle(hSerial);
		return NULL;
	}

	return hSerial;
}

inline void HandleEffects(HANDLE hSerial, std::string folderpath, std::string damage_type, bool LightFlag)
{
	char key;
	char message[1];
	memset(message, 0, 2);

	std::ofstream myfile;
	myfile.open(folderpath + "logs.txt", std::ofstream::app);
	myfile << "LightFlag: " << LightFlag << std::endl;
	myfile << "Type: " << damage_type << std::endl;

	// Determine the response
	if (damage_type.compare("Bludgeoning") == 0 || damage_type.compare("Slashing") == 0)
		key = BLUDGEONING_SLASHING;
	else if(damage_type.compare("Thunder") == 0 || damage_type.compare("Lightning") == 0)
		key = THUNDER_LIGHTNING;
	else if(damage_type.compare("Fire") == 0 || damage_type.compare("Radiant") == 0)
		key = FIRE_RADIANT;
	else if(damage_type.compare("Force") == 0 || damage_type.compare("Psychic") == 0)
		key = FORCE_PSYCHIC;
	else if(damage_type.compare("Acid") == 0 || damage_type.compare("Poison") == 0)
		key = ACID_POISON;
	else if(damage_type.compare("Piercing") == 0)
		key = PIERCING;
	else if(damage_type.compare("Necrotic") == 0)
		key = NECROTIC;
	else if(damage_type.compare("Cold") == 0)
		key = COLD;
	else
		key = BLUDGEONING_SLASHING;
	
	myfile << "Key: " << key << std::endl;
	myfile << "Message: " << message << std::endl;

	message[0] = key;
	if(LightFlag)
		SendSerialMessage(hSerial, message);
	ProcessSound(folderpath, key);

	return;
}

inline int SendSerialMessage(HANDLE hSerial, char bytes_to_send[1])
{
	DWORD bytes_written, total_bytes_written = 0;
	if (!WriteFile(hSerial, bytes_to_send, 1, &bytes_written, NULL))
	{
		//fprintf(stderr, "Error\n");
		CloseHandle(hSerial);
		return 1;
	}
}

inline int ProcessSound(std::string file, char key)
{
	// Play the sound on the PC
	if (key == BLUDGEONING_SLASHING)
		PlaySoundA((file + "sword.wav").c_str(), GetModuleHandle(NULL), SND_FILENAME);
	else if (key == PIERCING)
		PlaySoundA((file + "bow.wav").c_str(), GetModuleHandle(NULL), SND_FILENAME);
	else if (key == NECROTIC)
		PlaySoundA((file + "cast.wav").c_str(), GetModuleHandle(NULL), SND_FILENAME);
	else if (key == THUNDER_LIGHTNING)
		PlaySoundA((file + "electric.wav").c_str(), GetModuleHandle(NULL), SND_FILENAME);
	else if (key == FIRE_RADIANT)
		PlaySoundA((file + "fire.wav").c_str(), GetModuleHandle(NULL), SND_FILENAME);
	else if (key == COLD)
		PlaySoundA((file + "ice.wav").c_str(), GetModuleHandle(NULL), SND_FILENAME);
	else if (key == FORCE_PSYCHIC)
		PlaySoundA((file + "mm.wav").c_str(), GetModuleHandle(NULL), SND_FILENAME);
	else if (key == ACID_POISON)
		PlaySoundA((file + "poison.wav").c_str(), GetModuleHandle(NULL), SND_FILENAME);

	return 0;
}

inline int CloseSerial(HANDLE hSerial)
{
	if (CloseHandle(hSerial) == 0)
	{
		//fprintf(stderr, "Error\n");
		return -1;
	}
	return 0;
}