// Includes:
#include "pch.h"

#include <stdlib.h>
#include <stdio.h>
#include <iostream>

#include <Windows.h>
#include <windef.h>
#include <WinSock2.h>
#include <bthsdpdef.h>
#include <bluetoothapis.h>

#include <ws2bth.h>

// Preprocessor Directive: Pragma's:
// Need to link with Ws2_32.lib
#pragma comment(lib, "ws2_32.lib")


// define Directive's:
#define DEFAULT_BUFLEN 512



int __cdecl main(int argc, char **argv)
{


	std::cout << "******************************************************\r\n";

	//--------------------------------------------
	// Locals:
	//--------------------------------------------
	int result = 0;
	ULONG iResult = 0;
	LPTSTR RemoteEndPointMACAddress = (LPTSTR)"38:2D:E8:B9:FA:EB";


	//--------------------------------------------
	// Prep the Buffer's:
	//--------------------------------------------
	int recvbuflen = DEFAULT_BUFLEN;
	char recvbuf[DEFAULT_BUFLEN] = "";
	const char *sendbuf = "AT+COPS?\r";
	int len = (int)strlen(sendbuf);


	//--------------------------------------------
	// Initialise WinSock.
	//--------------------------------------------
	WSADATA WSAData = { 0 };
	WORD wVersionRequested = MAKEWORD(2, 2);
	if ((iResult = WSAStartup(wVersionRequested, &WSAData)) != 0)
	{
	}
	std::cout << "WINSOCK: 'WSAData' Return Code: " << WSAGetLastError() << "\r\n";


	//--------------------------------------------
	// The WinSock Socket.
	//--------------------------------------------
	SOCKET LocalSocket = INVALID_SOCKET;


	//--------------------------------------------
	// Local End Point SOCKADDR_BTH.
	//--------------------------------------------
	SOCKADDR_BTH LocalEndpoint;
	// number of service channel, 0 or BT_PORT_ANY;
	LocalEndpoint.port = 0;
	LocalEndpoint.addressFamily = AF_BTH;
	LocalEndpoint.btAddr = 0;
	LocalEndpoint.serviceClassId = GUID_NULL;
	std::cout << "   Local EndPoint Address: " << LocalEndpoint.btAddr << "\r\n";


	//--------------------------------------------
	// Remote End Point SOCKADDR_BTH.
	//--------------------------------------------
	SOCKADDR_BTH RemoteEndPoint;
	// number of service channel, 0 or BT_PORT_ANY;
	RemoteEndPoint.port = 0;
	RemoteEndPoint.addressFamily = AF_BTH;
	RemoteEndPoint.btAddr = BTH_ADDR(0x382DE8B9FAEB);
	RemoteEndPoint.serviceClassId = HandsfreeServiceClass_UUID; // RFCOMM_PROTOCOL_UUID
	int BTHAddrLength = sizeof(RemoteEndPoint);
	std::cout << "   Remote EndPoint Address: " << RemoteEndPoint.btAddr << "\r\n";


	//--------------------------------------------
	// Create the socket.
	//--------------------------------------------
	if ((LocalSocket = socket(AF_BTH, SOCK_STREAM, BTHPROTO_RFCOMM)) == INVALID_SOCKET)
	{
	}
	std::cout << "WINSOCK: 'socket' Return Code: " << WSAGetLastError() << "\r\n";


	//--------------------------------------------
	// Bind the socket.
	//--------------------------------------------
	if ((iResult = bind(LocalSocket, (SOCKADDR *)&LocalEndpoint, sizeof(LocalEndpoint))) == SOCKET_ERROR)
	{
	}
	std::cout << "WINSOCK: 'bind' Return Code: " << WSAGetLastError() << "\r\n";


	//--------------------------------------------
	// Connect the socket.
	//--------------------------------------------
	if ((iResult = connect(LocalSocket, (SOCKADDR *)&RemoteEndPoint, sizeof(RemoteEndPoint))) == INVALID_SOCKET)
	{
	}
	std::cout << "WINSOCK: 'connect' Return Code: " << WSAGetLastError() << "\r\n";


	//--------------------------------------------
	// Send the Buffer.
	//--------------------------------------------
	if ((iResult = send(LocalSocket, sendbuf, len, MSG_OOB)) == SOCKET_ERROR)
	{
	}
	std::cout << "WINSOCK: 'send' Return Code: " << WSAGetLastError() << "\r\n";
	std::cout << "   Bytes Sent: " << sendbuf << "\r\n";


	//--------------------------------------------
	// Receive until the peer termination.
	//--------------------------------------------
	if ((iResult = recv(LocalSocket, recvbuf, recvbuflen, 0)) == SOCKET_ERROR)
	{
	}
	std::cout << "WINSOCK: 'recv' Return Code: " << WSAGetLastError() << "\r\n";
	std::cout << "   Data Received: " << recvbuf << "\r\n";


	//--------------------------------------------
	// Shutdown the connection.
	//--------------------------------------------
	if ((iResult = shutdown(LocalSocket, SD_SEND)) == SOCKET_ERROR)
	{
	}
	std::cout << "WINSOCK: 'shutdown' Return Code: " << WSAGetLastError() << "\r\n";


	//--------------------------------------------
	// Close the Socket.
	//--------------------------------------------
	if ((iResult = closesocket(LocalSocket)) == SOCKET_ERROR)
	{
	}
	std::cout << "WINSOCK: 'closesocket' Return Code: " << WSAGetLastError() << "\r\n";


	WSACleanup();


	std::cout << "END: " << "Application has completed!" << "\r\n";


	std::getchar();


	return 0;

}