/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.androidplot.PlotEvent;
import com.androidplot.PlotListener;
import com.androidplot.exception.PlotRenderException;
import com.androidplot.series.Series;
import com.androidplot.ui.AnchorPosition;
import com.androidplot.ui.BoxModel;
import com.androidplot.ui.DataRenderer;
import com.androidplot.ui.LayoutManager;
import com.androidplot.ui.SeriesAndFormatterList;
import com.androidplot.ui.SizeLayoutType;
import com.androidplot.ui.SizeMetrics;
import com.androidplot.ui.TextOrientationType;
import com.androidplot.ui.widget.TitleWidget;
import com.androidplot.ui.widget.Widget;
import com.androidplot.xy.XLayoutStyle;
import com.androidplot.xy.YLayoutStyle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class Plot<SeriesType extends Series, FormatterType, RendererType extends DataRenderer>
extends View {
    private String a;
    private BoxModel b = new BoxModel(3.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f);
    private BorderStyle c = BorderStyle.ROUNDED;
    private float d = 15.0f;
    private float e = 15.0f;
    private boolean f = true;
    private Paint g;
    private Paint h;
    private LayoutManager i;
    private TitleWidget j;
    private LinkedList<RendererType> k;
    private LinkedHashMap<Class, SeriesAndFormatterList<SeriesType, FormatterType>> l;
    private final ArrayList<PlotListener> m = new ArrayList();

    public Plot(Context context, String string) {
        super(context);
        this.l = new LinkedHashMap();
        this.k = new LinkedList();
        this.g = new Paint();
        this.g.setColor(Color.rgb((int)150, (int)150, (int)150));
        this.g.setStyle(Paint.Style.STROKE);
        this.g.setStrokeWidth(3.3f);
        this.g.setAntiAlias(true);
        this.h = new Paint();
        this.h.setColor(-12303292);
        this.h.setStyle(Paint.Style.FILL);
        this.a = string;
        this.b();
    }

    public Plot(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.l = new LinkedHashMap();
        this.k = new LinkedList();
        this.g = new Paint();
        this.g.setColor(Color.rgb((int)150, (int)150, (int)150));
        this.g.setStyle(Paint.Style.STROKE);
        this.g.setStrokeWidth(3.3f);
        this.g.setAntiAlias(true);
        this.h = new Paint();
        this.h.setColor(-12303292);
        this.h.setStyle(Paint.Style.FILL);
        this.a(attributeSet);
        this.b();
    }

    public Plot(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.l = new LinkedHashMap();
        this.k = new LinkedList();
        this.g = new Paint();
        this.g.setColor(Color.rgb((int)150, (int)150, (int)150));
        this.g.setStyle(Paint.Style.STROKE);
        this.g.setStrokeWidth(3.3f);
        this.g.setAntiAlias(true);
        this.h = new Paint();
        this.h.setColor(-12303292);
        this.h.setStyle(Paint.Style.FILL);
        this.a(attributeSet);
        this.b();
    }

    private void b() {
        this.j = new TitleWidget(this, new SizeMetrics(25.0f, SizeLayoutType.ABSOLUTE, 100.0f, SizeLayoutType.ABSOLUTE), TextOrientationType.HORIZONTAL);
        this.i = new LayoutManager();
        this.i.position(this.j, 0.0f, XLayoutStyle.RELATIVE_TO_CENTER, 0.0f, YLayoutStyle.ABSOLUTE_FROM_TOP, AnchorPosition.TOP_MIDDLE);
    }

    private void a(AttributeSet attributeSet) {
        this.a = attributeSet.getAttributeValue(null, "title");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(PlotListener plotListener) {
        ArrayList<PlotListener> arrayList = this.m;
        synchronized (arrayList) {
            return !this.m.contains(plotListener) && this.m.add(plotListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(PlotListener plotListener) {
        ArrayList<PlotListener> arrayList = this.m;
        synchronized (arrayList) {
            return this.m.remove(plotListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(PlotEvent plotEvent) {
        ArrayList<PlotListener> arrayList = ((Plot)((Object)this)).m;
        synchronized (arrayList) {
            for (PlotListener plotListener : ((Plot)((Object)this)).m) {
                plotListener.onPlotUpdate(plotEvent);
            }
            return;
        }
    }

    public void position(Widget widget, float f, XLayoutStyle xLayoutStyle, float f2, YLayoutStyle yLayoutStyle) {
        this.i.position(widget, f, xLayoutStyle, f2, yLayoutStyle, AnchorPosition.LEFT_TOP);
    }

    public void position(Widget widget, float f, XLayoutStyle xLayoutStyle, float f2, YLayoutStyle yLayoutStyle, AnchorPosition anchorPosition) {
        this.i.position(widget, f, xLayoutStyle, f2, yLayoutStyle, anchorPosition);
    }

    protected abstract RendererType a(Class var1);

    public boolean addSeries(SeriesType SeriesType, Class clazz, FormatterType FormatterType) {
        clazz.cast(null);
        Object object = this.l.get(clazz);
        if (object == null) {
            if (this.getRenderer(clazz) == null) {
                Class clazz2 = clazz;
                object = this;
                if ((object = ((Plot)((Object)object)).a(clazz2)) == null) {
                    throw new IllegalArgumentException("Unrecognized Renderer: " + clazz2.getCanonicalName());
                }
                this.k.add(object);
            }
            object = new SeriesAndFormatterList();
            this.l.put(clazz, (SeriesAndFormatterList<SeriesType, FormatterType>)object);
        }
        if (object.contains(SeriesType)) {
            return false;
        }
        object.add(SeriesType, FormatterType);
        return true;
    }

    public boolean removeSeries(SeriesType SeriesType, Class clazz) {
        boolean bl = this.l.get(clazz).remove(SeriesType);
        if (this.l.get(clazz).size() <= 0) {
            this.l.remove(clazz);
        }
        return bl;
    }

    public void removeSeries(SeriesType SeriesType) {
        for (Class clazz : this.l.keySet()) {
            this.l.get(clazz).remove(SeriesType);
        }
        Iterator<Object> iterator = this.l.values().iterator();
        while (iterator.hasNext()) {
            if (((SeriesAndFormatterList)iterator.next()).size() > 0) continue;
            iterator.remove();
        }
    }

    public boolean isEmpty() {
        return this.l.isEmpty();
    }

    public FormatterType getFormatter(SeriesType SeriesType, Class clazz) {
        return this.l.get(clazz).getFormatter(SeriesType);
    }

    public boolean setFormatter(SeriesType SeriesType, Class clazz, FormatterType FormatterType) {
        throw new UnsupportedOperationException();
    }

    public SeriesAndFormatterList<SeriesType, FormatterType> getSeriesAndFormatterListForRenderer(Class clazz) {
        return this.l.get(clazz);
    }

    public Set<SeriesType> getSeriesSet() {
        LinkedHashSet<Series> linkedHashSet = new LinkedHashSet<Series>();
        for (Object object : this.getRendererList()) {
            for (Series series : this.getSeriesListForRenderer(object.getClass())) {
                linkedHashSet.add(series);
            }
        }
        return linkedHashSet;
    }

    public List<SeriesType> getSeriesListForRenderer(Class clazz) {
        SeriesAndFormatterList<SeriesType, FormatterType> seriesAndFormatterList = ((Plot)((Object)seriesAndFormatterList)).l.get(clazz);
        if (seriesAndFormatterList == null) {
            return null;
        }
        return seriesAndFormatterList.getSeriesList();
    }

    public RendererType getRenderer(Class clazz) {
        for (DataRenderer dataRenderer : ((Plot)((Object)this)).k) {
            if (dataRenderer.getClass() != clazz) continue;
            return (RendererType)dataRenderer;
        }
        return null;
    }

    public List<RendererType> getRendererList() {
        return this.k;
    }

    public void disableAllMarkup() {
        this.i.disableAllMarkup();
    }

    public void redraw() {
        this.invalidate();
    }

    public void postRedraw() throws InterruptedException {
        this.postRedraw(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRedraw(boolean bl) throws InterruptedException {
        Plot plot = this;
        synchronized (plot) {
            this.postInvalidate();
            if (bl) {
                ((Object)((Object)this)).wait();
            }
            return;
        }
    }

    protected abstract void a();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onDraw(Canvas canvas) {
        this.a();
        try {
            Plot plot;
            void var6_11;
            void var1_1;
            RectF rectF;
            RectF rectF2 = new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
            RectF rectF3 = this.b.getMarginatedRect(rectF2);
            RectF rectF4 = this.b.getPaddedRect(rectF3);
            if (this.h != null) {
                rectF = rectF3;
                var6_11 = var1_1;
                plot = this;
                switch (plot.c) {
                    case ROUNDED: {
                        var6_11.drawRoundRect(rectF, plot.d, plot.e, plot.h);
                        break;
                    }
                    case SQUARE: {
                        var6_11.drawRect(rectF, plot.h);
                        break;
                    }
                }
            }
            plot = this;
            synchronized (plot) {
                this.i.draw((Canvas)var1_1, rectF2, rectF3, rectF4);
            }
            if (!this.isDrawBorderEnabled()) return;
            if (this.getBorderPaint() == null) return;
            rectF = rectF3;
            var6_11 = var1_1;
            plot = this;
            switch (plot.c) {
                case ROUNDED: {
                    var6_11.drawRoundRect(rectF, plot.d, plot.e, plot.g);
                    return;
                }
                case SQUARE: {
                    var6_11.drawRect(rectF, plot.g);
                    return;
                }
            }
            return;
        }
        catch (PlotRenderException plotRenderException) {
            PlotRenderException plotRenderException2 = plotRenderException;
            plotRenderException.printStackTrace();
            return;
        }
        finally {
            this.a(new PlotEvent(this, PlotEvent.Type.PLOT_REDRAWN));
            Plot plot = this;
            synchronized (plot) {
                ((Object)((Object)this)).notify();
            }
        }
    }

    public void setBorderStyle(BorderStyle borderStyle, Float f, Float f2) {
        if (borderStyle == BorderStyle.ROUNDED) {
            if (f != null || f2 != null) {
                throw new IllegalArgumentException("radiusX and radiusY cannot be null when using BorderStyle.ROUNDED");
            }
            this.d = f.floatValue();
            this.e = f2.floatValue();
        }
        this.c = borderStyle;
    }

    public String getTitle() {
        return this.a;
    }

    public void setTitle(String string) {
        this.a = string;
    }

    public LayoutManager getLayoutManager() {
        return this.i;
    }

    public void setLayoutManager(LayoutManager layoutManager) {
        this.i = layoutManager;
    }

    public boolean isDrawBorderEnabled() {
        return this.f;
    }

    public void setDrawBorderEnabled(boolean bl) {
        this.f = bl;
    }

    public TitleWidget getTitleWidget() {
        return this.j;
    }

    public void setTitleWidget(TitleWidget titleWidget) {
        this.j = titleWidget;
    }

    public Paint getBackgroundPaint() {
        return this.h;
    }

    public void setBackgroundPaint(Paint paint) {
        this.h = paint;
    }

    public void setPlotMargins(float f, float f2, float f3, float f4) {
        this.setPlotMarginLeft(f);
        this.setPlotMarginTop(f2);
        this.setPlotMarginRight(f3);
        this.setPlotMarginBottom(f4);
    }

    public void setPlotPadding(float f, float f2, float f3, float f4) {
        this.setPlotPaddingLeft(f);
        this.setPlotPaddingTop(f2);
        this.setPlotPaddingRight(f3);
        this.setPlotPaddingBottom(f4);
    }

    public float getPlotMarginTop() {
        return this.b.getMarginTop();
    }

    public void setPlotMarginTop(float f) {
        this.b.setMarginTop(f);
    }

    public float getPlotMarginBottom() {
        return this.b.getMarginBottom();
    }

    public void setPlotMarginBottom(float f) {
        this.b.setMarginBottom(f);
    }

    public float getPlotMarginLeft() {
        return this.b.getMarginLeft();
    }

    public void setPlotMarginLeft(float f) {
        this.b.setMarginLeft(f);
    }

    public float getPlotMarginRight() {
        return this.b.getMarginRight();
    }

    public void setPlotMarginRight(float f) {
        this.b.setMarginRight(f);
    }

    public float getPlotPaddingTop() {
        return this.b.getPaddingTop();
    }

    public void setPlotPaddingTop(float f) {
        this.b.setPaddingTop(f);
    }

    public float getPlotPaddingBottom() {
        return this.b.getPaddingBottom();
    }

    public void setPlotPaddingBottom(float f) {
        this.b.setPaddingBottom(f);
    }

    public float getPlotPaddingLeft() {
        return this.b.getPaddingLeft();
    }

    public void setPlotPaddingLeft(float f) {
        this.b.setPaddingLeft(f);
    }

    public float getPlotPaddingRight() {
        return this.b.getPaddingRight();
    }

    public void setPlotPaddingRight(float f) {
        this.b.setPaddingRight(f);
    }

    public Paint getBorderPaint() {
        return this.g;
    }

    public void setBorderPaint(Paint paint) {
        if (paint == null) {
            this.g = null;
            return;
        }
        this.g = new Paint(paint);
        this.g.setStyle(Paint.Style.STROKE);
    }

    public static enum BorderStyle {
        ROUNDED,
        SQUARE,
        NONE;

    }
}

