/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.xy;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Region;
import com.androidplot.exception.PlotRenderException;
import com.androidplot.ui.SizeMetrics;
import com.androidplot.ui.widget.Widget;
import com.androidplot.util.FontUtils;
import com.androidplot.util.ValPixConverter;
import com.androidplot.util.ZHash;
import com.androidplot.util.ZIndexable;
import com.androidplot.xy.AxisValueLabelFormatter;
import com.androidplot.xy.RectRegion;
import com.androidplot.xy.ValueMarker;
import com.androidplot.xy.XPositionMetric;
import com.androidplot.xy.XValueMarker;
import com.androidplot.xy.XYAxisType;
import com.androidplot.xy.XYPlot;
import com.androidplot.xy.XYSeriesRenderer;
import com.androidplot.xy.XYStep;
import com.androidplot.xy.XYStepCalculator;
import com.androidplot.xy.YPositionMetric;
import com.androidplot.xy.YValueMarker;
import java.text.DecimalFormat;
import java.text.Format;

public class XYGraphWidget
extends Widget {
    private float a = 15.0f;
    private float b = 41.0f;
    private float c = -5.0f;
    private float d = 1.0f;
    private int e = 1;
    private int f = 1;
    private float g = 0.0f;
    private float h = 0.0f;
    private float i = 0.0f;
    private float j = 0.0f;
    private int k = 5;
    private int l = 5;
    private Paint m = new Paint();
    private Paint n;
    private Paint o;
    private Paint p;
    private Paint q;
    private Paint r;
    private Paint s;
    private Paint t;
    private XYPlot u;
    private Format v;
    private Format w;
    private Paint x;
    private Paint y;
    private Paint z;
    private Paint A;
    private RectF B;
    private RectF C;
    private float D;
    private float E;
    private boolean F = true;
    private boolean G = true;
    private ZHash<RectRegion, AxisValueLabelFormatter> H;

    public XYGraphWidget(XYPlot xYPlot, SizeMetrics sizeMetrics) {
        super(sizeMetrics);
        this.m.setColor(Color.rgb((int)140, (int)140, (int)140));
        this.m.setStyle(Paint.Style.FILL);
        this.n = new Paint();
        this.n.setColor(Color.rgb((int)180, (int)180, (int)180));
        this.n.setAntiAlias(true);
        this.n.setStyle(Paint.Style.STROKE);
        this.x = new Paint();
        this.x.setColor(-1);
        this.x.setAntiAlias(true);
        this.y = new Paint();
        this.y.setColor(-1);
        this.y.setAntiAlias(true);
        this.z = new Paint();
        this.z.setColor(-1);
        this.z.setAntiAlias(true);
        this.z.setTextAlign(Paint.Align.CENTER);
        this.A = new Paint();
        this.A.setColor(-1);
        this.A.setAntiAlias(true);
        this.A.setTextAlign(Paint.Align.RIGHT);
        this.o = new Paint();
        this.o.setColor(-3355444);
        this.o.setAntiAlias(true);
        this.o.setTextAlign(Paint.Align.CENTER);
        this.p = new Paint();
        this.p.setColor(-3355444);
        this.p.setAntiAlias(true);
        this.p.setTextAlign(Paint.Align.RIGHT);
        this.q = new Paint();
        this.q.setColor(-256);
        this.r = new Paint();
        this.r.setColor(-256);
        this.s = new Paint();
        this.s.setColor(-256);
        this.t = new Paint();
        this.t.setColor(Color.argb((int)100, (int)50, (int)50, (int)50));
        this.setMarginTop(7.0f);
        this.setMarginRight(4.0f);
        this.setMarginBottom(4.0f);
        this.v = new DecimalFormat("0.0");
        this.w = new DecimalFormat("0.0");
        this.H = new ZHash();
        this.u = xYPlot;
    }

    public ZIndexable<RectRegion> getAxisValueLabelRegions() {
        return this.H;
    }

    public void addAxisValueLabelRegion(RectRegion rectRegion, AxisValueLabelFormatter axisValueLabelFormatter) {
        this.H.addToTop(rectRegion, axisValueLabelFormatter);
    }

    public void addDomainAxisValueLabelRegion(double d, double d2, AxisValueLabelFormatter axisValueLabelFormatter) {
        this.addAxisValueLabelRegion(new RectRegion(d, d2, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, null), axisValueLabelFormatter);
    }

    public void addRangeAxisValueLabelRegion(double d, double d2, AxisValueLabelFormatter axisValueLabelFormatter) {
        this.addAxisValueLabelRegion(new RectRegion(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, d, d2, null), axisValueLabelFormatter);
    }

    public AxisValueLabelFormatter getAxisValueLabelFormatterForVal(double d, double d2) {
        for (RectRegion rectRegion : this.H.elements()) {
            if (!rectRegion.containsValue(d, d2)) continue;
            return this.H.get(rectRegion);
        }
        return null;
    }

    public AxisValueLabelFormatter getAxisValueLabelFormatterForDomainVal(double d) {
        for (RectRegion rectRegion : this.H.elements()) {
            if (!rectRegion.containsDomainValue(d)) continue;
            return this.H.get(rectRegion);
        }
        return null;
    }

    public AxisValueLabelFormatter getAxisValueLabelFormatterForRangeVal(double d) {
        for (RectRegion rectRegion : this.H.elements()) {
            if (!rectRegion.containsRangeValue(d)) continue;
            return this.H.get(rectRegion);
        }
        return null;
    }

    public RectF getGridRect() {
        return this.C;
    }

    public Double getYVal(PointF pointF) {
        return this.getYVal(pointF.y);
    }

    public Double getYVal(float f) {
        if (this.u.getCalculatedMinY() == null || this.u.getCalculatedMaxY() == null) {
            return null;
        }
        return ValPixConverter.pixToVal(f - this.C.top, this.u.getCalculatedMinY().doubleValue(), this.u.getCalculatedMaxY().doubleValue(), this.C.height(), true);
    }

    public Double getXVal(PointF pointF) {
        return this.getXVal(pointF.x);
    }

    public Double getXVal(float f) {
        if (this.u.getCalculatedMinX() == null || this.u.getCalculatedMaxX() == null) {
            return null;
        }
        return ValPixConverter.pixToVal(f - this.C.left, this.u.getCalculatedMinX().doubleValue(), this.u.getCalculatedMaxX().doubleValue(), this.C.width(), false);
    }

    @Override
    protected void doOnDraw(Canvas canvas, RectF object) throws PlotRenderException {
        RectF rectF = object;
        object = this;
        rectF = this.B = new RectF(rectF.left + ((XYGraphWidget)object).b, rectF.top, rectF.right, rectF.bottom - ((XYGraphWidget)object).a);
        object = this;
        this.C = new RectF(rectF.left + ((XYGraphWidget)object).i, rectF.top + ((XYGraphWidget)object).g, rectF.right - ((XYGraphWidget)object).j, rectF.bottom - ((XYGraphWidget)object).h);
        if (this.u.getCalculatedMinX() != null && this.u.getCalculatedMaxX() != null && this.u.getCalculatedMinY() != null && this.u.getCalculatedMaxY() != null) {
            this.a(canvas);
            this.c(canvas);
            rectF = canvas;
            object = this;
            boolean bl = false;
            if (((XYGraphWidget)object).q != null && ((XYGraphWidget)object).D <= ((XYGraphWidget)object).C.right && ((XYGraphWidget)object).D >= ((XYGraphWidget)object).C.left) {
                bl = true;
                rectF.drawLine(((XYGraphWidget)object).D, ((XYGraphWidget)object).C.top, ((XYGraphWidget)object).D, ((XYGraphWidget)object).C.bottom, ((XYGraphWidget)object).q);
            }
            boolean bl2 = false;
            if (((XYGraphWidget)object).r != null && ((XYGraphWidget)object).E >= ((XYGraphWidget)object).C.top && ((XYGraphWidget)object).E <= ((XYGraphWidget)object).C.bottom) {
                bl2 = true;
                rectF.drawLine(((XYGraphWidget)object).C.left, ((XYGraphWidget)object).E, ((XYGraphWidget)object).C.right, ((XYGraphWidget)object).E, ((XYGraphWidget)object).r);
            }
            if (((XYGraphWidget)object).F && ((XYGraphWidget)object).s != null && bl2 && bl) {
                String string = "X=" + ((XYGraphWidget)object).getDomainValueFormat().format(((XYGraphWidget)object).getDomainCursorVal());
                string = string + " Y=" + ((XYGraphWidget)object).getRangeValueFormat().format(((XYGraphWidget)object).getRangeCursorVal());
                RectF rectF2 = new RectF(FontUtils.getPackedStringDimensions(string, ((XYGraphWidget)object).s));
                rectF2.offsetTo(((XYGraphWidget)object).D, ((XYGraphWidget)object).E - rectF2.height());
                if (rectF2.right >= ((XYGraphWidget)object).C.right) {
                    rectF2.offsetTo(((XYGraphWidget)object).D - rectF2.width(), rectF2.top);
                }
                if (rectF2.top <= ((XYGraphWidget)object).C.top) {
                    rectF2.offsetTo(rectF2.left, ((XYGraphWidget)object).E);
                }
                if (((XYGraphWidget)object).t != null) {
                    rectF.drawRect(rectF2, ((XYGraphWidget)object).t);
                }
                rectF.drawText(string, rectF2.left, rectF2.bottom, ((XYGraphWidget)object).s);
            }
            if (this.isDrawMarkersEnabled()) {
                this.b(canvas);
            }
        }
    }

    private void a(Canvas canvas, XYAxisType object, Number number, float f, float f2, Paint paint) {
        XYGraphWidget xYGraphWidget;
        AxisValueLabelFormatter axisValueLabelFormatter = null;
        String string = null;
        double d = number.doubleValue();
        switch (object) {
            case DOMAIN: {
                axisValueLabelFormatter = xYGraphWidget.getAxisValueLabelFormatterForDomainVal(d);
                object = number;
                string = xYGraphWidget.w.format(object);
                break;
            }
            case RANGE: {
                axisValueLabelFormatter = xYGraphWidget.getAxisValueLabelFormatterForRangeVal(d);
                object = number;
                string = xYGraphWidget.v.format(object);
            }
        }
        if (axisValueLabelFormatter != null) {
            xYGraphWidget = new Paint(paint);
            xYGraphWidget.setColor(axisValueLabelFormatter.getColor());
        } else {
            xYGraphWidget = paint;
        }
        canvas.drawText(string, f, f2, (Paint)xYGraphWidget);
    }

    private void a(Canvas canvas, float f, Number number, Paint paint, Paint paint2, boolean bl) {
        if (!bl) {
            canvas.drawLine(f, this.B.top, f, this.B.bottom + (float)this.k, paint2);
            float f2 = FontUtils.getFontHeight(paint);
            f2 = this.B.bottom + (float)this.l + this.c + f2;
            this.a(canvas, XYAxisType.DOMAIN, number, f, f2, paint);
            return;
        }
        canvas.drawLine(f, this.B.top, f, this.B.bottom, paint2);
    }

    public void drawRangeTick(Canvas canvas, float f, Number number, Paint paint, Paint paint2, boolean bl) {
        if (!bl) {
            canvas.drawLine(this.B.left - (float)this.l, f, this.B.right, f, paint2);
            float f2 = this.B.left - ((float)this.l + this.d);
            this.a(canvas, XYAxisType.RANGE, number, f2, f, paint);
            return;
        }
        canvas.drawLine(this.B.left, f, this.B.right, f, paint2);
    }

    private void a(Canvas canvas) throws PlotRenderException {
        float f;
        double d;
        float f2;
        if (this.m != null) {
            canvas.drawRect(this.B, this.m);
        }
        if (this.u.getDomainOrigin() != null) {
            double d2 = this.u.getDomainOrigin().doubleValue();
            f2 = ValPixConverter.valToPix(d2, this.u.getCalculatedMinX().doubleValue(), this.u.getCalculatedMaxX().doubleValue(), this.C.width(), false);
            f2 += this.C.left;
        } else {
            f2 = this.C.left;
        }
        XYStep xYStep = XYStepCalculator.getStep(this.u, XYAxisType.DOMAIN, this.C, (Number)this.u.getCalculatedMinX().doubleValue(), (Number)this.u.getCalculatedMaxX().doubleValue());
        if (f2 >= this.C.left && f2 <= this.C.right) {
            this.x.setTextAlign(Paint.Align.CENTER);
            this.a(canvas, f2, (Number)this.u.getDomainOrigin().doubleValue(), this.z, this.x, false);
        }
        int n = 1;
        float f3 = f2 - xYStep.getStepPix();
        while (f3 >= this.C.left) {
            d = this.u.getDomainOrigin().doubleValue() - (double)n * xYStep.getStepVal();
            if (f3 >= this.C.left && f3 <= this.C.right) {
                if (n % this.getTicksPerDomainLabel() == 0) {
                    this.a(canvas, f3, (Number)d, this.o, this.n, false);
                } else {
                    this.a(canvas, f3, (Number)d, this.o, this.n, true);
                }
            }
            f3 = f2 - (float)(++n) * xYStep.getStepPix();
        }
        n = 1;
        f3 = f2 + xYStep.getStepPix();
        while (f3 <= this.C.right) {
            d = this.u.getDomainOrigin().doubleValue() + (double)n * xYStep.getStepVal();
            if (f3 >= this.C.left && f3 <= this.C.right) {
                if (n % this.getTicksPerDomainLabel() == 0) {
                    this.a(canvas, f3, (Number)d, this.o, this.n, false);
                } else {
                    this.a(canvas, f3, (Number)d, this.o, this.n, true);
                }
            }
            f3 = f2 + (float)(++n) * xYStep.getStepPix();
        }
        if (this.u.getRangeOrigin() != null) {
            d = this.u.getRangeOrigin().doubleValue();
            f = ValPixConverter.valToPix(d, this.u.getCalculatedMinY().doubleValue(), this.u.getCalculatedMaxY().doubleValue(), this.C.height(), true);
            f += this.C.top;
        } else {
            f = this.C.bottom;
        }
        XYStep xYStep2 = XYStepCalculator.getStep(this.u, XYAxisType.RANGE, this.C, (Number)this.u.getCalculatedMinY().doubleValue(), (Number)this.u.getCalculatedMaxY().doubleValue());
        if (f >= this.C.top && f <= this.C.bottom) {
            this.y.setTextAlign(Paint.Align.RIGHT);
            this.drawRangeTick(canvas, f, this.u.getRangeOrigin().doubleValue(), this.A, this.y, false);
        }
        int n2 = 1;
        f2 = f - xYStep2.getStepPix();
        while (f2 >= this.C.top) {
            double d3 = this.u.getRangeOrigin().doubleValue() + (double)n2 * xYStep2.getStepVal();
            if (f2 >= this.C.top && f2 <= this.C.bottom) {
                if (n2 % this.getTicksPerRangeLabel() == 0) {
                    this.drawRangeTick(canvas, f2, d3, this.p, this.n, false);
                } else {
                    this.drawRangeTick(canvas, f2, d3, this.p, this.n, true);
                }
            }
            f2 = f - (float)(++n2) * xYStep2.getStepPix();
        }
        n2 = 1;
        f2 = f + xYStep2.getStepPix();
        while (f2 <= this.C.bottom) {
            double d4 = this.u.getRangeOrigin().doubleValue() - (double)n2 * xYStep2.getStepVal();
            if (f2 >= this.C.top && f2 <= this.C.bottom) {
                if (n2 % this.getTicksPerRangeLabel() == 0) {
                    this.drawRangeTick(canvas, f2, d4, this.p, this.n, false);
                } else {
                    this.drawRangeTick(canvas, f2, d4, this.p, this.n, true);
                }
            }
            f2 = f + (float)(++n2) * xYStep2.getStepPix();
        }
    }

    private void a(Canvas canvas, String string, ValueMarker valueMarker, float f, float f2) {
        RectF rectF = new RectF(FontUtils.getStringDimensions(string, valueMarker.getTextPaint()));
        rectF.offsetTo(f += 2.0f, (f2 -= 2.0f) - rectF.height());
        if (rectF.right > this.C.right) {
            rectF.offset(-(rectF.right - this.C.right), 0.0f);
        }
        if (rectF.top < this.C.top) {
            rectF.offset(0.0f, this.C.top - rectF.top);
        }
        canvas.drawText(string, rectF.left, rectF.bottom, valueMarker.getTextPaint());
    }

    private void b(Canvas canvas) {
        float f;
        float d;
        Object object = this.u;
        for (YValueMarker valueMarker : ((XYPlot)((Object)object)).a) {
            if (valueMarker.getValue() == null) continue;
            double d2 = valueMarker.getValue().doubleValue();
            d = ValPixConverter.valToPix(d2, this.u.getCalculatedMinY().doubleValue(), this.u.getCalculatedMaxY().doubleValue(), this.C.height(), true);
            canvas.drawLine(this.C.left, d += this.C.top, this.C.right, d, valueMarker.getLinePaint());
            f = ((XPositionMetric)valueMarker.getTextPosition()).getPixelValue(this.C.width());
            f += this.C.left;
            if (valueMarker.getText() == null) continue;
            this.a(canvas, valueMarker.getText(), valueMarker, f, d);
        }
        object = this.u;
        for (XValueMarker xValueMarker : ((XYPlot)((Object)object)).b) {
            if (xValueMarker.getValue() == null) continue;
            double d3 = xValueMarker.getValue().doubleValue();
            d = ValPixConverter.valToPix(d3, this.u.getCalculatedMinX().doubleValue(), this.u.getCalculatedMaxX().doubleValue(), this.C.width(), true);
            canvas.drawLine(d += this.C.left, this.C.top, d, this.C.bottom, xValueMarker.getLinePaint());
            f = ((YPositionMetric)xValueMarker.getTextPosition()).getPixelValue(this.C.height());
            f += this.C.top;
            if (xValueMarker.getText() == null) continue;
            this.a(canvas, xValueMarker.getText(), xValueMarker, d, f);
        }
    }

    private void c(Canvas canvas) throws PlotRenderException {
        try {
            canvas.save(31);
            canvas.clipRect(this.B, Region.Op.INTERSECT);
            for (XYSeriesRenderer xYSeriesRenderer : this.u.getRendererList()) {
                xYSeriesRenderer.render(canvas, this.C);
            }
            return;
        }
        finally {
            canvas.restore();
        }
    }

    public float getDomainLabelWidth() {
        return this.a;
    }

    public void setDomainLabelWidth(float f) {
        this.a = f;
    }

    public float getRangeLabelWidth() {
        return this.b;
    }

    public void setRangeLabelWidth(float f) {
        this.b = f;
    }

    public float getDomainLabelVerticalOffset() {
        return this.c;
    }

    public void setDomainLabelVerticalOffset(float f) {
        this.c = f;
    }

    public float getRangeLabelHorizontalOffset() {
        return this.d;
    }

    public void setRangeLabelHorizontalOffset(float f) {
        this.d = f;
    }

    public Paint getGridBackgroundPaint() {
        return this.m;
    }

    public void setGridBackgroundPaint(Paint paint) {
        this.m = paint;
    }

    public Paint getDomainLabelPaint() {
        return this.o;
    }

    public void setDomainLabelPaint(Paint paint) {
        this.o = paint;
    }

    public Paint getRangeLabelPaint() {
        return this.p;
    }

    public void setRangeLabelPaint(Paint paint) {
        this.p = paint;
    }

    public Paint getGridLinePaint() {
        return this.n;
    }

    public void setGridLinePaint(Paint paint) {
        this.n = new Paint(paint);
        this.n.setStyle(Paint.Style.STROKE);
    }

    public Format getRangeValueFormat() {
        return this.v;
    }

    public void setRangeValueFormat(Format format) {
        this.v = format;
    }

    public Format getDomainValueFormat() {
        return this.w;
    }

    public void setDomainValueFormat(Format format) {
        this.w = format;
    }

    public int getDomainLabelTickExtension() {
        return this.k;
    }

    public void setDomainLabelTickExtension(int n) {
        this.k = n;
    }

    public int getRangeLabelTickExtension() {
        return this.l;
    }

    public void setRangeLabelTickExtension(int n) {
        this.l = n;
    }

    public int getTicksPerRangeLabel() {
        return this.e;
    }

    public void setTicksPerRangeLabel(int n) {
        this.e = n;
    }

    public int getTicksPerDomainLabel() {
        return this.f;
    }

    public void setTicksPerDomainLabel(int n) {
        this.f = n;
    }

    @Deprecated
    public int getRangeTicksPerLabel() {
        return this.e;
    }

    @Deprecated
    public void setRangeTicksPerLabel(int n) {
        this.e = n;
    }

    public void setGridPaddingTop(float f) {
        this.g = f;
    }

    public float getGridPaddingBottom() {
        return this.h;
    }

    public void setGridPaddingBottom(float f) {
        this.h = f;
    }

    public float getGridPaddingLeft() {
        return this.i;
    }

    public void setGridPaddingLeft(float f) {
        this.i = f;
    }

    public float getGridPaddingRight() {
        return this.j;
    }

    public void setGridPaddingRight(float f) {
        this.j = f;
    }

    public float getGridPaddingTop() {
        return this.g;
    }

    public Paint getDomainOriginLinePaint() {
        return this.x;
    }

    public void setDomainOriginLinePaint(Paint paint) {
        this.x = paint;
    }

    public Paint getRangeOriginLinePaint() {
        return this.y;
    }

    public void setRangeOriginLinePaint(Paint paint) {
        this.y = paint;
    }

    public Paint getDomainOriginLabelPaint() {
        return this.z;
    }

    public void setDomainOriginLabelPaint(Paint paint) {
        this.z = paint;
    }

    public Paint getRangeOriginLabelPaint() {
        return this.A;
    }

    public void setRangeOriginLabelPaint(Paint paint) {
        this.A = paint;
    }

    public void setCursorPosition(float f, float f2) {
        this.setDomainCursorPosition(f);
        this.setRangeCursorPosition(f2);
    }

    public void setCursorPosition(PointF pointF) {
        this.setCursorPosition(pointF.x, pointF.y);
    }

    public float getDomainCursorPosition() {
        return this.D;
    }

    public Double getDomainCursorVal() {
        return this.getXVal(this.getDomainCursorPosition());
    }

    public void setDomainCursorPosition(float f) {
        this.D = f;
    }

    public float getRangeCursorPosition() {
        return this.E;
    }

    public Double getRangeCursorVal() {
        return this.getYVal(this.getRangeCursorPosition());
    }

    public void setRangeCursorPosition(float f) {
        this.E = f;
    }

    public Paint getCursorLabelPaint() {
        return this.s;
    }

    public void setCursorLabelPaint(Paint paint) {
        this.s = paint;
    }

    public Paint getCursorLabelBackgroundPaint() {
        return this.t;
    }

    public void setCursorLabelBackgroundPaint(Paint paint) {
        this.t = paint;
    }

    public boolean isDrawMarkersEnabled() {
        return this.G;
    }

    public void setDrawMarkersEnabled(boolean bl) {
        this.G = bl;
    }

    public static enum XYPlotOrientation {
        HORIZONTAL,
        VERTICAL;

    }
}

