package org.obddroid.activity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.obddroid.ui.R;
import org.obddroid.ui.OBDUI;
import org.obddroid.connect.ConnectService;
import org.obddroid.connect.ConnectThread;
import org.obddroid.function.DtcNumfunction;
import org.obddroid.function.EngineLoadFunction;
//import org.obddroid.function.ErrorCodesFunction;
import org.obddroid.function.BatteryVoltageFunction;
import org.obddroid.function.ErrorCodesFunction;
import org.obddroid.function.ObdFunction;
import org.obddroid.function.AirIntakeTempFunction;
import org.obddroid.function.EngineRPMFunction;
import org.obddroid.function.EngineRunTimeFunction;
import org.obddroid.function.FuelEconomyFunction;
import org.obddroid.function.FuelPressureFunction;
import org.obddroid.function.FuelLevelFunction;
import org.obddroid.function.IntakeManifoldPressureFunction;
import org.obddroid.function.MassAirFlowFunction;
//import org.obddroid.function.ObdFunction;
import org.obddroid.function.PressureObdFunction;
import org.obddroid.function.SpeedFunction;
import org.obddroid.function.TempObdFunction;
import org.obddroid.function.ThrottlePositionFunction;
import org.obddroid.function.TimingAdvanceFunction;


import android.app.Activity;
import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Spinner;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.TextView;
import android.widget.Toast;

public class RunFunction extends Activity implements OnItemSelectedListener
{
	final private ArrayList<ObdFunction> functions = getFunctions();
	
	private Map<String,ObdFunction> funcMap = null;
	private Handler handler = null;
	private BluetoothDevice dev;
	private TextView view;
	private ConnectThread temp = null;

	private static final String TAG = "DEBUG OF OBDDROID";
	private final static String NO_SELECTION_TXT = "Choose Function to Run...";
	    
	@Override
    public void onCreate(Bundle savedInstanceState) 
    {
        super.onCreate(savedInstanceState);
        Log.d(TAG, "test of loggin...");
        
        setContentView(R.layout.main2);
        Spinner funcSpin = (Spinner) findViewById(R.id.function_spinner);
        funcSpin.setOnItemSelectedListener(this);
        
        funcMap = new HashMap<String,ObdFunction>();
		ArrayList<String> funcStrs = new ArrayList<String>();
		funcStrs.add(NO_SELECTION_TXT);
		
		view = (TextView) findViewById(R.id.function_result_text);
		Log.d(TAG, "begin");
		
		for (ObdFunction funcs:functions) 
        {
			funcMap.put(funcs.getDesc(), funcs);
			funcStrs.add(funcs.getDesc());
        }
        
        ArrayAdapter<String> adapt = new ArrayAdapter<String>(this,android.R.layout.simple_spinner_item, funcStrs);
		funcSpin.setAdapter(adapt);
		handler = new Handler();
		
		//temp = new ConnectThread(dev, RunFunction.this);
		//t.start();
    }
    
    public static ArrayList<ObdFunction> getFunctions() 
    {
    	ArrayList<ObdFunction> funcs = new ArrayList<ObdFunction>();
		
		funcs.add(new DtcNumfunction());
		funcs.add(new ErrorCodesFunction());
		funcs.add(new AirIntakeTempFunction());
		funcs.add(new BatteryVoltageFunction());
		funcs.add(new IntakeManifoldPressureFunction());
		funcs.add(new PressureObdFunction("0133","Barometric Press","kPa","atm"));
		funcs.add(new SpeedFunction());
		funcs.add(new ThrottlePositionFunction());
		funcs.add(new EngineRPMFunction());
		funcs.add(new FuelPressureFunction());
		funcs.add(new TempObdFunction("0105","Coolant Temperature","C","F"));
		funcs.add(new EngineLoadFunction());
		funcs.add(new MassAirFlowFunction());
		funcs.add(new FuelEconomyFunction());
		funcs.add(new FuelLevelFunction());
		funcs.add(new EngineRPMFunction());
		funcs.add(new EngineRunTimeFunction());
		funcs.add(new TimingAdvanceFunction());
		funcs.add(new ObdFunction("atz","Serial Reset atz","",""));
		funcs.add(new ObdFunction("ate0","Serial Echo Off ate0","",""));
		funcs.add(new ObdFunction("ate1","Serial Echo On ate1","",""));
		funcs.add(new ObdFunction("atsp0","Reset Protocol astp0","",""));
		funcs.add(new ObdFunction("atspa2","Reset Protocol atspa2","",""));
		funcs.add(new ObdFunction("atdp","Describe Protocol","",""));
		
		return funcs;
	}

	@Override
	public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) 
	{
		Spinner funcSpin = (Spinner) findViewById(R.id.function_spinner);
		String funcDesc = funcSpin.getSelectedItem().toString();
		
		if(NO_SELECTION_TXT.equals(funcDesc))
		{
			return;
		}
		
		ObdFunction func = funcMap.get(funcDesc);
		
		view.setText("Running " + func.getDesc() + "....");
		
		try 
		{
			func = ConnectThread.ct.runCommand(func);
			String res = func.formatResult();
			String raw = func.getRawResult();
			msg("Result is: "+ res);
			msg("Raw Result: "+ raw);
			Log.d(TAG, "Raw Result: "+raw);
			
		}catch (InterruptedException e) {
			Log.d(TAG, "Connection Lost..."+e.getMessage());
			e.printStackTrace();
		}catch(NullPointerException e){
			Log.d(TAG, e.getMessage());
		}
	
	}

	@Override
	public void onNothingSelected(AdapterView<?> arg0) 
	{
		// TODO Auto-generated method stub
		
	}
	
	protected void onDestroy()
	{
		super.onDestroy();
		if(temp != null && temp.isConnected())
		{
			temp.cancel();
			Log.d(TAG,"Activity Destroyed, Socket Closed....");
		}
	}
	
	public void setText(final String value, final boolean clear)
	{
		handler.post(new Runnable()
		{
			public void run()
			{
				TextView txtView = (TextView) findViewById(R.id.function_result_text);
				String curr = (String) txtView.getText();
				if(curr == null || clear || "".equals(curr))
				{
					curr = value;
				}
				else
				{
					curr = curr +"\n"+value;
				}
				txtView.setText(curr);
			}	
		});
	}
	public void msg(String msg)
	{
		setText(msg,false);
	}
	
	
}