package org.obddroid.connect;

import java.io.PrintWriter;
import java.io.StringWriter;

import org.obddroid.function.ObdFunction;
import org.obddroid.ui.OBDUI;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.util.Log;

public class ConnectService{}

/*public class ConnectService extends Service
{
	private final BluetoothAdapter mAdapter;
	private final BluetoothDevice dev;
	//private final Handler mHandler;
	private ConnectThread mConnectThread;
	private ConnectedThread mConnectedThread;
	private int mState;
	
	private NotificationManager notifyMan = null;
	private Context context = null;
	private Intent notificationIntent = null;
	private PendingIntent contentIntent = null;
	private final IBinder binder = new ConnectServiceBinder();
	
	public static final int STATE_NONE = 0;       // we're doing nothing
    public static final int STATE_LISTEN = 1;     // now listening for incoming connections
    public static final int STATE_CONNECTING = 2; // now initiating an outgoing connection
    public static final int STATE_CONNECTED = 3;  // now connected to a remote device
	
    public static final String TAG = "DEBUG OF OBDDROID";
    
	public ConnectService(BluetoothDevice device)
	{
		//mHandler = handler;
		mAdapter = BluetoothAdapter.getDefaultAdapter();
		mState = STATE_NONE;
		dev = device;
	}
	
	public void startService()
	{
		
		connect(dev);
	}
	
	public void onCreate() 
	{
		super.onCreate();
		notifyMan = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
		context = getApplicationContext();
		notificationIntent = new Intent(this, ConnectService.class);
		contentIntent = PendingIntent.getActivity(this, 0, notificationIntent, 0);
		
		long when = System.currentTimeMillis();
		Notification notification = new Notification(android.R.drawable.stat_notify_error, "OBD Service Running", when);
		notification.setLatestEventInfo(context, "OBD Service Running", "", contentIntent);
		notification.flags |= Notification.FLAG_NO_CLEAR;
		notification.flags |= Notification.FLAG_ONGOING_EVENT;
		notifyMan.notify(4, notification);
	}

	public void onDestroy() 
	{
		super.onDestroy();
		stopService();
		stopSelf();
	}
	
	public boolean stopService() 
	{
		if (mConnectThread == null) 
		{
			return true;
		}
		while (mConnectThread.isAlive()) 
		{
			try 
			{
				mConnectThread.cancel();
				mConnectThread.join(300);
			} catch (InterruptedException e) 
			{
		    	StringWriter strw = new StringWriter();
		    	PrintWriter ptrw = new PrintWriter(strw);
		    	e.printStackTrace(ptrw);
				notifyMessage(e.getMessage(),strw.toString(), 0);
			}
		}
		mConnectThread.cancel();
		stopSelf();
		return true;
	}
	
	public void connect(BluetoothDevice dev)
	{
		if(mState == STATE_CONNECTING)
		{
			if(mConnectThread != null)
			{
				mConnectThread.cancel();
				mConnectThread = null;
			}
			
			if(mConnectedThread != null)
			{
				mConnectedThread.cancel();
				mConnectedThread = null;
			}	
		}
		
		mConnectThread = new ConnectThread(dev, this);
		Log.d(TAG, "Connect Thread started");
		mConnectThread.start();
		Log.d(TAG, "Connected");
		setState(STATE_CONNECTING);
	}
	
	public String getResult(ObdFunction func)
	{
		try {
			return mConnectedThread.runCommand(func);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		return "null";
	}
	
	public void setState(int st)
	{
		mState = st;
	}
	
	public void notifyMessage(String msg, String longMsg, int notifyId) 
	{
		long when = System.currentTimeMillis();
		Notification notification = new Notification(android.R.drawable.stat_notify_error, msg, when);
		notification.setLatestEventInfo(context, msg, longMsg, contentIntent);
		notifyMan.notify(notifyId, notification);
	}
	
	@Override
	public IBinder onBind(Intent intent) {
		// TODO Auto-generated method stub
		return binder;
	}
	
	public class ConnectServiceBinder extends Binder 
	{
		ConnectService getService() 
		{
			return ConnectService.this;
		}
	}

}*/

