package org.obddroid.connect;

import java.io.IOException;
import java.util.UUID;

import org.obddroid.activity.RunFunction;
import org.obddroid.function.ObdFunction;
import org.obddroid.ui.OBDUI;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;


public class ConnectThread extends Thread
{
	private static final String TAG = "DEBUG OF OBDDROID";
	private static final UUID MY_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
	
	private final BluetoothSocket mmSocket;
	private final BluetoothDevice mmDevice;
	private final BluetoothAdapter mAdapter;
	private Handler handler = new Handler();
	private ObdFunction cmd = new ObdFunction("ate0","Serial Echo Off ate0","","");
	
	public static ConnectedThread ct = null;
	public static int state;
	private ObdFunction func = null;
	private OBDUI act = null;
	
	public static final int STATE_NONE = 0;       // we're doing nothing
    public static final int STATE_LISTEN = 1;     // now listening for incoming connections
    public static final int STATE_CONNECTING = 2; // now initiating an outgoing connection
    public static final int STATE_CONNECTED = 3;  // now connected to a remote device
    
	public ConnectThread(BluetoothDevice dev, OBDUI activity)
	{
		mmDevice = dev;
		act = activity;
		mAdapter = BluetoothAdapter.getDefaultAdapter();
			
		BluetoothSocket tmp = null;
		try
		{
			tmp = mmDevice.createRfcommSocketToServiceRecord(MY_UUID);
		}
		catch (IOException e)
		{
			Log.d(TAG, "Socket Create Failed" + e.getMessage());
			
		}
		mmSocket = tmp;
		state = STATE_NONE;
	}
	
	public void run()
	{
		
		//cancel discovery so it will not slow connection
		mAdapter.cancelDiscovery();
		
		int x = 0;
		while(state != STATE_CONNECTED && x <= 5)
		{
			try
			{	
				Log.d(TAG,"Starting Device ...");
				act.msg("Starting Device...","Starting Device...","Bluetooth Device is being Connected to");
				
				mmSocket.connect();
				state = STATE_CONNECTED;
				act.msg("Connected", "Connected","Connected to Bluetooth Device");
				Log.d(TAG,"CONNECTED");
			
				//Turn echo off so that the response does not contain the request
				try 
				{
					ct = new ConnectedThread(mmSocket);
					ct.start();
					ct.join(100);
					act.msg("Configuring Device...", "Configuring Device...", "Device is Being Configured");
					
					cmd = ct.runCommand(cmd);
					String check = cmd.formatResult();
					if(!check.equals("OK"))
					{
						cmd = ct.runCommand(cmd);
					}
				
					act.msg("Device Ready", "Device Ready", "Device is Ready");
					
				} catch (InterruptedException e) {
					act.msg("Connection Lost","Connection Lost","Connection to Device Lost");
					e.printStackTrace();
				}
			
			}
			catch(IOException e)
			{
				//try
				//{
				act.msg("Connection Failed....","Connection Failed...." , "Connection to Bluetooth Device Failed");
				Log.d(TAG,"Connection Failed...."+ e.getMessage());
				//service.notifyMessage("Connection Failed",e.getMessage(), 0);

				state = STATE_NONE;
				/*mmSocket.close();
					
				} 
				catch (IOException e1) 
				{
					act.msg("Could not Close Socket...." + e1.getMessage());
					e1.printStackTrace();
				}*/
				connectionFailed();
			
			}
			x++;
		}
		if(x >= 5)
		{
			act.msg("Connection Timed Out", "Connection Timed Out", "Could not Connect to Bluetooth Device");
		}

	
	}
	
	public void connectionFailed()
	{
		Message msg = handler.obtainMessage();
		Bundle bundle = new Bundle();
		state = STATE_NONE;
		msg.setData(bundle);
		handler.sendMessage(msg);
	}
	
	public void cancel()
	{
		try 
		{
			mmSocket.close();
			state = STATE_NONE;
		} 
		catch (IOException e) 
		{
			e.printStackTrace();
		}
		
	}
	
	public void setState(int st)
	{
		state = st;
	}
	public boolean isConnected()
	{
		return(state == STATE_CONNECTED);
	}

}
