package org.obddroid.connect;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

import org.obddroid.activity.RunFunction;
import org.obddroid.function.ObdFunction;


import android.bluetooth.BluetoothSocket;
import android.util.Log;

public class ConnectedThread extends Thread
{
	boolean no = false;
	
	private final BluetoothSocket sock;
    private final InputStream in;
    private final OutputStream out;
    private boolean ready = false;
    public ArrayList<Byte> buff = null;
    private ObdFunction func;
    private ConnectService service;    
    
    public static final int STATE_NONE = 0;       // we're doing nothing
    public static final int STATE_LISTEN = 1;     // now listening for incoming connections
    public static final int STATE_CONNECTING = 2; // now initiating an outgoing connection
    public static final int STATE_CONNECTED = 3;  // now connected to a remote device
    
    public static final String TAG = "DEBUG OF OBDDROID";
    
	public ConnectedThread(BluetoothSocket socket)
	{
		
		sock = socket;
		InputStream tmpIn = null;
        OutputStream tmpOut = null;
        
        try {
            tmpIn = sock.getInputStream();
            tmpOut = sock.getOutputStream();
        } catch (IOException e) {
        	e.printStackTrace();
        }
        
        buff = new ArrayList<Byte>();
        in = tmpIn;
        out = tmpOut;
	}
	
	public void run()
	{
		while(true)
		{
			if(!ready)
			{
				readResult();
			}
		}
	}
	
	public void readResult() 
	{
		byte c = 0;
		Log.d(TAG, "Read Result Started......");
		if(buff != null)
		{
			buff.clear();
		}
		try {
			
			//loop until a '>' is recieved which indicates that the ELM is 
			//finished sending data		
			
			while ((char)(c = (byte)in.read()) != '>') 
			{
				Log.d(TAG,"Read In: "+ (char)c);
				buff.add(c);	
			}
			ready = true;
			return;
			
		} catch (IOException e) {
			Log.d(TAG, "Error Reading Result: "+e.getMessage());
			
		}
		
	}
	
	public ObdFunction runCommand(ObdFunction cmd) throws InterruptedException 
	{
		String command = cmd.getFunc();
		cmd.setInputStream(in);
		cmd.setOutputStream(out);
		sendFunc(command);
		Log.d(TAG, "Function Sent....");
		
		while (!ready)
		{
			//wait for result
		}
		ready = false;
		
		cmd.setBuf(buff);
		return cmd;
	}
	
	public void sendFunc(String func) {
		try {
			
			func += "\r\n";
			out.write(func.getBytes());
			Log.d(TAG, "Sent command: "+func);
			Log.d(TAG,"Wrote out: "+ func.getBytes());
			out.flush();
			
		} catch (Exception e) {
			cancel();
			// TODO: handle exception
		}
	}
	
	public void cancel()
	{
		try 
		{
			//service.setState(STATE_NONE);
			sock.close();
		} 
		catch (IOException e) 
		{
			e.printStackTrace();
		}
		
		
	}
}
