package org.obddroid.function;


public class DtcNumfunction extends ObdFunction {
	
	public boolean celOn = false;
	public int codeCount = -1;
	
	public DtcNumfunction()
	{
		super("0101","DTC Status", "", "");
	}
	
	public DtcNumfunction(DtcNumfunction other)
	{
		super(other);
	}
	
	public String formatResult()
	{
		String res = super.formatResult();
		String byte1 = res.substring(4,6);
		
		int mil = Integer.parseInt(byte1,16);
		
		String result = "MIL is off, ";
		
		if ((mil & 0x80) == 1) 
		{
			celOn = true;
			result = "MIL is on, ";
		}
		codeCount = mil & 0x7f;			//get code count by removinG MSB
		result += codeCount + " codes";
		
		return result;
	}
	
	public int getCodeCount()
	{
		formatResult();
		return codeCount;
	}
	
	public boolean getCelOn()
	{
		return celOn;
	}
	
}
