package org.obddroid.function;

import android.util.Log;

public class EngineRPMFunction extends ObdFunction
{
	
	
	public EngineRPMFunction() {
		super("010C","RPM","RPM","RPM");
	}
	public EngineRPMFunction(EngineRPMFunction other) {
		super(other);
	}
	public String formatResult() 
	{
		String res = super.formatResult();
		Log.d(TAG,"Res for RPM is: "+res);
		if ("NODATA".equals(res)) 
		{
			return "NODATA";
		}
		String byteStrOne = res.substring(4,6);
		Log.d(TAG,"Byte one is:"+byteStrOne);
		String byteStrTwo = res.substring(6,8);
		int b = Integer.parseInt(byteStrTwo,16);
		int a = Integer.parseInt(byteStrOne,16);
		
		intValue = transform(a,b);
		data = String.format("%d %s", intValue, "RPM");
		return data;
	}
	public int transform(int a, int b) {
		return (int)((double)(a*256+b)/4.0);
	}
}

