package org.obddroid.function;

import org.obddroid.connect.ConnectThread;
import org.obddroid.connect.ConnectedThread;

import android.util.Log;

public class ErrorCodesFunction extends ObdFunction
{
	private StringBuffer codes = null;
	public ConnectedThread ct = ConnectThread.ct;
	
	public ErrorCodesFunction() 
	{
		super("03","Trouble Codes","","");
		codes = new StringBuffer();
	}
	
	public ErrorCodesFunction(String cmd, String desc, String resType, String impType) 
	{
		super(cmd, desc, resType, impType);
		codes = new StringBuffer();
	}
	
	public ErrorCodesFunction(ErrorCodesFunction other) 
	{
		super(other);
		codes = new StringBuffer();
	}
	
	public void run() 
	{
		DtcNumfunction numCmd = new DtcNumfunction();
		numCmd.setInputStream(in);
		numCmd.setOutputStream(out);
		
		try {
			ct.runCommand(numCmd);
			int count = numCmd.getCodeCount();
			Log.d(TAG, "Count :"+count);
			int dtcNum = (count+2)/3;
			for (int i = 0; i < dtcNum; i++) {
				ct.runCommand(this);
				String res = getResult();
				for (int j = 0; j < 3; j++) 
				{
					String rep = res.substring(3+j*6, 4+j*6);
					String byte1 = res.substring(4+j*6,5+j*6);
					String byte2 = res.substring(6+j*6,8+j*6);
					String code = "P";
					
					String ans = byte1+byte2;
					System.out.println(ans);
					if(ans.equals("000"))
						break;
					
					//decode the first digit of the code and append to rest of code
					int digit = Integer.parseInt(rep,16);
					if( 4 <= digit && digit <= 7)
					{
						digit -= 4;
						code = "C"+digit;
					}
					else if( 8 <= digit && digit <= 11)
					{
						digit -= 8;
						code = "B"+digit;
					}
					else if( 12 <= digit && digit <= 15)
					{
						digit -=12;
						code = "U"+digit;
					}
					else
					{
						code = "P"+digit;
					}
					
					code += ans;
			
					codes.append(code);
					codes.append("\n");
					
					//System.out.println(codes.toString());
				}
			}
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (StringIndexOutOfBoundsException e1){
			
		}catch (NumberFormatException e2){
			
		}catch (NullPointerException e){
			
		}
		
	}
	
	public String formatResult() 
	{
//		String res = getResult();
//		String[] ress = res.split("\r");
//		for (String r:ress) {
//			String k = r.replace("\r","");
//			codes.append(k);
//			codes.append("\n");
//		}
//		Log.d(TAG, "Errors: "+codes.toString());
		return codes.toString();
	}
	

}
