package org.obddroid.function;

public class FuelEconomyFunction extends ObdFunction 
{
	public static final double AIR_FUEL_RATIO = 14.64;
	public static final double FUEL_DENSITY_GRAMS_PER_LITER = 720.0;
	
	public double fuelEcon = -9999.0;
	
	public FuelEconomyFunction() {
		super("","Fuel Economy","kml","mpg");
	}
	public FuelEconomyFunction(FuelEconomyFunction other) {
		super(other);
	}
	
	public void run() 
	{
		try 
		{
			MassAirFlowFunction maf = new MassAirFlowFunction();
			SpeedFunction speed = new SpeedFunction();
			runFunc(maf);
			maf.formatResult();
			double mafV = maf.getMAF();
			if (mafV == -9999.0) 
				fuelEcon = -9999.0;
			
			runFunc(speed);
			speed.formatResult();
			double speedV = (double)speed.getInt();
			fuelEcon = (14.7  * 6.17 * 454.0 * speedV * 0.621371) / (3600.0 * mafV);
		} 
		catch (Exception e) 
		{
			//setError(e);
		}
	}
	
	public void runFunc(ObdFunction cmd) 
	{
		//cmd.setInputStream(in);
		//cmd.setOutputStream(out);
		cmd.start();
		try {
			cmd.join();
		} 
		catch (InterruptedException e) 
		{
			//setError(e);
		}
	}
	
	public String formatResult() 
	{
		if (fuelEcon < 0) 
		{
			return "null";
		}
		
		return String.format("%.1f %s", fuelEcon, impType);
	}
}
