package org.obddroid.function;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;

import android.util.Log;

public class ObdFunction extends Thread 
{
	//debugging purposes
	public static final String TAG = "DEBUG OF OBDDROID";
	
	public String func = null;
	public String desc = null;
	public String resType = null;
	public String impType = null;
	public String raw = null;
	public String data = null;
	public int intValue = -99999;
	
	public InputStream in = null;
	public OutputStream out = null;
	public ArrayList<Byte> buff = null;
	
	public ObdFunction(String c, String d, String r, String i)
	{
		func = c;
		desc = d;
		resType = r;
		impType = i;
		buff = new ArrayList<Byte>();
	}
	
	public ObdFunction(ObdFunction other)
	{
		this(other.func, other.desc, other.resType, other.impType);
	}

	public boolean isImperial() 
	{
		/*if (connectThread != null && connectThread.getImperialUnits()) 
			{
				return true;
			}*/
		return false;
	}
	
	public void run() 
	{
		
	}

	
	public void readResult() 
	{
		byte c = 0;
		Log.d(TAG, "Read Result Started......");
		buff.clear();
		
		try 
		{	
			//loop until a '>' is recieved which indicates that the ELM is 
			//finished sending data			
			while ((char)(c = (byte)in.read()) != '>') 
			{
				Log.d(TAG,"Read In: "+c);
				buff.add(c);	
			}
			return;
		} catch (IOException e) {
			Log.d(TAG, "Error Reading Result: "+e.getMessage());
			
		}
		
	}
	
	public void setBuf(ArrayList<Byte> buf)
	{
		buff = buf;
	}
	
	public String getResult() 
	{
		raw = new String(getByteArray());
		return raw;
	}
	
	//loop through buffer and store all bytes as byte array
	public byte[] getByteArray() 
	{
		byte[] data = new byte[buff.size()];
		for (int i = 0; i < this.buff.size(); i++) 
		{
			data[i] = this.buff.get(i);
		}
		return data;
	}
	
	/**
	 * This function splits the result string into a string array and uses that to
	 * remove the space in the beginning of the string.
	 */
	public  String formatResult() 
	{
		String res = getResult();
		String[] ress = res.split("\r");
		data = ress[0].replace(" ","");
		return data;
	}
	
	public void setInputStream(InputStream in) {
		this.in = in;
		Log.d(TAG,"In is set.....");
	}
	
	public void setOutputStream(OutputStream out) {
		this.out = out;
	}
	
	public String getDesc()
	{
		return desc;
	}
	
	public String getFunc()
	{
		return func;
	}
	
	public String getRawResult()
	{
		return raw;
	}
	
}
