package org.obddroid.function; 


public class PressureObdFunction extends IntObdFunction
{
	public PressureObdFunction(String cmd, String desc, String resType, String impType) {
		super(cmd,desc,resType,impType);
	}
	public PressureObdFunction(PressureObdFunction other) {
		super(other);
	}
	public String formatResult()
	{
		String res = super.formatResult();
		
		if (!isImperial() || "NODATA".equals(res) || "".equals(res)) 
		{
			data = res;
			return data;
		}
		
		double atm = intValue * 1.0 / 101.3;
		data = String.format("%.2f %s", atm, impType);
		return data;
	}
}
