package org.obddroid.function;

public class SpeedFunction extends IntObdFunction {
	
	public SpeedFunction()
	{
		super("010d", "Speed", "km/h", "mph");
	}
	
	public SpeedFunction(SpeedFunction other)
	{
		super(other);
	}
	
	/**
	 * If the user has choosen to view imperial units this function will be called
	 * to transform the result into miles per hour for the user to view.
	 */
	public int getImpUnit()
	{
		if(intValue <= 0)
			return 0;
		
		return (int)(intValue * .625);
	}

}
