package org.obddroid.function;

public class TimingAdvanceFunction extends ObdFunction {
	
	public TimingAdvanceFunction()
	{
		super("010e", "Timing Advance", "deg", "deg");
	}
	
	public TimingAdvanceFunction(TimingAdvanceFunction other)
	{
		super(other);
	}
	
	/**
	 * This function has the purpose of formating the data into a 
	 * readable form for the user.
	 */
	public String formatResult()
	{
		String res = super.formatResult();
		
		if("NODATA".equals(res))
		{
			return "NODATA";
		}
		
		String A = res.substring(4,6);				//get the data from the return string
		double a = (double)Integer.parseInt(A,16);	//convert hex number to decimal
		double ans = (a/2.0)/64;					//formula to convert to timing in degrees
		
		data =  String.format("%.1f %s", ans, resType);  //return proper formatted string that the user can read
		return data;
	}

}
