package org.obddroid.ui;


import org.obddroid.connect.ConnectThread;
import org.obddroid.connect.ConnectedThread;
import org.obddroid.function.ErrorCodesFunction;
import org.obddroid.function.ObdFunction;

import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ListView;
import android.widget.Toast;

public class ErrorCode extends ListActivity 
{
	public ConnectedThread ct = ConnectThread.ct;
	
	public Context ctx;
	public Resources res;
	public String troubleCode;
	public String[] errors;
	private static final String TAG = "DEBUG OF OBDDROID";
	
    @Override
    public void onCreate(Bundle savedInstanceState) 
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.errorcode);
        
        Drawable d = getResources().getDrawable(R.drawable.error2);

        ListView lv = getListView();



	   // registerForContextMenu(getListView());

        ctx = getApplicationContext();
        res = ctx.getResources();

        errors = res.getStringArray(R.array.error_names);

        setListAdapter(new ImageAndTextAdapter(ctx, R.layout.errorrows, errors, d));
        

        error();
        
        lv.setOnItemClickListener(new OnItemClickListener() {
        	public void onItemClick(AdapterView<?> parent, View view,
                int position, long id) 
            {
        		Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse("http://www.obd-codes.com/" + errors[position]));
       		 	startActivity(browserIntent);
            }
          });
        
    }
    /*
    @Override
	public void onCreateContextMenu(ContextMenu menu, View v, ContextMenuInfo menuInfo) 
    {
	     menu.setHeaderTitle("Error Code " + menuInfo);
	     String[] menuItems = new String[] {"More Information"};
	     for (int i = 0; i<menuItems.length; i++) 
	     {
	       menu.add(Menu.NONE, i, i, menuItems[i]);
	     }
	 }
    
	 public boolean onContextItemSelected(MenuItem item) 
	 {	
		 troubleCode = item.toString();
		 Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse("http://www.obd-codes.com/" + troubleCode));
		 startActivity(browserIntent);

		 return true;
	 }
    */
    public void error()
    {
    	ObdFunction error = new ErrorCodesFunction();
    	Drawable d = getResources().getDrawable(R.drawable.error2);
    	String [] errors;
        
        try 
        {
        	error.start();
			error.join();
			
			errors = error.formatResult().split("\n");
			errors[0] = "P0420";
	        
	        for(int x = 0; x<errors.length; x++)
	        {
	        	Log.d(TAG, "Error :"+errors[x]);
	        }
	    
	        setListAdapter(new ImageAndTextAdapter(ctx, R.layout.errorrows, errors, d));
		
        }catch (InterruptedException e) 
		{
			e.printStackTrace();
		} catch(ArrayIndexOutOfBoundsException e){
			
		}catch(StringIndexOutOfBoundsException e){
			
		}catch(NullPointerException e)
		{
			
		}
    }
    
	public void clear(View view)
	{
		ct.sendFunc("04");
		//error();
	}
}

