package org.obddroid.ui;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

public class ImageAndTextAdapter extends ArrayAdapter<String> 
{
    private LayoutInflater mInflater;

    private String[] mStrings;
    private Drawable mIcon;

    private int mViewResourceId;

    public ImageAndTextAdapter(Context ctx, int viewResourceId, String[] strings, Drawable icon) 
    {
            super(ctx, viewResourceId, strings);

            mInflater = (LayoutInflater)ctx.getSystemService(Context.LAYOUT_INFLATER_SERVICE);

            mStrings = strings;
            mIcon = icon;

            mViewResourceId = viewResourceId;
    }
  
    @Override
    public int getCount() {
            return mStrings.length;
    }

    
    @Override
    public String getItem(int position) {
            return mStrings[position];
    }

    
    @Override
    public long getItemId(int position) 
    {
            return position;
    }

    
    @Override
    public View getView(int position, View convertView, ViewGroup parent) 
    {
            convertView = mInflater.inflate(mViewResourceId, null);

            ImageView iv = (ImageView)convertView.findViewById(R.id.option_icon);        
            iv.setImageDrawable(mIcon);

            TextView tv = (TextView)convertView.findViewById(R.id.option_text);
            tv.setText(mStrings[position]);

            return convertView;
    }
}