package org.obddroid.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;


import org.obddroid.connect.ConnectThread;
import org.obddroid.connect.ConnectedThread;
import org.obddroid.function.AirIntakeTempFunction;
import org.obddroid.function.BatteryVoltageFunction;
import org.obddroid.function.DtcNumfunction;
import org.obddroid.function.EngineLoadFunction;
import org.obddroid.function.EngineRPMFunction;
import org.obddroid.function.EngineRunTimeFunction;
import org.obddroid.function.ErrorCodesFunction;
import org.obddroid.function.FuelEconomyFunction;
import org.obddroid.function.FuelLevelFunction;
import org.obddroid.function.FuelPressureFunction;
import org.obddroid.function.IntakeManifoldPressureFunction;
import org.obddroid.function.MassAirFlowFunction;
import org.obddroid.function.ObdFunction;
import org.obddroid.function.PressureObdFunction;
import org.obddroid.function.SpeedFunction;
import org.obddroid.function.TempObdFunction;
import org.obddroid.function.ThrottlePositionFunction;
import org.obddroid.function.TimingAdvanceFunction;

import android.app.Activity;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroup.LayoutParams;
import android.view.ViewGroup.MarginLayoutParams;

public class LiveData extends Activity
{
	final private ArrayList<ObdFunction> functions = getFunctions();
	private boolean start = false;
	private Handler handler = null;
	
	static final int TABLE_ROW_MARGIN = 6;
	
	public Map<String, String> data = null;
	public UpdateThread update = null;
	public ConnectedThread ct = ConnectThread.ct;
	
	public void onCreate(Bundle savedInstanceState) 
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.livedata);
        
        handler = new Handler();
        createTable();

    }
	
	//creates the first initial table
	public void createTable()
	{
		TableLayout t1 = (TableLayout) findViewById(R.id.tableLayout1);
		t1.removeAllViews();
		
		for(int x = 0; x<functions.size();x++)
		{
			String name = functions.get(x).getDesc();
			String val = "--";
			
			addTableRow(t1, name, val);
		}
	}
	
	public void updateTable(Map <String,String> data)
	{
		TableLayout t1 = (TableLayout) findViewById(R.id.tableLayout1);
		t1.removeAllViews();
		
		Set<String> keySet = data.keySet();
    	String[] keys = keySet.toArray(new String[0]);
    	Arrays.sort(keys);
    	
    	for (String k:keys) 
    	{
    		addTableRow(t1,k,data.get(k));
    	}
	}
	
	private void addTableRow(TableLayout tl, String key, String val) 
	{
    	TableRow tr = new TableRow(this);
		MarginLayoutParams params = new ViewGroup.MarginLayoutParams(
				LayoutParams.WRAP_CONTENT,
                LayoutParams.WRAP_CONTENT);
		params.setMargins(TABLE_ROW_MARGIN,
						  TABLE_ROW_MARGIN,
						  TABLE_ROW_MARGIN,
						  TABLE_ROW_MARGIN
						 );
		tr.setLayoutParams(params);
		tr.setBackgroundColor(Color.BLACK);
		
		TextView name = new TextView(this);
		name.setGravity(Gravity.RIGHT);
		name.setText(key + ": ");
		
		TextView value = new TextView(this);
		value.setGravity(Gravity.LEFT);
		value.setText(val);
		
		tr.addView(name);
		tr.addView(value);
		tl.addView(tr,new TableLayout.LayoutParams(
                    LayoutParams.WRAP_CONTENT,
                    LayoutParams.WRAP_CONTENT));
    }
	public void removeFunction(ObdFunction f, ArrayList<ObdFunction> funcs)
	{ 
		for(int x = 0; x< funcs.size(); x++)
		{
			if(f.getDesc().equals(funcs.get(x).getDesc()))
			{
				funcs.remove(funcs.get(x));
			}
		}
	}
	
	public static ArrayList<ObdFunction> getFunctions() 
    {
    	ArrayList<ObdFunction> funcs = new ArrayList<ObdFunction>();
		
		funcs.add(new AirIntakeTempFunction());
		funcs.add(new BatteryVoltageFunction());
		funcs.add(new IntakeManifoldPressureFunction());
		funcs.add(new PressureObdFunction("0133","Barometric Press","kPa","atm"));
		funcs.add(new SpeedFunction());
		funcs.add(new ThrottlePositionFunction());
		funcs.add(new EngineRPMFunction());
		funcs.add(new FuelPressureFunction());
		funcs.add(new TempObdFunction("0105","Coolant Temperature","C","F"));
		funcs.add(new EngineLoadFunction());
		funcs.add(new MassAirFlowFunction());
		//funcs.add(new FuelEconomyFunction());
		funcs.add(new FuelLevelFunction());
		funcs.add(new EngineRPMFunction());
		funcs.add(new EngineRunTimeFunction());
		funcs.add(new TimingAdvanceFunction());

		return funcs;
	}
    public void updateDataTable(final Map<String,String> dataMap) 
    {
    	handler.post(new Runnable() {
			public void run() {
				updateTable(dataMap);
			}
		});
    }
	
	public void liveData(View view)
	{
		start = !start;
		
		if(start)
		{
			update = new UpdateThread();
			update.start();
		}
	}
	
	public class UpdateThread extends Thread
	{
		public void run()
		{
			
			while(start)
			{
				data = new HashMap<String,String>();
				for(int x = 0; x< functions.size();x++)
				{
					ObdFunction func = functions.get(x);
					try 
					{
						
						func = ct.runCommand(func);
					
						String name = func.getDesc();
						String ans = func.formatResult();
						if(ans.equals("NODATA"))
						{
							functions.remove(func);
						}
						data.put(name, ans);
						//sleep(10);
					} catch (InterruptedException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}catch (StringIndexOutOfBoundsException e1){
						String name = func.getDesc();			//place "no data" if error
						String ans = "No Data";
						data.put(name, ans);
					}catch (NumberFormatException e2){
						String name = func.getDesc();			//place "no data" if error
						String ans = "No Data";
						data.put(name, ans);
					}
				}
				
				updateDataTable(data);
			}
		}
	}
	
}

