package org.obddroid.ui;



import java.util.ArrayList;
import java.util.Arrays;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;

import com.androidplot.series.XYSeries;
import com.androidplot.ui.AnchorPosition;
import com.androidplot.xy.LineAndPointFormatter;
import com.androidplot.xy.SimpleXYSeries;
import com.androidplot.xy.XLayoutStyle;
import com.androidplot.xy.XYPlot;
import com.androidplot.xy.YLayoutStyle;

public class LogGraph extends Activity 
{
	private XYPlot logPlot;
	
	public void onCreate(Bundle savedInstanceState) 
	{
	    super.onCreate(savedInstanceState);
	    setContentView(R.layout.loggraph);
	    Double series1Numbers[] = new Double[LogView.logArray.size()];
	    
	    // Turn our log ArrayList into an array the graph can read
	    for (int i = 0; i < LogView.logArray.size(); i++)
	    {
	    	series1Numbers[i] = LogView.logArray.get(i);
	    }
	    
	    Bundle b = getIntent().getExtras();
	    String functionName = b.getString("name");
	    
	    
	    
	    // GRAPHING STUFF-------------
        logPlot = (XYPlot) findViewById(R.id.logPlot);
 
        // Turn the above arrays into XYSeries:
        XYSeries series1 = new SimpleXYSeries(Arrays.asList(series1Numbers), SimpleXYSeries.ArrayFormat.Y_VALS_ONLY, "Series1");                             
 
        // Create a formatter to use for drawing a series using LineAndPointRenderer:
        LineAndPointFormatter series1Format = new LineAndPointFormatter(Color.rgb(0, 200, 0), Color.rgb(0, 100, 0), Color.rgb(150, 190, 150));              
 
        // Add series1 to the xyplot:
        logPlot.addSeries(series1, series1Format);
 
        logPlot.setTitle(functionName);
        logPlot.setDomainLabel("Time"); 
        logPlot.setDomainStepValue(5);
        logPlot.setRangeStepValue(6);
        logPlot.getGraphWidget().getRangeLabelPaint().setTextSize(10);
        logPlot.getGraphWidget().getDomainLabelPaint().setTextSize(10);
        logPlot.getLayoutManager().remove(logPlot.getLegendWidget());
        logPlot.getLayoutManager().remove(logPlot.getRangeLabelWidget());
        logPlot.getLayoutManager().position(logPlot.getDomainLabelWidget(), 137, XLayoutStyle.ABSOLUTE_FROM_RIGHT, 0, YLayoutStyle.ABSOLUTE_FROM_BOTTOM, AnchorPosition.BOTTOM_MIDDLE);
        logPlot.disableAllMarkup();
        // END GRAPHING STUFF---------------
	}
	
    public void fileSelect(View view)
    {
    	Intent newActivity = new Intent(LogGraph.this, LogSelect.class);
		startActivity(newActivity);
    }
    
    public void backToLog(View view)
    {
    	Intent newActivity = new Intent(LogGraph.this, LogView.class);
		startActivity(newActivity);
    }
}
