package org.obddroid.ui;


import java.io.File;
import java.util.HashMap;
import java.util.Map;

import android.app.ListActivity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;

public class LogSelect extends ListActivity 
{
	Map<String, File> logMap = null;
	//logMap = new HashMap<String, File>();

	
	String[] LOGS = new String[] {
	    "Air Intake Temperature", "Battery Voltage", "Coolant Temperature", "Engine Load", "Fuel Economy", "Fuel Pressure", "Intake Manifold Pressure", "Mass Air Flow", "RPM", "Speed", "Throttle Position"};
	
    /** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) 
	{
	  super.onCreate(savedInstanceState);

		logMap = new HashMap<String, File>();
		logMap.put("Air Intake Temperature", new File("/sdcard/obd/airintaketemp.txt"));
		logMap.put("Battery Voltage", new File("/sdcard/obd/batteryvoltage.txt"));
		logMap.put("Coolant Temperature", new File("/sdcard/obd/coolanttemp.txt"));
		logMap.put("Engine Load", new File("/sdcard/obd/engineload.txt"));
		logMap.put("Fuel Economy", new File("/sdcard/obd/fueleconomy.txt"));
		logMap.put("Fuel Pressure", new File("/sdcard/obd/fuelpressure.txt"));
		logMap.put("Intake Manifold Pressure", new File("/sdcard/obd/intakemanifoldpressure.txt"));
		logMap.put("Mass Air Flow", new File("/sdcard/obd/massairflow.txt"));
		logMap.put("Speed", new File("/sdcard/obd/speed.txt"));
		logMap.put("Throttle Position", new File("/sdcard/obd/throttleposition.txt"));
		logMap.put("RPM", new File("/sdcard/obd/rpm.txt"));
		
	  
	  setListAdapter(new ArrayAdapter<String>(this, R.layout.logselect, LOGS));

	  ListView lv = getListView();
	  lv.setTextFilterEnabled(true);

	  lv.setOnItemClickListener(new OnItemClickListener() 
	  {
	    public void onItemClick(AdapterView<?> parent, View view, int position, long id)
	    {
	    	String logName = ((TextView) view).getText().toString();
	    	File fin = logMap.get(logName);
	    	String filePath = fin.getPath();
	    	Bundle b = new Bundle();
			b.putString("key", filePath);
			b.putString("name", logName);

	    	Intent newActivity = new Intent(LogSelect.this, LogView.class);
	    	newActivity.putExtras(b);
			startActivity(newActivity);
	    }
	    	
	   }
	  );
	}
}