package org.obddroid.ui;


import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.text.method.ScrollingMovementMethod;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.TextView;
import android.widget.Toast;

public class LogView extends Activity 
{
	private Handler handler = null;
	public static ArrayList<Double> logArray = new ArrayList<Double>();
	public String functionName;
	public String fileName;
	
	public void onCreate(Bundle savedInstanceState) 
	{
	    super.onCreate(savedInstanceState);
	    setContentView(R.layout.logview);
	    //TextView tv = (TextView) findViewById(R.id.logscreen);
	    //tv.setMovementMethod(new ScrollingMovementMethod());
	    
	    Bundle b = getIntent().getExtras();
	    fileName = b.getString("key");
	    functionName = b.getString("name");
	    
	    handler = new Handler();

	    try 
	    {	        
	        // if file the available for reading
	          BufferedReader buffreader = new BufferedReader(new FileReader(fileName));
	     
	          String line;
	     
	          // read every line of the file into the line-variable, on line at the time
	          while (( line = buffreader.readLine()) != null) 
	          {
	        	  setText(line, false);
	          }
	        
	        // close the file again
	          buffreader.close();
	      } catch (FileNotFoundException e) 
	      	{
	        // do something if the myfilename.txt does not exits
	      	} catch (IOException e)
	      	{
	      		
	      	}
	}
	
	
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
	    MenuInflater inflater = getMenuInflater();
	    inflater.inflate(R.layout.logviewmenu, menu);
	    return true;
	}

	
	public void setText(final String value, final boolean clear)
	{
		handler.post(new Runnable()
		{
			public void run()
			{
				TextView txtView = (TextView) findViewById(R.id.logscreen);
				txtView.setMovementMethod(new ScrollingMovementMethod());
				txtView.setClickable(false);
				txtView.setLongClickable(false); 
				txtView.append(value + "\n");
			}	
		});
	}
	
	@Override
	public boolean onOptionsItemSelected(MenuItem item) 
	{    
		double total = 0.0;
		TextView tv = (TextView) findViewById(R.id.logscreen);
	    String temp = tv.getText().toString(); 
		String[] lineSplit = temp.split("\n");
		double templog = 0;
		logArray.removeAll(logArray);
		
		
    	for (int i = 0; i < lineSplit.length; i++)
    	{
    		String[] value = lineSplit[i].split(" ");
    		if (!(Math.abs(templog - Double.parseDouble(value[2])) > 100)) // Prevent graphing extreme variations/errors
    		{
    			total = total + Double.parseDouble(value[2]);
    			logArray.add(Double.parseDouble(value[2]));
    		}
    		templog = Double.parseDouble(value[2]);
    	}
    	
	    // Handle item selection
	    switch (item.getItemId()) 
	    {
	    case R.id.average:
	        Toast.makeText(getApplicationContext(), "Average: " + (total/lineSplit.length), Toast.LENGTH_SHORT).show();
	        return true;
	    case R.id.graph:
	    	Bundle b = new Bundle();
			b.putString("name", functionName);
	    	Intent newActivity = new Intent(LogView.this, LogGraph.class);
	    	newActivity.putExtras(b);
			startActivity(newActivity);
	        return true;
	    default:
	        return super.onOptionsItemSelected(item);
	    }
	}
}