package org.obddroid.ui;


import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;

import org.obddroid.connect.ConnectThread;
import org.obddroid.connect.ConnectedThread;
import org.obddroid.function.AirIntakeTempFunction;
import org.obddroid.function.BatteryVoltageFunction;
import org.obddroid.function.EngineRPMFunction;
import org.obddroid.function.FuelPressureFunction;
import org.obddroid.function.IntakeManifoldPressureFunction;
import org.obddroid.function.MassAirFlowFunction;
import org.obddroid.function.ObdFunction;
import org.obddroid.function.SpeedFunction;
import org.obddroid.function.ThrottlePositionFunction;
import org.obddroid.function.FuelEconomyFunction;
import org.obddroid.function.CoolantTempFunction;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;

import com.androidplot.ui.AnchorPosition;
import com.androidplot.xy.BoundaryMode;
import com.androidplot.xy.LineAndPointFormatter;
import com.androidplot.xy.LineAndPointRenderer;
import com.androidplot.xy.SimpleXYSeries;
import com.androidplot.xy.XLayoutStyle;
import com.androidplot.xy.XYPlot;
import com.androidplot.xy.YLayoutStyle;


public class OBDReader extends Activity
{
	public boolean stop = true;
	public int val = 0;
	public ConnectedThread ct = ConnectThread.ct;
	public Intent functionIntent;
	public int viewID;
	ArrayList<ObdFunction> cmds = null;
	public SimpleDateFormat s = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
	public String time;
	public String result;
	
	public UpdateThread t1;
	
    private static final int HISTORY_SIZE = 30;            // number of points to plot in history

    private XYPlot gaugePlot = null;
    private SimpleXYSeries historySeries = null;
    private LinkedList<Number> history;

    {
        history = new LinkedList<Number>();
        historySeries = new SimpleXYSeries("RPM");
    }
	
	public EngineRPMFunction rpm = new EngineRPMFunction();
	public AirIntakeTempFunction airtemp = new AirIntakeTempFunction();
	public BatteryVoltageFunction batvoltage = new BatteryVoltageFunction();
	public FuelPressureFunction fuelpressure = new FuelPressureFunction();
	public IntakeManifoldPressureFunction imp = new IntakeManifoldPressureFunction();
	public MassAirFlowFunction maf = new MassAirFlowFunction();
	public SpeedFunction speed = new SpeedFunction();
	public ThrottlePositionFunction throttle = new ThrottlePositionFunction();
	public FuelEconomyFunction fuelecon = new FuelEconomyFunction();
	public CoolantTempFunction coolanttemp = new CoolantTempFunction();
	
	
	public static Gauge gauge;
	
	public boolean log;
	public File fin;
	public FileWriter fw;
	public BufferedWriter out;
	
	private static final String TAG = "DEBUG OF OBDDROID";
	
	public void onCreate(Bundle savedInstanceState) 
	{
	    super.onCreate(savedInstanceState);
	    setContentView(R.layout.obdreader);
	    registerForContextMenu(findViewById(R.id.gauge));
	    
	    
	  // GRAPH STUFF---------------------------------------------
        gaugePlot = (XYPlot) findViewById(R.id.gaugegraph);
        gaugePlot.setRangeBoundaries(0, 8000, BoundaryMode.FIXED);
        gaugePlot.setDomainBoundaries(0, 30, BoundaryMode.FIXED);
        gaugePlot.addSeries(historySeries, LineAndPointRenderer.class, new LineAndPointFormatter(Color.rgb(200, 100, 100), Color.BLACK, null));
        gaugePlot.setDomainStepValue(5);
        gaugePlot.setRangeStepValue(6);
        gaugePlot.getGraphWidget().getRangeLabelPaint().setTextSize(10);
        gaugePlot.getGraphWidget().getDomainLabelPaint().setTextSize(10);
        gaugePlot.setDomainLabel("Time");
        gaugePlot.setRangeLabel("RPM");
        gaugePlot.setTitle("RPM");
        gaugePlot.getDomainLabelWidget().pack();
        gaugePlot.getRangeLabelWidget().pack();
        gaugePlot.disableAllMarkup();
        gaugePlot.getLayoutManager().remove(gaugePlot.getLegendWidget());
        gaugePlot.getLayoutManager().position(gaugePlot.getDomainLabelWidget(), 137, XLayoutStyle.ABSOLUTE_FROM_RIGHT, 0, YLayoutStyle.ABSOLUTE_FROM_BOTTOM, AnchorPosition.BOTTOM_MIDDLE);
	// END GRAPH STUFF------------------------------------------------

	    gauge = (Gauge)findViewById(R.id.gauge);
	    gauge.setGauge("RPM", 6000, 0, 4000, 8000, 500, rpm);
	    gauge.setHandTarget(0);
	    history.removeAll(history);
		try {
			fin = new File("/sdcard/obd/", "rpm.txt");
		    fw = new FileWriter(fin, true);
		    out = new BufferedWriter(fw);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	}

	 @Override
	 public void onCreateContextMenu(ContextMenu menu, View v, ContextMenuInfo menuInfo) 
	 {
	   super.onCreateContextMenu(menu, v, menuInfo);
	   MenuInflater inflater = getMenuInflater();
	   inflater.inflate(R.menu.obdreadercontextmenu, menu);
	   
	   viewID = v.getId(); 
	 }
	 
	 @Override
	 public boolean onContextItemSelected(MenuItem item) 
	 {			   
		   history.removeAll(history);
		   gauge.setHandTarget(0);
		   switch (item.getItemId()) 
		   {
		   case R.id.rpm:
			   gauge.setGauge("RPM", 6000, 0, 4000, 8000, 500, rpm);
			   gaugePlot.setRangeBoundaries(0, 8000 , BoundaryMode.FIXED);
			   gaugePlot.setTitle("RPM");
		       gaugePlot.setRangeLabel("RPM");
		       gaugePlot.redraw();
			   gauge.regenerateBackground();
			   gauge.postInvalidate();
			   try {
			       fin = new File("/sdcard/obd/", "rpm.txt");
			       fw = new FileWriter(fin, true);
			       out = new BufferedWriter(fw);
				   } catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
			   return true;
		   case R.id.airtemp:
			   gauge.setGauge("Air Intake Temp", 75, 0, 60, 120, 5, airtemp);
			   gaugePlot.setRangeBoundaries(0, 120, BoundaryMode.FIXED);
			   gaugePlot.setTitle("Air Intake Temp");
		       gaugePlot.setRangeLabel("Temperature");
		       gaugePlot.redraw();
			   gauge.regenerateBackground();
			   gauge.postInvalidate();
			   try {
				   fin = new File("/sdcard/obd/", "airintaketemp.txt");
				   fw = new FileWriter(fin, true);
				   out = new BufferedWriter(fw);
			   		} catch (IOException e) {
			   			// TODO Auto-generated catch block
			   			e.printStackTrace();
			   		}
			     return true;
		   case R.id.batvoltage:
			   gauge.setGauge("Battery Voltage", 36, 0, 12, 24, 2, batvoltage);
			   gaugePlot.setRangeBoundaries(0, 24, BoundaryMode.FIXED);
			   gaugePlot.setTitle("Battery Voltage");
		       gaugePlot.setRangeLabel("Voltage");
		       gaugePlot.redraw();
			   gauge.regenerateBackground();
			   gauge.postInvalidate();
			   try {
			       fin = new File("/sdcard/obd/", "batteryvoltage.txt");
			       fw = new FileWriter(fin, true);
			       out = new BufferedWriter(fw);
				   } catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
			     return true;
		   case R.id.fuelpressure:
			   gauge.setGauge("Fuel Pressure", 300, 0, 300, 600, 50, fuelpressure);
			   gaugePlot.setRangeBoundaries(0, 600, BoundaryMode.FIXED);
			   gaugePlot.setTitle("Fuel Pressure");
		       gaugePlot.setRangeLabel("Pressure");
		       gaugePlot.redraw();
			   gauge.regenerateBackground();
			   gauge.postInvalidate();
			   try {
			       fin = new File("/sdcard/obd/", "fuelpressure.txt");
			       fw = new FileWriter(fin, true);
			       out = new BufferedWriter(fw);
				   } catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
			     return true;
		   case R.id.imp:
			   gauge.setGauge("Intake Manifold Pressure", 50, 0, 50, 100, 5, imp);
			   gaugePlot.setRangeBoundaries(0, 100, BoundaryMode.FIXED);
			   gaugePlot.setTitle("Intake Manifold Prsesure");
		       gaugePlot.setRangeLabel("Pressure");
		       gaugePlot.redraw();
			   gauge.regenerateBackground();
			   gauge.postInvalidate();  
			   try {
			       fin = new File("/sdcard/obd/", "intakemanifoldpressure.txt");
			       fw = new FileWriter(fin, true);
			       out = new BufferedWriter(fw);
				   } catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
			     return true;
		   case R.id.maf:
			   gauge.setGauge("Mass Air Flow", 350, 0, 350, 700, 50, maf);
			   gaugePlot.setRangeBoundaries(0, 700, BoundaryMode.FIXED);
			   gaugePlot.setTitle("Mass Air Flow");
		       gaugePlot.setRangeLabel("Flow");
		       gaugePlot.redraw();
			   gauge.regenerateBackground();
			   gauge.postInvalidate();
			   try {
			       fin = new File("/sdcard/obd/", "massairflow.txt");
			       fw = new FileWriter(fin, true);
			       out = new BufferedWriter(fw);
				   } catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
			     return true;
		   case R.id.speed:
			   gauge.setGauge("Speed", 100, 0, 100, 200, 10, speed);
			   gaugePlot.setRangeBoundaries(0, 200, BoundaryMode.FIXED);
			   gaugePlot.setTitle("Speed");
		       gaugePlot.setRangeLabel("Speed");
		       gaugePlot.redraw();
			   gauge.regenerateBackground();
			   gauge.postInvalidate();
			   try {
			       fin = new File("/sdcard/obd/", "speed.txt");
			       fw = new FileWriter(fin, true);
			       out = new BufferedWriter(fw);
				   } catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
			     return true;
		   case R.id.throttle:
			   gauge.setGauge("Throttle Position", 50, 0, 50, 100, 5, throttle);
			   gaugePlot.setRangeBoundaries(0, 100, BoundaryMode.FIXED);
			   gaugePlot.setTitle("Throttle Position");
		       gaugePlot.setRangeLabel("Percent");
		       gaugePlot.redraw();
			   gauge.regenerateBackground();
			   gauge.postInvalidate();
			   
			   try {
			       fin = new File("/sdcard/obd/", "throttleposition.txt");
			       fw = new FileWriter(fin, true);
			       out = new BufferedWriter(fw);
				   } catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
		   		 return true;
		   case R.id.coolanttemp:
			   gauge.setGauge("Coolant Temperature",  100, 0, 100, 200, 10, coolanttemp);
			   gaugePlot.setRangeBoundaries(0, 200, BoundaryMode.FIXED);
			   gaugePlot.setTitle("Coolant Temperature");
		       gaugePlot.setRangeLabel("Temperature");
		       gaugePlot.redraw();
			   gauge.regenerateBackground();
			   gauge.postInvalidate();
			   try {
			       fin = new File("/sdcard/obd/", "coolanttemp.txt");
			       fw = new FileWriter(fin, true);
			       out = new BufferedWriter(fw);
				   } catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
		   		 return true;
		   case R.id.fuelecon:
			   gauge.setGauge("Fuel Economy", 50, 0, 40, 80, 5, fuelecon);
			   gaugePlot.setRangeBoundaries(0, 80, BoundaryMode.FIXED);
			   historySeries = new SimpleXYSeries("Fuel Economy");
			   gaugePlot.setTitle("Fuel Economy");
		       gaugePlot.setRangeLabel("MPG");
		       gaugePlot.redraw();
			   gauge.regenerateBackground();
			   gauge.postInvalidate();
			   try {
			       fin = new File("/sdcard/obd/", "fueleconomy.txt");
			       fw = new FileWriter(fin, true);
			       out = new BufferedWriter(fw);
				   } catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
		   		 return true;
		   default:
		     return super.onContextItemSelected(item);
		   }
	}
	 
	 public boolean onCreateOptionsMenu(Menu menu) 
	 {
		menu.add(0, 1, 0, "Start");
		menu.add(0, 4, 0, "Stop");
	    menu.add(1, 2, 0, "Run Function");
	    menu.add(1, 5, 0, "Run Custom");
	    menu.add(1, 3, 0, "Live Data");
        return true;
	  }
	 
	   public boolean onOptionsItemSelected(MenuItem item) 
	   {
	        switch (item.getItemId()) 
	        {
		        case 1:
		        	stop = false;
		        	t1 = new UpdateThread(gauge);
		        	t1.start();
		        	
		        	return true;
		        case 2:
		        	functionIntent = new Intent(this, org.obddroid.activity.RunFunction.class);
		        	startActivity(functionIntent);
		            return true;
		        case 3:
		        	functionIntent = new Intent(this, LiveData.class);
		        	startActivity(functionIntent);
		        	return true;
		        case 4:
		        	stop = true;
		        	return true;
		        case 5:
		        	functionIntent = new Intent(this, CustomFunc.class);
		        	startActivity(functionIntent);
		     }
	        return false;
	    }
	   
	 
	 public class UpdateThread extends Thread
	 {
		 /* (non-Javadoc)
		 * @see java.lang.Thread#run()
		 */
		public Gauge g;
		
		public UpdateThread(Gauge gauge)
		{
			g = gauge;
		}
		public void run()
		 {	  
			 while(!stop)
			 { 
				 try 
				 {
					ObdFunction g1 = g.getFunc();
					g1 = ct.runCommand(g1);
					
					String[] ans = g1.formatResult().split(" ");
					
					if(ans[0].endsWith("v")||ans[0].endsWith("V"))
					{
						ans[0] = ans[0].substring(0,ans[0].length()-1);
					}
					
					float val = Float.parseFloat(ans[0]);
					g.setHandTarget(val);
					
					// Drawing graph
			        if (history.size() > HISTORY_SIZE) 
			        {
			            history.removeFirst();           
			        }
			        history.addLast(val);
			        historySeries.setModel(history, SimpleXYSeries.ArrayFormat.Y_VALS_ONLY);
			        gaugePlot.postRedraw();
					
			        //logging data
			        time = s.format(new Date());
			        result = time + " " + ans[0];
			        try 
			        {
						out.append(result);
						out.newLine();
					} catch (IOException e) 
					{
						// TODO Auto-generated catch block
						e.printStackTrace();	
			        }
			        
					//sleep(300);
					
				} catch (InterruptedException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				} catch(StringIndexOutOfBoundsException e){
					
				} catch(IndexOutOfBoundsException e){
					
				} catch(NumberFormatException e){
					
				} catch(NullPointerException e){}
			 }
			 try {
				out.close();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		 }
	 }    
}
