package org.obddroid.ui;

import java.io.File;
import java.io.IOException;
import java.util.Set;

import org.obddroid.connect.ConnectService;
import org.obddroid.connect.ConnectServiceConnection;
import org.obddroid.connect.ConnectThread;

import android.app.ListActivity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ArrayAdapter;
import android.widget.ListView;

public class OBDUI extends ListActivity 
{
	
	int REQUEST_ENABLE_BT = 1;
	String[] OPTIONS = new String[] {
	    "Start Connection", "OBD II Reader", "Keypad", "Logs", "Error Codes"};
	
	private Intent newActivity;
	private Handler handler = null;
	private Intent serviceIntent = null;
	private final BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
	private BluetoothDevice dev;
	public static ConnectService service = null;
	public ConnectServiceConnection serviceConn = null;
	private ConnectThread temp = null;
	
	private static final String TAG = "DEBUG OF OBDDROID";
	
    /** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) 
	{
	  super.onCreate(savedInstanceState);
	  File[] fin = new File[11];

	  File dir = new File("/sdcard/obd/");
	  //if (!dir.isDirectory())
	  
	  dir.mkdirs();
	  
	  fin[0] = new File("/sdcard/obd/airintaketemp.txt");
	  fin[1] = new File("/sdcard/obd/batteryvoltage.txt");
	  fin[2] = new File("/sdcard/obd/coolanttemp.txt");
	  fin[3] = new File("/sdcard/obd/engineload.txt");
	  fin[4] = new File("/sdcard/obd/fueleconomy.txt");
	  fin[5] = new File("/sdcard/obd/fuelpressure.txt");
	  fin[6] = new File("/sdcard/obd/intakemanifoldpressure.txt");
	  fin[7] = new File("/sdcard/obd/massairflow.txt");
	  fin[8] = new File("/sdcard/obd/speed.txt");
	  fin[9] = new File("/sdcard/obd/throttleposition.txt");
	  fin[10] = new File("/sdcard/obd/rpm.txt");

	  for (int i = 0; i < 11; i++)
	  {
		  if (!fin[i].exists())
		  {
			 try {
				fin[i].createNewFile();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} 
		  }
	  }

	  setListAdapter(new ArrayAdapter<String>(this, R.layout.mainmenu, OPTIONS));

	  ListView lv = getListView();
	  lv.setTextFilterEnabled(true);
	  
	  
	  if (!mBluetoothAdapter.isEnabled()) 
	  {
		Intent enableBtIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
		startActivityForResult(enableBtIntent, REQUEST_ENABLE_BT);			    			
	  }
  			
	  String devString = "NULL";
	  Set<BluetoothDevice> pairedDevices = mBluetoothAdapter.getBondedDevices();
		
	  //Find paired Device OBDII
	  for(BluetoothDevice device: pairedDevices)
	  {
//		  if(device.getName().equals("FireFly-C03C"))			//change this for bluetooth
//		  {
//				devString = device.getAddress();
//		  }
//		  if(device.getName().equals("MATTHEW-PC"))			//change this for bluetooth
//		  {
//				devString = device.getAddress();
//		  }
		  if(device.getName().equals("OBDII"))			//change this for bluetooth
		  {
				devString = device.getAddress();
		  }
	  }

	  handler = new Handler();
	  dev = mBluetoothAdapter.getRemoteDevice(devString);
	  
	  temp = new ConnectThread(dev, this);							//start connect thread
	  
	  serviceIntent = new Intent(this, ConnectService.class);
	  serviceConn = new ConnectServiceConnection();
      //bindService(serviceIntent, serviceConn, Context.BIND_AUTO_CREATE);
      //service = serviceConn.getService();

	  lv.setOnItemClickListener(new OnItemClickListener() 
	  {
	    public void onItemClick(AdapterView<?> parent, View view, int position, long id)
	    {
	    	switch(position)
	    	{
		    	case 0:	Log.d(TAG, "service started");
						temp.start();
						break;		
		    	case 1: newActivity = new Intent(OBDUI.this, OBDReader.class);
		    			startActivity(newActivity);
		 				break;
		    	case 2: newActivity = new Intent(OBDUI.this, Keypad.class);
		 				startActivity(newActivity);
		 				break;
		    	case 3: newActivity = new Intent(OBDUI.this, LogSelect.class);
		 				startActivity(newActivity);
		 				break;
		    	case 4: try
		    			{
			    			newActivity = new Intent(OBDUI.this, ErrorCode.class);
			 				startActivity(newActivity);
		    			}catch(ArrayIndexOutOfBoundsException e){
		    				
		    			}catch(StringIndexOutOfBoundsException e){}
		 				break;
	    	}
	    }
	    	
	  }
	  );
	}
	
	public void msg(CharSequence tickerText, CharSequence contentTitle, CharSequence contentText)
	{
		String ns = Context.NOTIFICATION_SERVICE;
		NotificationManager mNotificationManager = (NotificationManager) getSystemService(ns);
		
		int icon = android.R.drawable.stat_notify_sync;
		long when = System.currentTimeMillis();
		
		Notification notification = new Notification(icon, tickerText, when);
		
		Context context = getApplicationContext();
		Intent notificationIntent = new Intent(this, OBDUI.class);
		PendingIntent contentIntent = PendingIntent.getActivity(this, 0, notificationIntent, 0);
		
		notification.setLatestEventInfo(context, contentTitle, contentText, contentIntent);
		mNotificationManager.notify(1, notification);
	}
}