﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing.Imaging;
using System.Drawing;
using System.Runtime.InteropServices;

namespace RADSAT
{
    partial class MainRadsat
    {
        /// <summary>
        /// Changes the bitmap image to black and white
        /// Black - represents a pixel which did not match the selected color
        /// White - represents a pixel which did match the selected
        /// </summary>
        /// <param name="bmp"></param>
        private static void ChangePixels(Bitmap bmp)
        {
            // Specify a pixel format.
            PixelFormat pxf = PixelFormat.Format24bppRgb;
            // Lock the bitmap's bits.
            Rectangle rect = new Rectangle(0, 0, bmp.Width, bmp.Height);
            BitmapData bmpData =
            bmp.LockBits(rect, ImageLockMode.ReadWrite, pxf);

            // Get the address of the first line.
            IntPtr ptr = bmpData.Scan0;

            // Declare an array to hold the bytes of the bitmap.
            int numBytes = bmp.Width * bmp.Height * 3;
            byte[] rgbValues = new byte[numBytes];

            // Copy the RGB values into the array.
            Marshal.Copy(ptr, rgbValues, 0, numBytes);

            // Manipulate the bitmap, such as changing the
            // blue value for every other pixel in the the bitmap.
            Boolean grayScale = formimage.RobotVisionbool;
            int threshold = formimage.Threshold;

            //checks HSV values as well as RGB.  This option will give extra results but will run and roughly 50% speed
            if (formimage.Contrastbool)
            {
                Color needsToBeColor = Color.FromArgb(formimage.Red, formimage.Blue, formimage.Green);
                float needsToBeColorHue = needsToBeColor.GetHue();
                float needsToBeColorSaturation = needsToBeColor.GetSaturation();
                float needsToBeColorValue = needsToBeColor.GetBrightness();
                for (int counter = 2; counter < rgbValues.Length; counter += 3)
                {
                    double colorValue = DetermineColor(rgbValues[counter], rgbValues[counter - 1], rgbValues[counter - 2]);
                    Color pixelColor = Color.FromArgb(rgbValues[counter], rgbValues[counter - 1], rgbValues[counter - 2]);

                    float pixelColorHue = pixelColor.GetHue();
                    float pixelColorSaturation = pixelColor.GetSaturation();
                    float pixelColorValue = pixelColor.GetBrightness();

                    //Checks if the HSV values of the pixel are close to the desired HSV values
                    float colorResultHue = pixelColorHue - needsToBeColorHue;
                    if (colorResultHue < 0) colorResultHue *= (-1);

                    float colorResultSaturation = pixelColorSaturation - needsToBeColorSaturation;
                    if (colorResultSaturation < 0) colorResultSaturation *= (-1);

                    float colorResultValue = pixelColorValue - needsToBeColorValue;
                    if (colorResultValue < 0) colorResultValue *= (-1);

                    //retrieves HSV threshold data from the GUI
                    int Hthreshold = formimage.Hthreshold;
                    int Sthreshold = formimage.Sthreshold;
                    int Vthreshold = formimage.Vthreshold;

                    if (colorResultHue < Hthreshold && colorResultSaturation < Sthreshold
                        && colorResultValue < Vthreshold && colorValue > threshold)
                    {
                        //sets the Pixel to black
                        rgbValues[counter] = (byte)0; // R
                        rgbValues[counter - 1] = (byte)0; // G
                        rgbValues[counter - 2] = (byte)0; // B
                    }
                }
            }
            else
            {
                for (int counter = 2; counter < rgbValues.Length; counter += 3)
                {
                    double colorValue = DetermineColor(rgbValues[counter], rgbValues[counter - 1], rgbValues[counter - 2]);

                    if (colorValue > threshold)
                    {
                        rgbValues[counter] = (byte)0; // R
                        rgbValues[counter - 1] = (byte)0; // G
                        rgbValues[counter - 2] = (byte)0; // B
                    }
                }
            }
            // Copy the RGB values back to the bitmap
            Marshal.Copy(rgbValues, 0, ptr, numBytes);

            // Unlock the bits.
            bmp.UnlockBits(bmpData);
        }
        //Checks to see how close the pixel is to the desired color
        public static double DetermineColor(int R, int G, int B)
        {
            int red = formimage.Red;
            int green = formimage.Green;
            int blue = formimage.Blue;
            double D = Math.Sqrt((R - red) * (R - red) + (G - green) * (G - green) + (B - blue) * (B - blue));
            return D;
        }
        //not in use but converts a pixel to Grayscale
        public static byte GrayScale(int R, int G, int B)
        {
            int K = (R + B + G) / 3;
            byte N = (byte)K;
            return N;
        }
    }
}
