﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Timers;
using System.Threading;
using System.Net.Sockets;
using System.Net;

namespace RADSAT
{
    public partial class GUI : Form
    {
        public GUI()
        {
            InitializeComponent();
        }

        //Updates the picturebox image
        public System.Windows.Forms.PictureBox BitImage
        {
            get { return bitImage; }
            set { bitImage = value; }
        }
        //Changes RadioButton Selection
        public System.Windows.Forms.RadioButton Target1
        {
            get { return target1; }
            set { target1 = value; }
        }
        public System.Windows.Forms.RadioButton Target2
        {
            get { return target2; }
            set { target1 = value; }
        }
        public System.Windows.Forms.RadioButton Target3
        {
            get { return target3; }
            set { target1 = value; }
        }

        //Adds text to Robot Feedback
        delegate void SetTextCallback(string text);
        public void SetText(string text)
        {
            if (this.robotFeedback.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(SetText);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                this.robotFeedback.Text = text + "\n" + this.robotFeedback.Text;
            }
        }

        //Set FPS
        public void SetFPS(string text)
        {
            if (this.FPS.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(SetFPS);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                this.FPS.Text = text;
            }
        }

        //For Robot Vision
        private Boolean robotVisionbool = false;
        public Boolean RobotVisionbool
        {
            get { return robotVisionbool; }
        }
        private void robotVision_CheckedChanged(object sender, EventArgs e)
        {
            robotVisionbool = !robotVisionbool;
            if (robotVisionbool)
                this.SetText("Robot Vision ON!");
            else
                this.SetText("Robot Vision OFF!");
        }

        //For Contrast
        private Boolean contrastbool = false;
        public Boolean Contrastbool
        {
            get { return contrastbool; }
        }
        private void contrast_CheckedChanged(object sender, EventArgs e)
        {
            contrastbool = !contrastbool;
            if (contrastbool)
                this.SetText("HSV ON!");
            else
                this.SetText("HSV OFF!");
        }

        //For Autonomous
        private Boolean autonomousbool = false;
        public Boolean Autonomousbool
        {
            get { return autonomousbool; }
        }
        private void autonomous_CheckedChanged(object sender, EventArgs e)
        {
            autonomousbool = !autonomousbool;
            if (autonomousbool)
            {
                this.SetText("Autonomous ON!");
                movement.Auto();
            }
            else
            {
                this.SetText("Autonomous OFF!");
                movement.Stop();
            }
        }

        //returns RGB values
        private int red = 0;
        public int Red
        {
            get { return red; }
        }

        private int green = 0;
        public int Green
        {
            get { return green; }
        }

        private int blue = 0;
        public int Blue
        {
            get { return blue; }
        }

        //For Clicked Target
        private int clickRed = 0;
        private int clickGreen = 0;
        private int clickBlue = 0;
        private void clickTarget_CheckedChanged(object sender, EventArgs e)
        {
            red = clickRed;
            green = clickGreen;
            blue = clickBlue;
            this.SetText("Click Target, R = " + red + ", G = " + green + ", B = " + blue);
            if(this.Autonomousbool) movement.Auto();
        }
        private void bitImage_MouseClick(object sender, MouseEventArgs e)
        {
            Color clickColor = (bitImage.Image as Bitmap).GetPixel(e.X, e.Y);
            clickRed = clickColor.R;
            clickGreen = clickColor.G;
            clickBlue = clickColor.B;
            this.SetText("Click Target Values: R = " + clickRed + ", G = " + clickBlue + ", B = " + clickBlue);
            
        }

        //For Target 1
        private void target1_CheckedChanged(object sender, EventArgs e)
        {
            red = Convert.ToInt32(this.r1.Value);
            green = Convert.ToInt32(this.g1.Value);
            blue = Convert.ToInt32(this.b1.Value);
            this.SetText("Target 1, R = " + red + ", G = " + green + ", B = " + blue);
            if (this.Autonomousbool) movement.Auto();
        }

        //For Target 2
        private void target2_CheckedChanged(object sender, EventArgs e)
        {
            red = Convert.ToInt32(this.r2.Value);
            green = Convert.ToInt32(this.g2.Value);
            blue = Convert.ToInt32(this.b2.Value);
            this.SetText("Target 2, R = " + red + ", G = " + green + ", B = " + blue);
            if (this.Autonomousbool) movement.Auto();
        }

        //For Target 3
        private void target3_CheckedChanged(object sender, EventArgs e)
        {
            red = Convert.ToInt32(this.r3.Value);
            green = Convert.ToInt32(this.g3.Value);
            blue = Convert.ToInt32(this.b3.Value);
            this.SetText("Target 3, R = " + red + ", G = " + green + ", B = " + blue);
            if (this.Autonomousbool) movement.Auto();
        }

        //Get the threshold
        private int threshold = 30;
        public int Threshold
        {
            get { return threshold; }
        }
        private void threshnum_ValueChanged(object sender, EventArgs e)
        {
            threshold = Convert.ToInt32(this.threshnum.Value);
            this.SetText("Threshold set to: " + threshold);
        }

        //HSV Thresholds
        private int hthreshold = 250;
        public int Hthreshold
        {
            get { return hthreshold; }
        }
        private void HT_ValueChanged(object sender, EventArgs e)
        {
            this.hthreshold = Convert.ToInt32(this.HT.Value);
            this.SetText("H Threshold set to: " + hthreshold);
        }
        private int sthreshold = 100;
        public int Sthreshold
        {
            get { return sthreshold; }
        }
        private void ST_ValueChanged(object sender, EventArgs e)
        {
            this.hthreshold = Convert.ToInt32(this.ST.Value);
            this.SetText("S Threshold set to: " + sthreshold);
        }
        private int vthreshold = 100;
        public int Vthreshold
        {
            get { return vthreshold; }
        }
        private void VT_ValueChanged(object sender, EventArgs e)
        {
            this.vthreshold = Convert.ToInt32(this.VT.Value);
            this.SetText("V Threshold set to: " + vthreshold);
        }

        private static MainRadsat.RobotMotion movement = new MainRadsat.RobotMotion();

        private void x_Click(object sender, EventArgs e)
        {
            movement.MoveBackward();
        }

        //Movement Commands
        private static System.Timers.Timer stopSend;
        private void SendStop()
        {
            if (!autonomousbool)
            {
                stopSend = new System.Timers.Timer();
                stopSend.Elapsed += new ElapsedEventHandler(SendDelay);
                stopSend.Interval = 50;
                stopSend.Enabled = true;
            }
        }
        private void SendStopIgnoreBool()
        {
            stopSend = new System.Timers.Timer();
            stopSend.Elapsed += new ElapsedEventHandler(SendDelay);
            stopSend.Interval = 500;
            stopSend.Enabled = true;
        }
        private static void SendDelay(object source, ElapsedEventArgs e)
        {
            stopSend.Stop();
            movement.Stop();
        }
        private void DisabledPrint()
        {
            this.SetText("This button is disabled.");
        }
        private void Go_MouseDown(object sender, MouseEventArgs e)
        {
            if(!autonomousbool)
                movement.MoveForward();
            else
                DisabledPrint();
        }

        private void Go_MouseUp(object sender, MouseEventArgs e)
        {
            SendStop();
        }
        private void Back_MouseDown(object sender, MouseEventArgs e)
        {
            if (!autonomousbool)
            {
                movement.MoveBackward();
            }
            else
                DisabledPrint();
        }

        private void Back_MouseUp(object sender, MouseEventArgs e)
        {
            SendStop();
        }
        private void Left_MouseDown(object sender, MouseEventArgs e)
        {
            if (!autonomousbool)
                movement.MoveLeft();
            else
                DisabledPrint();
        }
        private void Left_MouseUp(object sender, MouseEventArgs e)
        {
            SendStop();
        }
        private void Right_MouseDown(object sender, MouseEventArgs e)
        {
            if (!autonomousbool)
                movement.MoveRight();
            else
                DisabledPrint();
        }
        private void Right_MouseUp(object sender, MouseEventArgs e)
        {
            SendStop();
        }
        private void Tup_MouseDown(object sender, MouseEventArgs e)
        {
            if (!autonomousbool)
                movement.TurretUp();
            else
                DisabledPrint();
        }
        private void Tup_MouseUp(object sender, MouseEventArgs e)
        {
            SendStop();
        }
        private void Tleft_MouseDown(object sender, MouseEventArgs e)
        {
            if (!autonomousbool)
                movement.TurretLeft();
            else
                DisabledPrint();
        }
        private void Tleft_MouseUp(object sender, MouseEventArgs e)
        {
            SendStop();
        }
        private void Tright_MouseDown(object sender, MouseEventArgs e)
        {
            if (!autonomousbool)
                movement.TurretRight();
            else
                DisabledPrint();
        }
        private void Tright_MouseUp(object sender, MouseEventArgs e)
        {
            SendStop();
        }
        private void Tdown_MouseDown(object sender, MouseEventArgs e)
        {
            if (!autonomousbool)
                movement.TurretDown();
            else
                DisabledPrint();
        }
        private void Tdown_MouseUp(object sender, MouseEventArgs e)
        {
            SendStop();
        }
        private void Fire_MouseDown(object sender, MouseEventArgs e)
        {
            movement.Fire();
        }
        private void Fire_MouseUp(object sender, MouseEventArgs e)
        {
            SendStopIgnoreBool();
        }
        private void Stop_Click(object sender, EventArgs e)
        {
            movement.Stop();
        }

        //Resets the phone server
        private Boolean pserverbool = false;
        public Boolean Pserverbool
        {
            set { pserverbool = value; }
            get { return pserverbool; }
        }
        private void PServerButton_Click(object sender, EventArgs e)
        {
            Pserverbool = true;
        }
    }
}
