﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using AForge.Video;
using System.Threading;
using System.Drawing;
using System.Windows.Forms;
using System.Timers;

namespace RADSAT
{
    partial class MainRadsat
    {
        //The object creation for the GUi
        static GUI formimage = new GUI();
        //Count which keeps track of FPS
        static int count = 0;
        static WifiBeeServer wifibee = new WifiBeeServer();

        static void Main(string[] args)
        {
            //Retrieve the MJPEG stream
            MJPEGStream stream = new MJPEGStream("http://192.168.1.178/videostream.cgi?user=RADSATeye&pwd=radical");
            // set event handlers
            stream.NewFrame += new NewFrameEventHandler(video_NewFrame);
            // start the video source
            stream.Start();

            //Start the GUI
            RunApp GUIApp = new RunApp();
            Thread applicationThread = new Thread(new ThreadStart(GUIApp.runIt));
            applicationThread.Start();

            //Calculate the FPS
            new MainRadsat.FPSTimerThread();

            //Start the phone server
            PhoneServer serverGo = new PhoneServer();
            Thread serverThread = new Thread(new ThreadStart(serverGo.phoneServerStart));
            serverThread.Start();

            //Start the Wifi Bee Server
            Thread wifiThread = new Thread(new ThreadStart(wifibee.wifiBeeServerStart));
            wifiThread.Start();
        }

        public class RunApp
        {
            public void runIt()
            {
                Application.Run(formimage);
            }
        }
    }
}