﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.Net.Sockets;

namespace RADSAT
{
    partial class MainRadsat
    {
        /// <summary>
        /// The server which is used for communication between the phone and computer
        /// </summary>
        public class PhoneServer
        {
            public void phoneServerStart()
            {
                PServer();
            }
            static TcpListener myList;
            static Socket s;

            public static void PServer()
            {
            try 
            {
                formimage.Pserverbool = false;
                IPAddress ipAd = IPAddress.Parse("192.168.1.2");

                //Initializes the Listener 
                myList=new TcpListener(ipAd,1000);

                //Start Listeneting at the specified port         
                myList.Start();

                //Pauses here until a connection is established
                formimage.SetText("Waiting for a phone connection.....");
        
                s=myList.AcceptSocket();

                formimage.SetText("Connection accepted from " + s.RemoteEndPoint);

                //Will continuously loop looking for commands from the phone
                while (true)
                {
                    try
                    {
                        if (!s.Connected)
                        {
                            if (formimage.Pserverbool) break;
                        }
                        formimage.Pserverbool = false;
                        byte[] b = new byte[100];
                        int k = 0;
                        s.ReceiveTimeout = 1000;
                        k = s.Receive(b);
                        char[] c = new char[k];
                        for (int i = 0; i < k; i++)
                            c[i] = Convert.ToChar(b[i]);
                        String receivedText = new String(c);

                        InterpretCommand(receivedText);                        
                    }
                    catch
                    {
                        continue;
                    }
                }

                s.Close();
                myList.Stop();
                PServer();
            }
            catch (Exception e) 
            {
                formimage.SetText("Error..... " + e.StackTrace);
            }    
         }
        }

        /// <summary>
        /// Tries to understand the command sent by the phone
        /// </summary>
        /// <param name="command"></param>
        public static void InterpretCommand(String command)
        {
            MainRadsat.RobotMotion movement = new MainRadsat.RobotMotion();
            
            if (command.Contains("stop"))
            {
                new MainRadsat.RobotMotion().Stop();
                CommandReceived(command);
            }
            else if (command.Contains("fire"))
            {
                new MainRadsat.RobotMotion().Fire();
                CommandReceived(command);
            }
            else
            {
                if (command.Length > 0)
                    formimage.SetText("Received Invalid Voice Command: " + command);
            }
        }
        private static void CommandReceived(String command)
        {
            formimage.SetText("Received Voice Command: " + command);
        }
    }
}