﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.Threading;
using System.Timers;

namespace RADSAT
{
    partial class MainRadsat
    {
        /// <summary>
        /// Sends all the commands to the RADSAT
        /// </summary>
        public class RobotMotion
        {
            private static String command = "";

            public void MoveForward()
            {
                command = "up";
                //StartMessageThread();
                WifiSend("7");
            }
            public void MoveBackward()
            {
                command = "down";
                //StartMessageThread();
                WifiSend("8");
            }
            public void MoveLeft()
            {
                command = "left";
                //StartMessageThread();
                WifiSend("9");
            }
            public void MoveRight()
            {
                command = "right";
                //StartMessageThread();
                WifiSend("A");
            }
            public void TurretUp()
            {
                command = "tup"; //tup
                //StartMessageThread();
                WifiSend("0");
            }
            public void TurretDown()
            {
                command = "tdown"; //tdown
                //StartMessageThread();
                WifiSend("1");
            }
            public void TurretLeft()
            {
                command = "tleft"; //tleft
                //StartMessageThread();
                WifiSend("2");
            }
            public void TurretRight()
            {
                command = "tright"; //tright
                //StartMessageThread();
                WifiSend("3");
            }
            public void Fire()
            {
                command = "fire"; //fire
                //StartMessageThread();
                WifiSend("4");
            }
            public void Stop()
            {
                command = "stop"; //stop
                //StartMessageThread();
                WifiSend("5");
            }
            public void Auto()
            {
                command = "auto"; //auto
                //StartMessageThread();
                WifiSend("6");
            }

            private static void WifiSend(String message)
            {
                wifibee.WifiBeeWrite(message);
                formimage.SetText("Sent command: " + command);
            }

            //Creates a new thread for each command to reduce lag and allow the rest of the 
            //program to continue in the event of an error
            private static void StartMessageThread()
            {
                SendMessage sendMessage = new SendMessage();
                Thread motionThread = new Thread(new ThreadStart(SendMessage.WithinSendMessage));
                motionThread.Start();
            }
            public class SendMessage
            {
                private static System.Timers.Timer stopRetry;

                public static void WithinSendMessage()
                {
                    try
                    {
                        WebRequest RADSATserver = WebRequest.Create("http://192.168.1.100/" + command);
                        RADSATserver.Timeout = 1000;
                        RADSATserver.GetResponse();
                        formimage.SetText("\"" + command + "\"" + " command sent successfully.");
                    }
                    catch
                    {
                        formimage.SetText("\"" + command + "\"" + " command was unable to send.");
                    }
                }
                //Not in use but will continuously try to send the "stop" command in the event of
                //a failure
                private static void StopRetry(object source, ElapsedEventArgs e)
                {
                    try
                    {
                        Console.WriteLine("StopRetry");
                        WebRequest RADSATserver = WebRequest.Create("http://192.168.1.100/" + command);
                        RADSATserver.Timeout = 1000;
                        RADSATserver.GetResponse();
                        formimage.SetText("\"" + command + "\"" + " command sent successfully.");
                        stopRetry.Enabled = false;
                    }
                    catch
                    { 
                    }
                }
            }
        }
    }
}
