﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using AForge.Imaging;
using System.Drawing;
using AForge.Imaging.Filters;
using System.Drawing.Imaging;
using System.Runtime.InteropServices;
using AForge;

namespace RADSAT
{
    partial class MainRadsat
    {
        /// <summary>
        /// Uses AForge.net video library to recognize blobs within the black and white version of the 
        /// camera's vision.  It finds and sets the target and creates a centerpoint to be given to 
        /// DrawCrosshairs()
        /// </summary>
        /// <param name="bmp"></param>
        private static void ShapeRecognition(Bitmap bmp)
        {
            Bitmap image = bmp;
            BlobCounter bc = new BlobCounter(bmp);
            // specify sort order
            bc.ObjectsOrder = ObjectsOrder.Size;
            Blob[] blobs = bc.GetObjects(bmp, false);
            // process blobs
            foreach (Blob blob in blobs)
            {
                //Determines a blob based on color changing
                Rectangle rct = blob.Rectangle;
                //top left point of the rectangle
                System.Drawing.Point topLeftrect = rct.Location;
                int rectX = topLeftrect.X;
                int rectY = topLeftrect.Y;

                //Center of the blob
                AForge.Point cog = blob.CenterOfGravity;
                int cogx = (int)cog.X;
                int cogy = (int)cog.Y;

                //Determines what percentage of the blob is matching pixels
                double fullness = blob.Fullness;

                //Determines the difference between the blob's height and width
                //if the rectangle is not withing a certain number of pixels to 
                //determine a square than it will be rejected
                int lengthheight = rct.Height - rct.Width;
                if (lengthheight < 0) lengthheight *= -1;

                //within here the target is found
                //The blob must be within 10 pixels of a square, the length and width must both
                //be over 50, and the blob must contain at least 75% matching pixels
                if (lengthheight < 10 && rct.Height > 50 && rct.Width > 50 && fullness > .65)
                {
                    //Sets the dynamic crosshair to the center of the target
                    dynamicCrosshairX = cogx;
                    dynamicCrosshairY = cogy;
                    //sends commands accordingly
                    if(formimage.Autonomousbool) FindTarget();
                }

                int nY = rectY + rct.Height;
                int nX = rectX + rct.Width;
                //Shows the rectangles for Robot Vision
                for (int i = 0; i < rct.Width; i++)
                {
                    image.SetPixel(rectX + i, rectY, Color.Pink);
                    if(nY < 480) image.SetPixel(rectX + i, nY, Color.Pink);
                }
                for (int j = 0; j < rct.Height; j++)
                {
                    image.SetPixel(rectX, rectY+j, Color.Pink);
                    if(nX < 640) image.SetPixel(nX, rectY + j, Color.Pink);
                }
            }
        }
    }
}