﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Timers;

namespace RADSAT
{
    partial class MainRadsat
    {
        //X value for dynamic crosshair
        static int dynamicCrosshairX = -1;
        //Y value for dynamic crosshair
        static int dynamicCrosshairY = -1;
        //X value for static crosshair
        static int staticCrosshairX = 335;
        //Y value for static crosshair
        static int staticCrosshairY = 360;
        //Determines if the RADSAT is alligned horizontally with the target
        static Boolean horizontalAligned = false;
        //Determines if the RADSAT is alligned vertically with the target
        static Boolean verticalAligned = false;
        //Determines if the RADSAT is currently giving a command
        static Boolean givingCommand = false;
        static int previousDCrosshairX = 0;

        static MainRadsat.RobotMotion movement = new MainRadsat.RobotMotion();
        
        /// <summary>
        /// Draws the Crosshairs on the bitmap image.
        /// Static - where the RADSAT is aiming
        /// Dynamic - the center of the target
        /// </summary>
        /// <param name="bmp"></param>
        public static void DrawCrosshairs(Bitmap bmp)
        {
            for (int i = 0; i < 15; i++)
            {
                if(dynamicCrosshairX+i < 480 && dynamicCrosshairX != -1) bmp.SetPixel(dynamicCrosshairX + i, dynamicCrosshairY, Color.LimeGreen);
                if (dynamicCrosshairX - i > 0 && dynamicCrosshairX != -1) bmp.SetPixel(dynamicCrosshairX - i, dynamicCrosshairY, Color.LimeGreen);
                if (dynamicCrosshairY + i < 640 && dynamicCrosshairX != -1) bmp.SetPixel(dynamicCrosshairX, dynamicCrosshairY + i, Color.LimeGreen);
                if (dynamicCrosshairY - i > 0 && dynamicCrosshairX != -1) bmp.SetPixel(dynamicCrosshairX, dynamicCrosshairY - i, Color.LimeGreen);
                bmp.SetPixel(staticCrosshairX + i, staticCrosshairY, Color.Red);
                bmp.SetPixel(staticCrosshairX - i, staticCrosshairY, Color.Red);
                bmp.SetPixel(staticCrosshairX, staticCrosshairY + i, Color.Red);
                bmp.SetPixel(staticCrosshairX, staticCrosshairY - i, Color.Red);
            }
        }
        /// <summary>
        /// Draws the Static Crosshair only
        /// </summary>
        /// <param name="bmp"></param>
        public static void DrawCrosshairsStatic(Bitmap bmp)
        {
            for (int i = 0; i < 15; i++)
            {
                bmp.SetPixel(staticCrosshairX + i, staticCrosshairY, Color.Red);
                bmp.SetPixel(staticCrosshairX - i, staticCrosshairY, Color.Red);
                bmp.SetPixel(staticCrosshairX, staticCrosshairY + i, Color.Red);
                bmp.SetPixel(staticCrosshairX, staticCrosshairY - i, Color.Red);
            }
        }
        /// <summary>
        /// Sends commands according to where the Dynamic crosshair is in relation to the
        /// static crosshair
        /// </summary>
        public static void FindTarget()
        {
            //givingCommand = false;
            if (!givingCommand)
            {
                int alignInt = 15;

                //This checks whether the turret is all the way left or right
                int turretMaxCheck = previousDCrosshairX - dynamicCrosshairX;
                if (turretMaxCheck < 0) turretMaxCheck *= -1;
                Boolean turretMaxBool;
                if (turretMaxCheck < 5) turretMaxBool = true;
                else turretMaxBool = false;

                int xcheck = dynamicCrosshairX - staticCrosshairX;
                if (xcheck < 0) xcheck *= -1;
                int ycheck = dynamicCrosshairY - staticCrosshairY;
                if (ycheck < 0) ycheck *= -1;

                if (xcheck > alignInt) horizontalAligned = false;
                if (ycheck > alignInt) verticalAligned = false;

                if (xcheck < alignInt && !horizontalAligned)
                {
                    horizontalAligned = true;
                    //verticalAligned = false;
                    //movement.Stop();
                    formimage.SetText("Aligned Horizontally");
                }
                else if (dynamicCrosshairX > staticCrosshairX && !horizontalAligned)
                {
                    givingCommand = true;

                    if(turretMaxBool)
                        movement.MoveRight();
                    else
                    movement.TurretRight();

                    ControlledStop(xcheck);
                }
                else if (dynamicCrosshairX < staticCrosshairX && !horizontalAligned)
                {
                    givingCommand = true;

                    if(turretMaxBool)
                        movement.MoveLeft();
                    else
                    movement.TurretLeft();

                    ControlledStop(xcheck);
                }
                else if (ycheck < alignInt)
                {
                    if (!verticalAligned)
                    {
                        verticalAligned = true;
                        //horizontalAligned = false;
                        //movement.Stop();
                        formimage.SetText("Target Aligned!");
                    }
                }
                else if (dynamicCrosshairY > staticCrosshairY)
                {
                    givingCommand = true;
                    movement.TurretDown();
                    ControlledStop(ycheck);
                }
                else if (dynamicCrosshairY < staticCrosshairY)
                {
                    givingCommand = true;
                    movement.TurretUp();
                    ControlledStop(ycheck);
                }
            }
        }

        private static System.Timers.Timer controlledStop;

        /// <summary>
        /// Timer used to control the commands given by FindTarget()
        /// </summary>
        /// 
        
        private static void ControlledStop(int pixelCloseness)
        {
            //Create a formula for pixelCloseness relating to stopTimeInterval
            int stopTimeInterval;
            if (pixelCloseness > 50)
                stopTimeInterval = pixelCloseness * 2;
            else
                stopTimeInterval = pixelCloseness*10;

            controlledStop = new System.Timers.Timer();
            controlledStop.Elapsed += new ElapsedEventHandler(ControlledDelay);
            controlledStop.Interval = stopTimeInterval;
            controlledStop.Enabled = true;
        }
        private static void ControlledDelay(object source, ElapsedEventArgs e)
        {
            controlledStop.Stop();
            controlledStop.Close();
            movement.Stop();
            //Console.WriteLine(givingCommand);
            givingCommand = false;
            previousDCrosshairX = dynamicCrosshairX;
        }
    }
}
