﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using AForge.Video;
using System.Drawing;
using System.Drawing.Imaging;
using System.Runtime.InteropServices;

namespace RADSAT
{
    partial class MainRadsat
    {
        /// <summary>
        /// Handles a new frame event and edits the bitmap image retrieved from the event.
        /// This includes displaying, converting to black and white, drawing crosshairs, sending autonomous commands
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private static void video_NewFrame(object sender, NewFrameEventArgs e)
        {
            //if these equal -1 then no target is found
            dynamicCrosshairX = -1;
            dynamicCrosshairY = -1;

            //Retrieves the image from the camera
            Bitmap bitimage = e.Frame;
            Bitmap bitcopy = e.Frame;

            //Keeps an original copy of the bitmap
            if (!formimage.RobotVisionbool) bitcopy = CopyBitmap(bitimage);

            //Changes the pixels to black and white (black if the pixel does not match
            //the color, white if it does)
            ChangePixels(bitimage);
            //recognizes the target by shape
            ShapeRecognition(bitimage);
            
            //count used for FPS
            count++;

            if (formimage.Autonomousbool)
            {
                if (formimage.RobotVisionbool)
                {
                    //draws a static and dynamic crosshair.
                    //static crosshair is where the RADSAT is currently aiming
                    //dynamic crosshair is the centerpoint of the target (if a target is recognized)
                    DrawCrosshairs(bitimage);
                    //displays the new bitmap image
                    formimage.BitImage.Image = new Bitmap(bitimage);
                }
                else
                {
                    //Draws crosshairs
                    DrawCrosshairs(bitcopy);
                    //displays the new unedited (except for crosshairs) image
                    formimage.BitImage.Image = new Bitmap(bitcopy);
                }
            }
            else
            {
                //if set to manual mode no targeting will take place
                DrawCrosshairsStatic(bitcopy);
                formimage.BitImage.Image = new Bitmap(bitcopy);
            }

            bitimage.Dispose();
        }

        static public Bitmap CopyBitmap(Bitmap srcBitmap)
        {
            Rectangle section = new Rectangle(new Point(0,0), new Size(640, 480));
            // Create the new bitmap and associated graphics object
            Bitmap bmp = new Bitmap(section.Width, section.Height);
            Graphics g = Graphics.FromImage(bmp);

            // Draw the specified section of the source bitmap to the new one
            g.DrawImage(srcBitmap, 0, 0, section, GraphicsUnit.Pixel);

            // Clean up
            g.Dispose();

            // Return the bitmap
            return bmp;
        }
    }
}