﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net.Sockets;

namespace RADSAT
{
    partial class MainRadsat
    {
        class WifiBeeServer
        {
            static System.Net.Sockets.TcpClient tcpClient = new System.Net.Sockets.TcpClient();
            static NetworkStream networkStream;

            public void wifiBeeServerStart()
            {
                WServer();
            }
            public static void WServer()
            {
                String IP = "192.168.1.200";
                int port = 1001;
                formimage.SetText("Connecting to RADSAT.....");
                Boolean connected = WifiBeeConnect(IP, port);
                if (connected) formimage.SetText("Connected successfully to RADSAT");
                else formimage.SetText("Not able to connect to RADSAT");
            }
            private static bool WifiBeeConnect(string IP, int Port)
            {
                try
                {
                    tcpClient.Connect(IP, Port);
                    networkStream = tcpClient.GetStream();
                    if (!networkStream.CanWrite | !networkStream.CanRead)
                    {
                        tcpClient.Close();
                        networkStream = null;
                        return false;
                    }
                    return true;
                }
                catch { formimage.SetText("RADSAT Socket Error"); return false; }
            }

            public void WifiBeeWrite(string Output)
            {
                try
                {
                    if ((networkStream != null))
                    {
                        Byte[] sendBytes = Encoding.ASCII.GetBytes(Output);
                        Byte[] endByte = { 0xfe };
                        networkStream.Write(sendBytes, 0, sendBytes.Length);
                        networkStream.Write(endByte, 0, 1);
                    }
                    else
                    {
                        formimage.SetText("Wifi ERROR");
                    }
                }
                catch { formimage.SetText("Wifi Socket ERROR"); }
            }

            public void Arduino_Disconnect()
            {
                if ((networkStream != null))
                {
                    tcpClient.Close();
                    networkStream = null;
                }
            }
        }
    }
}
