package com.example.newradsat;

import android.os.AsyncTask;
import android.os.Bundle;
import android.app.Activity;
import android.util.Log;
import android.view.Menu;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;

import android.content.Intent;
import android.speech.RecognizerIntent;
import android.view.View;


public class RADSAT extends Activity {
	Socket s;
	
	
    //outgoing stream redirect to socket
    OutputStream out;
    DataOutputStream dataOut;
    BufferedReader input;
    SocketAddress save;
    String currentCommand = "-1";
    String [] acceptableCommands = {"alpha", "beta", "gamma", "stop", "fire"};
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_radsat);
        
        new connectSocket().execute();
    }

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
	    getMenuInflater().inflate(R.menu.activity_radsat, menu);
	    return true;
	}
	
	 private class connectSocket extends AsyncTask<Void, Void, Void> {
		 	@Override
		 	protected Void doInBackground(Void... urls) {
		        if(currentCommand.equals("-1")){
			        try {
			        	//InetAddress i = new InetAddress();
						s = new Socket("192.168.1.2", 1000);
						s.setKeepAlive(true);
						
						save = s.getRemoteSocketAddress();
						
					    //outgoing stream redirect to socket
					    out = s.getOutputStream();
					    dataOut = new DataOutputStream(out);
					    input = new BufferedReader(new InputStreamReader(s.getInputStream()));
					    
					} catch (UnknownHostException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
					return null;
		    	}
		 	
			 	else {
			 		sendData();
			 		return null;
			 	}
		 	}
	 }
	
    public void onRecord(View v){

    	Intent intent = new Intent("android.speech.action.RECOGNIZE_SPEECH");  
    	startActivityForResult(intent, 1234);  
    }
    
    @Override  
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {  
        
    	currentCommand = "error";

	        ArrayList<String> cool = data.getStringArrayListExtra(
                    RecognizerIntent.EXTRA_RESULTS);
	        currentCommand = getCurrentCommand(cool);
        
       // new connectSocket().execute();
        sendData();
    }
    
    public String getCurrentCommand(ArrayList <String> s){
    	
    	for(int i = 0; i < acceptableCommands.length; i++){
    		
    		Log.d(acceptableCommands[i], acceptableCommands[i]);
    		for(int g = 0; g < s.size(); g++){
	    		
    			Log.d(s.get(g), s.get(g));
    			if(s.get(g).charAt(0) == acceptableCommands[i].charAt(0))
	    			return acceptableCommands[i];
    		}
    	}
    	
    	return s.get(0);
    }
    
    public void sendData(){
    	
        try {
            
            if(s.isConnected())
            	dataOut.writeBytes(currentCommand);
            
            
            else {
            	s.connect(save);
			    out = s.getOutputStream();
			    dataOut = new DataOutputStream(out);
			    
			    dataOut.writeBytes(currentCommand);
            }
      
	    } catch (UnknownHostException e) {
	            // TODO Auto-generated catch block
	            e.printStackTrace();
	    } catch (IOException e) {
	            // TODO Auto-generated catch block
	            e.printStackTrace();
	    }
    }

}
