#include <Adafruit_CC3000.h>
#include <SPI.h>
#include <String.h>
#include "utility/debug.h"
#include "utility/socket.h"

#define IDLE_TIMEOUT_MS  3000    
                                   
                                   

#define ADAFRUIT_CC3000_IRQ   2 

#define ADAFRUIT_CC3000_VBAT  9
#define ADAFRUIT_CC3000_CS    10

//SCK = 13, MISO = 12, and MOSI = 11
Adafruit_CC3000 cc3000 = Adafruit_CC3000(ADAFRUIT_CC3000_CS, ADAFRUIT_CC3000_IRQ, ADAFRUIT_CC3000_VBAT,
                                         SPI_CLOCK_DIVIDER);

#define WLAN_SSID       "khalid"         
#define WLAN_PASS       "khaled373"

#define WLAN_SECURITY   WLAN_SEC_WPA2

#define LISTEN_PORT           7    // What TCP port to listen on for connections

Adafruit_CC3000_Server echoServer(LISTEN_PORT);

String tests = "";
uint32_t ipAddress;

int minPh = 658, maxPh = 512, minEc = 290, maxEc = 512, ecCount = 0, phCount = 0;

void setup(void)
{

  pinMode(4, OUTPUT);
  pinMode(5, OUTPUT);
  pinMode(6, OUTPUT);
  pinMode(7, OUTPUT);
  
  digitalWrite(4, HIGH);
  
  Serial.begin(115200);
  Serial.println(F("Hello, CC3000!\n")); 

  Serial.print("Free RAM: "); Serial.println(getFreeRam(), DEC);
  
  /* Initialise the module */
  Serial.println(F("\nInitializing..."));
  if (!cc3000.begin())
  {
    Serial.println(F("Couldn't begin()! Check your wiring?"));
    while(1);
  }
  
  Serial.print(F("\nAttempting to connect to ")); Serial.println(WLAN_SSID);
  if (!cc3000.connectToAP(WLAN_SSID, WLAN_PASS, WLAN_SECURITY)) {
    Serial.println(F("Failed!"));
    while(1);
  }
   
  Serial.println(F("Connected!"));
  
  Serial.println(F("Request DHCP"));
  while (!cc3000.checkDHCP())
  {
    delay(100); // ToDo: Insert a DHCP timeout!
  }  

  /* Display the IP address DNS, Gateway, etc. */  
  while (! displayConnectionDetails()) {
    delay(1000);
  }
  
  // Start listening for connections
  echoServer.begin();
  
  Serial.println(F("Listening for connections..."));
}



void loop(void)
{
  String tests = "";
  String results = "";
  int i = 0;
  // Try to get a client which is connected.
  Adafruit_CC3000_ClientRef client = echoServer.available();
  if (client) {
     // Check if there is data available to read.
     while (client.available() > 0) {
       // Read a byte and write it to all clients.
       uint8_t ch = client.read();
       delay(10);
       tests += (char)ch;
       
     }
     if(tests.indexOf(",") != -1) {
     
     int timeInterval = tests.substring(tests.indexOf(",") + 1, tests.lastIndexOf(",")).toInt();
     int numTimes = tests.substring(tests.lastIndexOf(",") +1).toInt();
    
    client.close();
   runTests(timeInterval, numTimes);
  }
  
  else if (tests.indexOf(".") != -1) {
    
    minPh = tests.substring(tests.indexOf(".")+1, tests.lastIndexOf(".")).toInt();
    maxPh = tests.substring(tests.lastIndexOf(".")+1, tests.indexOf("'")).toInt();
    minEc = tests.substring(tests.indexOf("'")+1, tests.lastIndexOf("'")).toInt();
    maxEc = tests.substring(tests.lastIndexOf("'")+1).toInt();
    
    client.close();
    
  }
  
     else {
         results = parseInfo(tests);
         
         if(results == "0") {
           client.close(); 
         }
         else {
           for(i = 0; i < results.length(); i++) {
             
             client.write(results.charAt(i));
             delay(50);
           }
           
           delay(3000);
           client.close();
         }
     }
  }
}

// +++++++++++++++++++++++++++++++GET webpage +++++++++++++++++++++++++++++++++++++++

void GET(String data)
{
   
  String temp = "/fromSystem/";
  temp += data;
  char test[temp.length()+1];
  temp.toCharArray(test, temp.length()+1);

  uint32_t ip = cc3000.IP2U32(192,168,0,101);
  cc3000.printIPdotsRev(ip);
  
  Adafruit_CC3000_Client www = cc3000.connectTCP(ip, 3000);
  if (www.connected()) {
    www.fastrprint(F("GET "));
    www.fastrprint(test);
    www.fastrprint(F(" HTTP/1.1\r\n"));
    www.fastrprint(F("Host: ")); 
    www.fastrprint(F("\r\n"));
    www.println();
  } else {
    Serial.println(F("Connection failed"));    
    return;
  }
  
Serial.println(F("-------------------------------------"));
  
  /* Read data until either the connection is closed, or the idle timeout is reached. */ 
  unsigned long lastRead = millis();
  while (www.connected() && (millis() - lastRead < IDLE_TIMEOUT_MS)) {
    while (www.available()) {
      char c = www.read();
      Serial.print(c);
      lastRead = millis();
    }
  }
  www.close();
  Serial.println(F("connection closed"));
  Serial.println(F("-------------------------------------"));
}

void runTests(int timeInterval, int numTimes) {
   
 while(numTimes > 0) {
   
  runDelay(timeInterval);
   runAllSensorTests();
   
  numTimes = numTimes -1;
 } 
 
 return;
  
}

void runDelay(int delayTime) {
   
  boolean flag = true;
  
  while(flag) {
     if(delayTime > 30) {
        
        delay(30*1000);
       delayTime = delayTime - 30; 
     }
     else {
       
       delay(delayTime*1000);
       flag = false;
     } 
  }
  
  return;
}

void runAllSensorTests() {
    
  String temp = "123,";
temp += ipString(ipAddress);
temp += ",";
int phValue = sensorTest(0,3,20);
runPhCorrection(phValue);
if(phCount > 7) {
 phValue = phValue*-1; 
}
temp += (String)phValue + ","; //ph
int ecValue = sensorTest(1,7,3);
runEcCorrection(ecValue);
if(ecCount > 7) {
 ecValue = ecValue*-1; 
}
temp += (String)ecValue + ","; //ec
temp += (String)sensorTest(3, 3, 1) + ","; //water level
temp += (String)sensorTest(2, 3, 1) + ","; //photoresistor
temp += minPh;
temp += ",";
temp += maxPh;
temp += ",";
temp += minEc;
temp += ",";
temp += maxEc;


GET(temp);

return;

}


String parseInfo(String tests) {
  
  //Unique device ID
 String temp = "123,"; 
temp += ipString(ipAddress);
temp += ",";
 
  if( tests.indexOf("ph") != -1) {

    temp += (String)sensorTest(0,3, 20) + ","; //IO 3 is empty

  }
  else {
    temp += "N/A,";
  }
  if (tests.indexOf("ec") != -1) {
    
    temp += (String)sensorTest(1,7,10) + ",";
  }
  else {
    temp += "N/A,";
  } 

  if (tests.indexOf("water") != -1){
    temp += (String)sensorTest(3, 3, 1) + ",";
   
  }
   else {
    temp += "N/A,";
  } 
  if (tests.indexOf("trans") != -1) {
    temp += (String)sensorTest(2, 3, 1) + ",";
  }
  else {
    temp += "N/A,";
  } 

  if (tests.indexOf("airpump2") != -1){
    temp += "airpump2,";
    runMotor(4, 5000);
  }
  else {
    temp += "N/A,";
  }
  if (tests.indexOf("nutpump") != -1){
    temp += "nutpump,";
    runMotor(5, 5);
  }
  else {
    temp += "N/A,";
  }
  if (tests.indexOf("bufferpump") != -1) {
    temp += "bufferpump,";
    runMotor(6, 5);
  }
 else {
    temp += "N/A,";
  } 
temp += minPh;
temp += ",";
temp += maxPh;
temp += ",";
temp += minEc;
temp += ",";
temp += maxEc;

 return temp;
  
}

void runPhCorrection(int phResult) {
  
  float offset;
  
  if(phResult < minPh && phResult > maxPh) {
    phCount =0;
    return;
  }
   else if(phResult < maxPh) {
      phCount = phCount +1;
       offset =  (maxPh - phResult)/73.14 *17.22/0.8;
       offset = (int)offset;
       runMotor(6,offset);
       return;
   }
   else {
      phCount = phCount +1;
      offset = (phResult - minPh)/73.14;
     offset = (int)offset;
      runMotor(5, offset); 
      return;
   }
}

void runEcCorrection(int ecResult) {
  
  if(ecResult > minEc && ecResult < maxEc) {
    ecCount =0;
    return;
  }
   else if(ecResult > maxEc) {
       return;
   }
   else {
      ecCount = ecCount +1;
      float offset = (minEc - ecResult)*2.92/14.58/0.86;
     offset = (int)offset;
      runMotor(5, offset); 
      return;
   }
}

void runMotor(int pinNum, int timeRun) {
 Serial.println("Motor Function Running");
 //pinMode(pinNum, OUTPUT);
 digitalWrite(pinNum, HIGH);
 runDelay(timeRun);
 digitalWrite(pinNum, LOW);
 return;
  
}

int sensorTest(int analogPin, int digitalPin, int delayTime) {
   
  digitalWrite(digitalPin, HIGH);
  runDelay(delayTime);
  int value = analogRead(analogPin);
  digitalWrite(digitalPin, LOW);
  Serial.println(value);
  return value;
}

String ipString(uint32_t ip) {
   return (String)(ip >> 24) + "." + (String)((ip >> 16) & 0xff) + "." + (String)((ip >> 8) & 0xff) + "." + (String)(ip & 0xff); 
}

bool displayConnectionDetails(void)
{
  uint32_t netmask, gateway, dhcpserv, dnsserv;
  
  if(!cc3000.getIPAddress(&ipAddress, &netmask, &gateway, &dhcpserv, &dnsserv))
  {
    Serial.println(F("Unable to retrieve the IP Address!\r\n"));
    return false;
  }
  else
  {
    
    Serial.print(F("\nIP Addr: ")); cc3000.printIPdotsRev(ipAddress);
    Serial.print(F("\nNetmask: ")); cc3000.printIPdotsRev(netmask);
    Serial.print(F("\nGateway: ")); cc3000.printIPdotsRev(gateway);
    Serial.print(F("\nDHCPsrv: ")); cc3000.printIPdotsRev(dhcpserv);
    Serial.print(F("\nDNSserv: ")); cc3000.printIPdotsRev(dnsserv);
    Serial.println();
    return true;
  }
}
