%load all capacitors from excel
%Make sure they're filtered for a reasonable bank price (< $1100 seems
%fine)
%Also filter by the ones that have ESR information

filename = 'filtered digikey aluminium capacitors.xlsx';
[input_array, text] = xlsread(filename, 'filtered',  'A2:J7394');
number_of_capacitor_types = length(input_array);

FUSING_CURRENT = 6000; %Amps

%Peak current usually happens in stage 2:
tau = 358.71946760715*10^-6; %Transit time in seconds

best_arangement = zeros(number_of_capacitor_types, 7); %[part_number, number_in_series, series_in_paralel, capacitance, ESR]

for h=[1:length(input_array)] %for each capacitor (each row)
%Iterate through all different arangements of capacitors
%capacitor = ();

%0.0047    1.2000    0.0000    0.2000    0.1660    0.0240       NaN    0.3400    1.5878

part_number = text(h); 
c   = input_array(h, 3); %In farads
v   = input_array(h, 4); %In volts
esr = input_array(h, 5)/1000; %In ohms
num_caps = input_array(h, 8);
bank_price = input_array(h, 9);


divisors = divisor(num_caps); %Number of combinations
for d=divisors
    %find next combination (%starts with All in seris, 1 in paralalel, and
    %end with 1 in series all in paralel.
    in_series = num_caps/d;
    in_paralel = d;

    [capacitance, voltage, r] = get_bank(c, v, esr, in_series, in_paralel);
    
    %For each arangement, calculate the peak current given it's resulting C and
    %the calculated L (based on formula from other worksheet) If it's Greater
    %than fusing current, then move on to next cobination

    inductance = (tau/pi)^2/capacitance;
    I_peak = voltage*(capacitance/inductance);
    if I_peak < FUSING_CURRENT; %If less than fusing current Store this arangement's ESR
        if or((r < best_arangement(h, 5)), (best_arangement(h, 5) == 0))
            best_arangement(h, 1) = h;
            best_arangement(h, 2) = in_series;
            best_arangement(h, 3) = in_paralel;
            best_arangement(h, 4) = capacitance;
            best_arangement(h, 5) = r;
            best_arangement(h, 6) = voltage;
            best_arangement(h, 7) = bank_price;
        end
    end
end %end iteration for all arengements

end


%From all arangements, find one with lowest ESR. Sotre it in best_arangement
%This can be bundled into each combination's check for speed
best = zeros(1, 5);
best(5) = 1000000000000000000000000;

for b = [1: length(best_arangement)]
    if (best_arangement(b, 5) < best(5))
        %best(1) = best_arangement(b, 1);
        best(2) = best_arangement(b, 2);
        best(3) = best_arangement(b, 3);
        best(4) = best_arangement(b, 4);
        best(5) = best_arangement(b, 5);
    end
end

dlmwrite('best_arangement.csv', best_arangement);
