function [capacitance_o, voltage_o, esr_o] = get_bank(capacitance, voltage, esr, series, paralel)
%capacitance, voltage, esr = get_bank(capacitance, voltage, esr, in_series, in_paralel)
% This function takes in a single capacitor unit, the way it is aranged
% (number in series and number in paralel) and reurns the bank's
% attributes.
%Inputs
%capacitance - farads
%voltage - volts
%esr - ohm
%series - Elements in series
%paralel - Series elements in paralel

%Output
%capacitance - farads
%voltage - volts
%esr - ohm

%First combine elements in series
capacitance_s = 1/(series/capacitance);
voltage_o = series*voltage;
esr_s = esr*series;


%The combine the above combination in paralel
capacitance_o = paralel * capacitance_s;
esr_o = 1/(paralel/esr_s);

end

