function [L , N, COST, WEIGHT, current_needed] = get_number_of_cells(capacitance, ESR, V, tau, switch_R, number_of_stages, inner_diameter, coil_length, gauge, energy_per_coil)
%cell - each cell's capacitance
%ESR - each cell's ESR
%V - each cell's voltage
%tau - time to fully charge coils
%switch_R - the switches' resistance


for n = [1: 10000]
    %n - number of cells aranged in series
    C = capacitance/n;
    voltage = V*n;
    esr = ESR*n;
    
    L = (2*tau/pi)^2*number_of_stages/C; %H - Henries
    [resistance, turns, level, diammax, meters, cost, weight] = make_inductor2(L*1000, inner_diameter, coil_length, gauge);
    R = esr+resistance+switch_R;
    
    beta = sqrt(1/(L*C) - R^2/(4*L^2));
    alpha = R/(2*L);
    
    current_needed = sqrt(2*energy_per_coil/L);
    voltage_needed = current_needed*L*abs(beta);
    
    if voltage >= voltage_needed
        N = n;
        current_needed
        voltage_needed
        COST = cost*number_of_stages;
        WEIGHT = weight*number_of_stages;
        meters = meters*number_of_stages
        break;
    end
end

